/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.inmemory;

import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class InMemoryEventStorageEngine
implements EventStorageEngine {
    private final NavigableMap<TrackingToken, TrackedEventMessage<?>> events = new ConcurrentSkipListMap();
    private final Map<String, List<DomainEventMessage<?>>> snapshots = new ConcurrentHashMap();
    private final long offset;

    public InMemoryEventStorageEngine() {
        this(0L);
    }

    public InMemoryEventStorageEngine(long offset) {
        this.offset = offset;
    }

    @Override
    public void appendEvents(@Nonnull List<? extends EventMessage<?>> events) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().onPrepareCommit(uow -> this.storeEvents(events));
        } else {
            this.storeEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEvents(List<? extends EventMessage<?>> events) {
        NavigableMap<TrackingToken, TrackedEventMessage<?>> navigableMap = this.events;
        synchronized (navigableMap) {
            GlobalSequenceTrackingToken trackingToken = this.nextTrackingToken();
            this.events.putAll(IntStream.range(0, events.size()).mapToObj(i -> EventUtils.asTrackedEventMessage((EventMessage)((EventMessage)events.get(i)), (TrackingToken)trackingToken.offsetBy(i))).collect(Collectors.toMap(TrackedEventMessage::trackingToken, Function.identity())));
        }
    }

    @Override
    public void storeSnapshot(@Nonnull DomainEventMessage<?> snapshot) {
        this.snapshots.compute(snapshot.getAggregateIdentifier(), (aggregateId, snapshotsSoFar) -> {
            if (snapshotsSoFar == null) {
                CopyOnWriteArrayList<DomainEventMessage> newSnapshots = new CopyOnWriteArrayList<DomainEventMessage>();
                newSnapshots.add(snapshot);
                return newSnapshots;
            }
            snapshotsSoFar.add(snapshot);
            return snapshotsSoFar;
        });
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        return StreamSupport.stream(new MapEntrySpliterator(this.events, trackingToken), false);
    }

    @Override
    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier, long firstSequenceNumber) {
        AtomicReference sequenceNumber = new AtomicReference();
        Stream<DomainEventMessage> stream = this.events.values().stream().filter(event -> event instanceof DomainEventMessage).map(event -> (DomainEventMessage)event).filter(event -> aggregateIdentifier.equals(event.getAggregateIdentifier()) && event.getSequenceNumber() >= firstSequenceNumber).peek(event -> sequenceNumber.set(event.getSequenceNumber()));
        return DomainEventStream.of(stream, sequenceNumber::get);
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(@Nonnull String aggregateIdentifier) {
        return this.snapshots.getOrDefault(aggregateIdentifier, Collections.emptyList()).stream().max(Comparator.comparingLong(DomainEventMessage::getSequenceNumber));
    }

    @Override
    public TrackingToken createTailToken() {
        if (this.events.size() == 0) {
            return null;
        }
        GlobalSequenceTrackingToken firstToken = (GlobalSequenceTrackingToken)this.events.firstKey();
        return new GlobalSequenceTrackingToken(firstToken.getGlobalIndex() - 1L);
    }

    @Override
    public TrackingToken createHeadToken() {
        if (this.events.size() == 0) {
            return null;
        }
        return (TrackingToken)this.events.lastKey();
    }

    @Override
    public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        return this.events.values().stream().filter(event -> event.getTimestamp().equals(dateTime) || event.getTimestamp().isAfter(dateTime)).min(Comparator.comparingLong(e -> ((GlobalSequenceTrackingToken)e.trackingToken()).getGlobalIndex())).map(TrackedEventMessage::trackingToken).map(tt -> (GlobalSequenceTrackingToken)tt).map(tt -> new GlobalSequenceTrackingToken(tt.getGlobalIndex() - 1L)).map(tt -> tt).orElseGet(this::createHeadToken);
    }

    protected GlobalSequenceTrackingToken nextTrackingToken() {
        return this.events.isEmpty() ? new GlobalSequenceTrackingToken(this.offset) : ((GlobalSequenceTrackingToken)this.events.lastKey()).next();
    }

    private static class MapEntrySpliterator
    extends Spliterators.AbstractSpliterator<TrackedEventMessage<?>> {
        private final NavigableMap<TrackingToken, TrackedEventMessage<?>> source;
        private volatile TrackingToken lastToken;

        public MapEntrySpliterator(NavigableMap<TrackingToken, TrackedEventMessage<?>> source, TrackingToken trackingToken) {
            super(Long.MAX_VALUE, 16);
            this.source = source;
            this.lastToken = trackingToken;
        }

        @Override
        public boolean tryAdvance(Consumer<? super TrackedEventMessage<?>> action) {
            Map.Entry<TrackingToken, TrackedEventMessage<?>> next = this.lastToken != null ? this.source.higherEntry(this.lastToken) : this.source.firstEntry();
            if (next != null) {
                this.lastToken = next.getKey();
                action.accept(next.getValue());
            }
            return next != null;
        }
    }
}

