/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import jakarta.persistence.EntityExistsException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.common.io.IOUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLErrorCodesResolver
implements PersistenceExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(SQLErrorCodesResolver.class);
    private static final String SQL_ERROR_CODES_PROPERTIES = "SQLErrorCode.properties";
    private static final String KEY_CODE_SUFFIX = ".duplicateKeyCodes";
    private static final String PATTERN_SUFFIX = ".pattern";
    private static final String LIST_SEPARATOR = ",";
    private List<Integer> duplicateKeyCodes = Collections.emptyList();

    public SQLErrorCodesResolver(List<Integer> duplicateKeyCodes) {
        this.duplicateKeyCodes = duplicateKeyCodes;
    }

    public SQLErrorCodesResolver(DataSource dataSource) throws SQLException {
        Properties properties = this.loadDefaultPropertyFile();
        this.initialize(properties, this.getDatabaseProductNameFromDataSource(dataSource));
    }

    public SQLErrorCodesResolver(String databaseProductName) {
        this.initialize(this.loadDefaultPropertyFile(), databaseProductName);
    }

    public SQLErrorCodesResolver(Properties properties, String databaseProductName) {
        this.initialize(properties, databaseProductName);
    }

    public SQLErrorCodesResolver(Properties properties, DataSource dataSource) throws SQLException {
        this.initialize(properties, this.getDatabaseProductNameFromDataSource(dataSource));
    }

    private void initialize(Properties properties, String databaseProductName) {
        this.duplicateKeyCodes = this.loadKeyViolationCodes(databaseProductName, properties);
    }

    public boolean isDuplicateKeyViolation(Exception exception) {
        return this.causeIsEntityExistsException(exception) || ExceptionUtils.findException((Throwable)exception, SQLException.class).map(sqlException -> this.isDuplicateKeyCode((SQLException)sqlException, this.duplicateKeyCodes)).orElse(false) != false;
    }

    protected boolean isDuplicateKeyCode(SQLException sqlException, List<Integer> errorCodes) {
        if (errorCodes.contains(sqlException.getErrorCode())) {
            return true;
        }
        if (sqlException.getSQLState() != null) {
            try {
                return errorCodes.contains(Integer.parseInt(sqlException.getSQLState()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private boolean causeIsEntityExistsException(Throwable exception) {
        return exception instanceof EntityExistsException || exception.getCause() != null && this.causeIsEntityExistsException(exception.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseProductNameFromDataSource(DataSource dataSource) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String string = connection.getMetaData().getDatabaseProductName();
            return string;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.warn("An error occurred while trying to close the database connection. Ignoring...", (Throwable)e);
            }
        }
    }

    private List<Integer> loadKeyViolationCodes(String databaseProductName, Properties properties) {
        String[] codes;
        String key = databaseProductName.replace(" ", "_") + KEY_CODE_SUFFIX;
        String property = properties.getProperty(key);
        ArrayList<Integer> keyCodes = new ArrayList<Integer>();
        if (property == null) {
            for (String k : properties.stringPropertyNames()) {
                String pattern;
                if (!k.endsWith(PATTERN_SUFFIX) || !databaseProductName.matches(pattern = properties.getProperty(k))) continue;
                property = properties.getProperty(k.substring(0, k.length() - PATTERN_SUFFIX.length()) + KEY_CODE_SUFFIX);
            }
            if (property == null) {
                throw new AxonConfigurationException(String.format("The database product name '%s' is unknown. No SQLCode configuration is known for that database.", databaseProductName));
            }
        }
        for (String code : codes = property.split(LIST_SEPARATOR)) {
            keyCodes.add(Integer.valueOf(code));
        }
        return keyCodes;
    }

    private Properties loadDefaultPropertyFile() {
        Properties properties = new Properties();
        InputStream resources = null;
        try {
            resources = SQLErrorCodesResolver.class.getResourceAsStream(SQL_ERROR_CODES_PROPERTIES);
            properties.load(resources);
        }
        catch (IOException e) {
            throw new AxonConfigurationException("Unable to read from a file that should be ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)resources);
        }
        return properties;
    }
}

