/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.CachingEventSourcingRepository;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.conflictresolution.ConflictResolution;
import org.axonframework.eventsourcing.conflictresolution.DefaultConflictResolver;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.axonframework.modelling.command.LockingRepository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.tracing.SpanFactory;

public class EventSourcingRepository<T>
extends LockingRepository<T, EventSourcedAggregate<T>> {
    private final EventStore eventStore;
    private final SnapshotTriggerDefinition snapshotTriggerDefinition;
    private final AggregateFactory<T> aggregateFactory;
    private final RepositoryProvider repositoryProvider;
    private final Predicate<? super DomainEventMessage<?>> eventStreamFilter;

    protected EventSourcingRepository(Builder<T> builder) {
        super(builder);
        this.eventStore = builder.eventStore;
        this.aggregateFactory = ((Builder)builder).buildAggregateFactory();
        this.snapshotTriggerDefinition = builder.snapshotTriggerDefinition;
        this.repositoryProvider = builder.repositoryProvider;
        this.eventStreamFilter = builder.eventStreamFilter;
    }

    public static <T> Builder<T> builder(Class<T> aggregateType) {
        return new Builder<T>(aggregateType);
    }

    protected EventSourcedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        SnapshotTrigger trigger = this.snapshotTriggerDefinition.prepareTrigger(this.aggregateFactory.getAggregateType());
        DomainEventStream eventStream = this.readEvents(aggregateIdentifier);
        if (!eventStream.hasNext()) {
            throw new AggregateNotFoundException(aggregateIdentifier, "The aggregate was not found in the event store");
        }
        AggregateModel model = this.aggregateModel();
        EventSourcedAggregate aggregate = (EventSourcedAggregate)((Object)this.spanFactory.createInitializeStateSpan(model.type(), aggregateIdentifier).runSupplier(() -> this.doLoadAggregate(aggregateIdentifier, trigger, eventStream, model)));
        if (aggregate.isDeleted()) {
            throw new AggregateDeletedException(aggregateIdentifier);
        }
        return aggregate;
    }

    private EventSourcedAggregate<T> doLoadAggregate(String aggregateIdentifier, SnapshotTrigger trigger, DomainEventStream eventStream, AggregateModel<T> model) {
        EventSourcedAggregate<T> loadingAggregate = EventSourcedAggregate.initialize(this.aggregateFactory.createAggregateRoot(aggregateIdentifier, eventStream.peek()), model, (EventBus)this.eventStore, this.repositoryProvider, trigger);
        loadingAggregate.initializeState(eventStream);
        return loadingAggregate;
    }

    protected DomainEventStream readEvents(String aggregateIdentifier) {
        DomainEventStream fullStream = this.eventStore.readEvents(aggregateIdentifier);
        return this.eventStreamFilter != null ? fullStream.filter(this.eventStreamFilter) : fullStream;
    }

    protected void validateOnLoad(Aggregate<T> aggregate, Long expectedVersion) {
        if (expectedVersion != null && expectedVersion < aggregate.version()) {
            DefaultConflictResolver conflictResolver = new DefaultConflictResolver(this.eventStore, aggregate.identifierAsString(), expectedVersion, aggregate.version());
            ConflictResolution.initialize(conflictResolver);
            CurrentUnitOfWork.get().onPrepareCommit(uow -> conflictResolver.ensureConflictsResolved());
        } else {
            super.validateOnLoad(aggregate, expectedVersion);
        }
    }

    protected void reportIllegalState(LockAwareAggregate<T, EventSourcedAggregate<T>> aggregate) {
    }

    protected EventSourcedAggregate<T> doCreateNewForLock(Callable<T> factoryMethod) throws Exception {
        return EventSourcedAggregate.initialize(factoryMethod, this.aggregateModel(), (EventBus)this.eventStore, this.repositoryProvider, this.snapshotTriggerDefinition.prepareTrigger(this.getAggregateType()));
    }

    protected void doSaveWithLock(EventSourcedAggregate<T> aggregate) {
    }

    protected void doDeleteWithLock(EventSourcedAggregate<T> aggregate) {
    }

    public AggregateFactory<T> getAggregateFactory() {
        return this.aggregateFactory;
    }

    public static class Builder<T>
    extends LockingRepository.Builder<T> {
        protected EventStore eventStore;
        protected SnapshotTriggerDefinition snapshotTriggerDefinition = NoSnapshotTriggerDefinition.INSTANCE;
        private AggregateFactory<T> aggregateFactory;
        protected RepositoryProvider repositoryProvider;
        protected Cache cache;
        protected Predicate<? super DomainEventMessage<?>> eventStreamFilter;

        protected Builder(Class<T> aggregateType) {
            super(aggregateType);
        }

        public Builder<T> parameterResolverFactory(@Nonnull ParameterResolverFactory parameterResolverFactory) {
            super.parameterResolverFactory(parameterResolverFactory);
            return this;
        }

        public Builder<T> handlerDefinition(@Nonnull HandlerDefinition handlerDefinition) {
            super.handlerDefinition(handlerDefinition);
            return this;
        }

        public Builder<T> aggregateModel(@Nonnull AggregateModel<T> aggregateModel) {
            super.aggregateModel(aggregateModel);
            return this;
        }

        public Builder<T> lockFactory(LockFactory lockFactory) {
            super.lockFactory(lockFactory);
            return this;
        }

        public Builder<T> subtypes(@Nonnull Set<Class<? extends T>> subtypes) {
            super.subtypes(subtypes);
            return this;
        }

        public Builder<T> subtype(@Nonnull Class<? extends T> subtype) {
            super.subtype(subtype);
            return this;
        }

        @Deprecated
        public Builder<T> spanFactory(SpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public Builder<T> spanFactory(RepositorySpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public Builder<T> eventStore(EventStore eventStore) {
            BuilderUtils.assertNonNull((Object)eventStore, (String)"EventStore may not be null");
            this.eventStore = eventStore;
            return this;
        }

        public Builder<T> snapshotTriggerDefinition(SnapshotTriggerDefinition snapshotTriggerDefinition) {
            BuilderUtils.assertNonNull((Object)snapshotTriggerDefinition, (String)"SnapshotTriggerDefinition may not be null");
            this.snapshotTriggerDefinition = snapshotTriggerDefinition;
            return this;
        }

        public Builder<T> aggregateFactory(AggregateFactory<T> aggregateFactory) {
            BuilderUtils.assertNonNull(aggregateFactory, (String)"AggregateFactory may not be null");
            this.aggregateFactory = aggregateFactory;
            return this;
        }

        public Builder<T> repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        public Builder<T> cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder<T> eventStreamFilter(Predicate<? super DomainEventMessage<?>> filter) {
            this.eventStreamFilter = filter;
            return this;
        }

        public Builder<T> filterByAggregateType() {
            String aggregateType = this.buildAggregateModel().type();
            return this.eventStreamFilter(event -> aggregateType.equals(event.getType()));
        }

        public <R extends EventSourcingRepository<T>> R build() {
            return (R)((Object)(this.cache != null ? new CachingEventSourcingRepository(this) : new EventSourcingRepository(this)));
        }

        private AggregateFactory<T> buildAggregateFactory() {
            if (this.aggregateFactory == null) {
                return new GenericAggregateFactory(this.buildAggregateModel());
            }
            return this.aggregateFactory;
        }

        protected void validate() {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.eventStore, (String)"The EventStore is a hard requirement and should be provided");
            if (this.aggregateFactory == null) {
                BuilderUtils.assertNonNull((Object)this.aggregateType, (String)"No AggregateFactory is set, whilst either it or the aggregateType is a hard requirement");
                return;
            }
            BuilderUtils.assertNonNull(this.aggregateFactory, (String)"No aggregateType is set, whilst either it or the AggregateFactory is a hard requirement");
        }
    }
}

