/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventsourcing.SnapshotterSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultSnapshotterSpanFactory
implements SnapshotterSpanFactory {
    private final SpanFactory spanFactory;
    private final boolean separateTrace;
    private final boolean aggregateTypeInSpanName;

    protected DefaultSnapshotterSpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.separateTrace = builder.builderSeparateTrace;
        this.aggregateTypeInSpanName = builder.builderAggregateTypeInSpanName;
    }

    @Override
    public Span createScheduleSnapshotSpan(String aggregateType, String aggregateIdentifier) {
        return this.spanFactory.createInternalSpan(() -> this.createSpanName("Snapshotter.scheduleSnapshot", aggregateType)).addAttribute("aggregateIdentifier", aggregateIdentifier);
    }

    @Override
    public Span createCreateSnapshotSpan(String aggregateType, String aggregateIdentifier) {
        Supplier<String> spanName = () -> this.createSpanName("Snapshotter.createSnapshot", aggregateType);
        if (this.separateTrace) {
            return this.spanFactory.createRootTrace(spanName).addAttribute("aggregateIdentifier", aggregateIdentifier);
        }
        return this.spanFactory.createInternalSpan(spanName).addAttribute("aggregateIdentifier", aggregateIdentifier);
    }

    private String createSpanName(String spanName, String aggregateType) {
        if (this.aggregateTypeInSpanName) {
            return String.format("%s(%s)", spanName, aggregateType);
        }
        return spanName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private boolean builderSeparateTrace = false;
        private boolean builderAggregateTypeInSpanName = true;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder separateTrace(boolean separateTrace) {
            this.builderSeparateTrace = separateTrace;
            return this;
        }

        public Builder aggregateTypeInSpanName(boolean aggregateTypeInSpanName) {
            this.builderAggregateTypeInSpanName = aggregateTypeInSpanName;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.builderSpanFactory, (String)"spanFactory may not be null");
        }

        public DefaultSnapshotterSpanFactory build() {
            return new DefaultSnapshotterSpanFactory(this);
        }
    }
}

