/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.LifecycleOperations;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.tracing.SpanFactory;

public interface Configurer
extends LifecycleOperations {
    public Configurer registerEventUpcaster(@Nonnull Function<Configuration, EventUpcaster> var1);

    public Configurer configureMessageMonitor(@Nonnull Function<Configuration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> var1);

    default public Configurer configureMessageMonitor(@Nonnull Class<?> componentType, @Nonnull Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(componentType, (Configuration configuration, Class<?> type, String name) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public Configurer configureMessageMonitor(@Nonnull Class<?> var1, @Nonnull MessageMonitorFactory var2);

    default public Configurer configureMessageMonitor(@Nonnull Class<?> componentType, @Nonnull String componentName, @Nonnull Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(componentType, componentName, (Configuration configuration, Class<?> type, String name) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public Configurer configureMessageMonitor(@Nonnull Class<?> var1, @Nonnull String var2, @Nonnull MessageMonitorFactory var3);

    public Configurer configureCorrelationDataProviders(@Nonnull Function<Configuration, List<CorrelationDataProvider>> var1);

    public Configurer registerModule(@Nonnull ModuleConfiguration var1);

    public <C> Configurer registerComponent(@Nonnull Class<C> var1, @Nonnull Function<Configuration, ? extends C> var2);

    public Configurer registerCommandHandler(@Nonnull Function<Configuration, Object> var1);

    @Deprecated
    default public Configurer registerCommandHandler(int phase, @Nonnull Function<Configuration, Object> commandHandlerBuilder) {
        return this.registerCommandHandler(commandHandlerBuilder);
    }

    public Configurer registerQueryHandler(@Nonnull Function<Configuration, Object> var1);

    @Deprecated
    default public Configurer registerQueryHandler(int phase, @Nonnull Function<Configuration, Object> queryHandlerBuilder) {
        return this.registerQueryHandler(queryHandlerBuilder);
    }

    public Configurer registerMessageHandler(@Nonnull Function<Configuration, Object> var1);

    public Configurer configureEmbeddedEventStore(@Nonnull Function<Configuration, EventStorageEngine> var1);

    default public Configurer configureEventStore(@Nonnull Function<Configuration, EventStore> eventStoreBuilder) {
        return this.registerComponent(EventBus.class, eventStoreBuilder);
    }

    default public Configurer configureEventBus(@Nonnull Function<Configuration, EventBus> eventBusBuilder) {
        return this.registerComponent(EventBus.class, eventBusBuilder);
    }

    default public Configurer configureCommandBus(@Nonnull Function<Configuration, CommandBus> commandBusBuilder) {
        return this.registerComponent(CommandBus.class, commandBusBuilder);
    }

    default public Configurer configureQueryBus(@Nonnull Function<Configuration, QueryBus> queryBusBuilder) {
        return this.registerComponent(QueryBus.class, queryBusBuilder);
    }

    default public Configurer configureQueryUpdateEmitter(@Nonnull Function<Configuration, QueryUpdateEmitter> queryUpdateEmitterBuilder) {
        return this.registerComponent(QueryUpdateEmitter.class, queryUpdateEmitterBuilder);
    }

    default public Configurer configureSerializer(@Nonnull Function<Configuration, Serializer> serializerBuilder) {
        return this.registerComponent(Serializer.class, serializerBuilder);
    }

    public Configurer configureEventSerializer(@Nonnull Function<Configuration, Serializer> var1);

    public Configurer configureMessageSerializer(@Nonnull Function<Configuration, Serializer> var1);

    default public Configurer configureTransactionManager(@Nonnull Function<Configuration, TransactionManager> transactionManagerBuilder) {
        return this.registerComponent(TransactionManager.class, transactionManagerBuilder);
    }

    default public Configurer configureResourceInjector(@Nonnull Function<Configuration, ResourceInjector> resourceInjectorBuilder) {
        return this.registerComponent(ResourceInjector.class, resourceInjectorBuilder);
    }

    default public Configurer configureTags(@Nonnull Function<Configuration, TagsConfiguration> tagsBuilder) {
        return this.registerComponent(TagsConfiguration.class, tagsBuilder);
    }

    public <A> Configurer configureAggregate(@Nonnull AggregateConfiguration<A> var1);

    default public <A> Configurer configureAggregate(@Nonnull Class<A> aggregate) {
        return this.configureAggregate(AggregateConfigurer.defaultConfiguration(aggregate));
    }

    public Configurer registerHandlerDefinition(@Nonnull BiFunction<Configuration, Class, HandlerDefinition> var1);

    public Configurer registerHandlerEnhancerDefinition(Function<Configuration, HandlerEnhancerDefinition> var1);

    default public Configurer configureSnapshotter(@Nonnull Function<Configuration, Snapshotter> snapshotterBuilder) {
        return this.registerComponent(Snapshotter.class, snapshotterBuilder);
    }

    default public Configurer configureDeadlineManager(@Nonnull Function<Configuration, DeadlineManager> deadlineManagerBuilder) {
        return this.registerComponent(DeadlineManager.class, deadlineManagerBuilder);
    }

    default public Configurer configureSpanFactory(@Nonnull Function<Configuration, SpanFactory> spanFactory) {
        return this.registerComponent(SpanFactory.class, spanFactory);
    }

    public EventProcessingConfigurer eventProcessing() throws AxonConfigurationException;

    default public Configurer eventProcessing(@Nonnull Consumer<EventProcessingConfigurer> eventProcessingConfigurer) throws AxonConfigurationException {
        eventProcessingConfigurer.accept(this.eventProcessing());
        return this;
    }

    default public Configurer registerEventHandler(@Nonnull Function<Configuration, Object> eventHandlerBuilder) {
        this.eventProcessing().registerEventHandler(eventHandlerBuilder);
        return this;
    }

    default public Configurer configureLifecyclePhaseTimeout(long timeout, TimeUnit timeUnit) {
        return this;
    }

    default public void onInitialize(@Nonnull Consumer<Configuration> initHandler) {
        this.registerModule(initHandler::accept);
    }

    public Configuration buildConfiguration();

    default public Configuration start() {
        Configuration configuration = this.buildConfiguration();
        configuration.start();
        return configuration;
    }
}

