/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.config.Configuration;
import org.axonframework.config.LifecycleHandler;
import org.axonframework.config.LifecycleOperations;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.lifecycle.LifecycleHandlerInvocationException;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.lifecycle.StartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecycleHandlerInspector {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LIFECYCLE_PHASE_ATTRIBUTE_NAME = "phase";

    private LifecycleHandlerInspector() {
    }

    public static void registerLifecycleHandlers(final Configuration configuration, Object component) {
        if (component == null) {
            logger.debug("Ignoring [null] component for inspection as it wont participate in the lifecycle");
            return;
        }
        if (component instanceof Lifecycle) {
            ((Lifecycle)component).registerLifecycleHandlers(new Lifecycle.LifecycleRegistry(){

                public void onStart(int phase, @Nonnull Lifecycle.LifecycleHandler action) {
                    configuration.onStart(phase, () -> ((Lifecycle.LifecycleHandler)action).run());
                }

                public void onShutdown(int phase, @Nonnull Lifecycle.LifecycleHandler action) {
                    configuration.onShutdown(phase, () -> ((Lifecycle.LifecycleHandler)action).run());
                }
            });
        } else {
            LifecycleHandlerInspector.registerLifecycleHandlers(configuration, component, StartHandler.class, LifecycleOperations::onStart);
            LifecycleHandlerInspector.registerLifecycleHandlers(configuration, component, ShutdownHandler.class, LifecycleOperations::onShutdown);
        }
    }

    private static void registerLifecycleHandlers(Configuration configuration, Object component, Class<? extends Annotation> lifecycleAnnotation, LifecycleRegistration registrationMethod) {
        for (Method method : ReflectionUtils.methodsOf(component.getClass())) {
            AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, lifecycleAnnotation).ifPresent(lifecycleAnnotationAttributes -> {
                if (method.getParameterCount() > 0) {
                    throw new AxonConfigurationException(String.format("The @%s annotated method [%s] should not contain any parameters as none are allowed on lifecycle handlers", lifecycleAnnotation.getSimpleName(), method));
                }
                int phase = (Integer)lifecycleAnnotationAttributes.get(LIFECYCLE_PHASE_ATTRIBUTE_NAME);
                LifecycleHandler lifecycleHandler = () -> LifecycleHandlerInspector.invokeAndReturn(component, method, lifecycleAnnotation.getSimpleName(), phase);
                registrationMethod.registerLifecycleHandler(configuration, phase, lifecycleHandler);
                logger.debug("Found and registered a {} with phase [{}] from component [{}]", new Object[]{lifecycleAnnotation.getSimpleName(), phase, component.getClass().getSimpleName()});
            });
        }
    }

    private static CompletableFuture<?> invokeAndReturn(Object lifecycleComponent, Method lifecycleHandler, String handlerType, int phase) {
        try {
            logger.debug("Invoking {} from component [{}] in phase [{}]", new Object[]{handlerType, lifecycleComponent.getClass().getSimpleName(), phase});
            Object result = ReflectionUtils.invokeAndGetMethodValue((Method)lifecycleHandler, (Object)lifecycleComponent);
            return result instanceof CompletableFuture ? (CompletableFuture<Object>)result : CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            CompletableFuture exceptionallyCompletedFuture = new CompletableFuture();
            exceptionallyCompletedFuture.completeExceptionally((Throwable)new LifecycleHandlerInvocationException(lifecycleHandler, lifecycleComponent, (Throwable)e));
            return exceptionallyCompletedFuture;
        }
    }

    @FunctionalInterface
    private static interface LifecycleRegistration {
        public void registerLifecycleHandler(Configuration var1, int var2, LifecycleHandler var3);
    }
}

