/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.LoggingDuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.ConfigurationParameterResolverFactory;
import org.axonframework.config.ConfigurationResourceInjector;
import org.axonframework.config.ConfigurationScopeAwareProvider;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.LifecycleHandler;
import org.axonframework.config.MessageHandlerRegistrar;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.MessageMonitorFactoryBuilder;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.SimpleDeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.lifecycle.LifecycleHandlerInvocationException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jpa.JpaSagaStore;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurer
implements Configurer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int LIFECYCLE_PHASE_TIMEOUT_SECONDS = 5;
    private final Configuration config = new ConfigurationImpl();
    private final MessageMonitorFactoryBuilder messageMonitorFactoryBuilder = new MessageMonitorFactoryBuilder();
    private final Component<BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> messageMonitorFactoryComponent = new Component<BiFunction>(this.config, "monitorFactory", this.messageMonitorFactoryBuilder::build);
    private final Component<List<CorrelationDataProvider>> correlationProviders = new Component<List>(this.config, "correlationProviders", c -> Collections.singletonList(new MessageOriginProvider()));
    private final Map<Class<?>, Component<?>> components = new ConcurrentHashMap();
    private final List<Component<MessageHandlerRegistrar>> messageHandlerRegistrars = new ArrayList<Component<MessageHandlerRegistrar>>();
    private final Component<Serializer> eventSerializer = new Component<Serializer>(this.config, "eventSerializer", Configuration::messageSerializer);
    private final Component<Serializer> messageSerializer = new Component<Serializer>(this.config, "messageSerializer", Configuration::serializer);
    private final List<Component<EventUpcaster>> upcasters = new ArrayList<Component<EventUpcaster>>();
    private final Component<EventUpcasterChain> upcasterChain = new Component<EventUpcasterChain>(this.config, "eventUpcasterChain", c -> new EventUpcasterChain(this.upcasters.stream().map(Component::get).collect(Collectors.toList())));
    private final Component<Function<Class<?>, HandlerDefinition>> handlerDefinition = new Component<Function>(this.config, "handlerDefinition", c -> this::defaultHandlerDefinition);
    private final List<Consumer<Configuration>> initHandlers = new ArrayList<Consumer<Configuration>>();
    private final TreeMap<Integer, List<LifecycleHandler>> startHandlers = new TreeMap();
    private final TreeMap<Integer, List<LifecycleHandler>> shutdownHandlers = new TreeMap(Comparator.reverseOrder());
    private final List<ModuleConfiguration> modules = new ArrayList<ModuleConfiguration>();
    private boolean initialized = false;
    private Integer currentLifecyclePhase = null;
    private LifecycleState lifecycleState = LifecycleState.DOWN;

    public static Configurer defaultConfiguration() {
        return DefaultConfigurer.defaultConfiguration(true);
    }

    public static Configurer defaultConfiguration(boolean autoLocateConfigurerModules) {
        DefaultConfigurer configurer = new DefaultConfigurer();
        if (autoLocateConfigurerModules) {
            ServiceLoader<ConfigurerModule> configurerModuleLoader = ServiceLoader.load(ConfigurerModule.class, configurer.getClass().getClassLoader());
            ArrayList<ConfigurerModule> configurerModules = new ArrayList<ConfigurerModule>();
            configurerModuleLoader.forEach(configurerModules::add);
            configurerModules.sort(Comparator.comparingInt(ConfigurerModule::order));
            configurerModules.forEach(cm -> cm.configureModule(configurer));
        }
        return configurer;
    }

    public static Configurer jpaConfiguration(EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        return new DefaultConfigurer().registerComponent(EntityManagerProvider.class, c -> entityManagerProvider).registerComponent(TransactionManager.class, c -> transactionManager).configureEmbeddedEventStore(c -> JpaEventStorageEngine.builder().snapshotSerializer(c.serializer()).upcasterChain((EventUpcaster)c.upcasterChain()).persistenceExceptionResolver(c.getComponent(PersistenceExceptionResolver.class)).eventSerializer(c.eventSerializer()).snapshotFilter(c.snapshotFilter()).entityManagerProvider(c.getComponent(EntityManagerProvider.class)).transactionManager(c.getComponent(TransactionManager.class)).build()).registerComponent(TokenStore.class, c -> JpaTokenStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build()).registerComponent(SagaStore.class, c -> JpaSagaStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build());
    }

    public static Configurer jpaConfiguration(EntityManagerProvider entityManagerProvider) {
        return DefaultConfigurer.jpaConfiguration(entityManagerProvider, (TransactionManager)NoTransactionManager.INSTANCE);
    }

    protected DefaultConfigurer() {
        this.components.put(ParameterResolverFactory.class, new Component<ParameterResolverFactory>(this.config, "parameterResolverFactory", this::defaultParameterResolverFactory));
        this.components.put(Serializer.class, new Component<Serializer>(this.config, "serializer", this::defaultSerializer));
        this.components.put(CommandBus.class, new Component<CommandBus>(this.config, "commandBus", this::defaultCommandBus));
        this.components.put(EventBus.class, new Component<EventBus>(this.config, "eventBus", this::defaultEventBus));
        this.components.put(EventStore.class, new Component<EventStore>(this.config, "eventStore", Configuration::eventStore));
        this.components.put(CommandGateway.class, new Component<CommandGateway>(this.config, "commandGateway", this::defaultCommandGateway));
        this.components.put(QueryBus.class, new Component<QueryBus>(this.config, "queryBus", this::defaultQueryBus));
        this.components.put(QueryUpdateEmitter.class, new Component<QueryUpdateEmitter>(this.config, "queryUpdateEmitter", this::defaultQueryUpdateEmitter));
        this.components.put(QueryGateway.class, new Component<QueryGateway>(this.config, "queryGateway", this::defaultQueryGateway));
        this.components.put(ResourceInjector.class, new Component<ResourceInjector>(this.config, "resourceInjector", this::defaultResourceInjector));
        this.components.put(DeadlineManager.class, new Component<DeadlineManager>(this.config, "deadlineManager", this::defaultDeadlineManager));
        this.components.put(EventUpcaster.class, this.upcasterChain);
        this.components.put(EventGateway.class, new Component<EventGateway>(this.config, "eventGateway", this::defaultEventGateway));
        this.components.put(TagsConfiguration.class, new Component<TagsConfiguration>(this.config, "tags", c -> new TagsConfiguration()));
        this.components.put(Snapshotter.class, new Component<Snapshotter>(this.config, "snapshotter", this::defaultSnapshotter));
    }

    protected CommandGateway defaultCommandGateway(Configuration config) {
        return DefaultCommandGateway.builder().commandBus(config.commandBus()).build();
    }

    protected QueryGateway defaultQueryGateway(Configuration config) {
        return DefaultQueryGateway.builder().queryBus(config.queryBus()).build();
    }

    protected QueryBus defaultQueryBus(Configuration config) {
        SimpleQueryBus queryBus = SimpleQueryBus.builder().messageMonitor(config.messageMonitor(SimpleQueryBus.class, "queryBus")).transactionManager(config.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler(config.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(config.getComponent(QueryUpdateEmitter.class)).build();
        queryBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(config.correlationDataProviders()));
        return queryBus;
    }

    protected QueryUpdateEmitter defaultQueryUpdateEmitter(Configuration config) {
        MessageMonitor updateMessageMonitor = config.messageMonitor(QueryUpdateEmitter.class, "queryUpdateEmitter");
        return SimpleQueryUpdateEmitter.builder().updateMessageMonitor(updateMessageMonitor).build();
    }

    protected ParameterResolverFactory defaultParameterResolverFactory(Configuration config) {
        return MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getClass()), new ConfigurationParameterResolverFactory(config)});
    }

    protected HandlerDefinition defaultHandlerDefinition(Class<?> inspectedClass) {
        return ClasspathHandlerDefinition.forClass(inspectedClass);
    }

    protected CommandBus defaultCommandBus(Configuration config) {
        SimpleCommandBus commandBus = SimpleCommandBus.builder().transactionManager(config.getComponent(TransactionManager.class, () -> NoTransactionManager.INSTANCE)).duplicateCommandHandlerResolver(config.getComponent(DuplicateCommandHandlerResolver.class, LoggingDuplicateCommandHandlerResolver::instance)).messageMonitor(config.messageMonitor(SimpleCommandBus.class, "commandBus")).build();
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(config.correlationDataProviders()));
        return commandBus;
    }

    protected ResourceInjector defaultResourceInjector(Configuration config) {
        return new ConfigurationResourceInjector(config);
    }

    protected DeadlineManager defaultDeadlineManager(Configuration config) {
        return SimpleDeadlineManager.builder().scopeAwareProvider((ScopeAwareProvider)new ConfigurationScopeAwareProvider(config)).build();
    }

    protected EventBus defaultEventBus(Configuration config) {
        return SimpleEventBus.builder().messageMonitor(config.messageMonitor(EventBus.class, "eventBus")).build();
    }

    protected EventGateway defaultEventGateway(Configuration config) {
        return DefaultEventGateway.builder().eventBus(config.eventBus()).build();
    }

    protected Serializer defaultSerializer(Configuration config) {
        return XStreamSerializer.builder().revisionResolver(config.getComponent(RevisionResolver.class, AnnotationRevisionResolver::new)).build();
    }

    protected Snapshotter defaultSnapshotter(Configuration config) {
        List<AggregateConfiguration<?>> aggregateConfigurations = config.findModules(AggregateConfiguration.class).stream().map(aggregateConfiguration -> aggregateConfiguration).collect(Collectors.toList());
        ArrayList aggregateFactories = new ArrayList();
        for (AggregateConfiguration aggregateConfiguration2 : aggregateConfigurations) {
            aggregateFactories.add(aggregateConfiguration2.aggregateFactory());
        }
        return AggregateSnapshotter.builder().eventStore(config.eventStore()).transactionManager(config.getComponent(TransactionManager.class)).aggregateFactories(aggregateFactories).repositoryProvider(config::repository).parameterResolverFactory(config.parameterResolverFactory()).handlerDefinition(this.retrieveHandlerDefinition(config, aggregateConfigurations)).build();
    }

    private HandlerDefinition retrieveHandlerDefinition(Configuration configuration, List<AggregateConfiguration<?>> aggregateConfigurations) {
        return configuration.handlerDefinition(aggregateConfigurations.get(0).aggregateType());
    }

    @Override
    public EventProcessingConfigurer eventProcessing() {
        List eventProcessingConfigurers = this.modules.stream().filter(module -> module.isType(EventProcessingConfigurer.class)).map(module -> (EventProcessingConfigurer)((Object)module.unwrap())).collect(Collectors.toList());
        switch (eventProcessingConfigurers.size()) {
            case 0: {
                EventProcessingModule eventProcessingModule = new EventProcessingModule();
                this.registerModule(eventProcessingModule);
                return eventProcessingModule;
            }
            case 1: {
                return (EventProcessingConfigurer)eventProcessingConfigurers.get(0);
            }
        }
        throw new AxonConfigurationException("There are several EventProcessingConfigurers defined. The `eventProcessing()` method is used to retrieve a 'singleton' EventProcessingConfigurer.");
    }

    @Override
    public Configurer registerEventUpcaster(Function<Configuration, EventUpcaster> upcasterBuilder) {
        this.upcasters.add(new Component<EventUpcaster>(this.config, "upcaster", upcasterBuilder));
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Function<Configuration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> builder) {
        this.messageMonitorFactoryBuilder.add((conf, type, name) -> (MessageMonitor)((BiFunction)builder.apply(conf)).apply(type, name));
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Class<?> componentType, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, messageMonitorFactory);
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Class<?> componentType, String componentName, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, componentName, messageMonitorFactory);
        return this;
    }

    @Override
    public Configurer configureCorrelationDataProviders(Function<Configuration, List<CorrelationDataProvider>> correlationDataProviderBuilder) {
        this.correlationProviders.update(correlationDataProviderBuilder);
        return this;
    }

    @Override
    public Configurer registerModule(ModuleConfiguration module) {
        logger.debug("Registering module [{}]", (Object)module.getClass().getSimpleName());
        if (this.initialized) {
            module.initialize(this.config);
        }
        this.modules.add(module);
        return this;
    }

    @Override
    public <C> Configurer registerComponent(Class<C> componentType, Function<Configuration, ? extends C> componentBuilder) {
        logger.debug("Registering component [{}]", (Object)componentType.getSimpleName());
        this.components.put(componentType, new Component<C>(this.config, componentType.getSimpleName(), componentBuilder));
        return this;
    }

    @Override
    public Configurer registerCommandHandler(Function<Configuration, Object> commandHandlerBuilder) {
        this.messageHandlerRegistrars.add(new Component<MessageHandlerRegistrar>(() -> this.config, "CommandHandlerRegistrar", configuration -> new MessageHandlerRegistrar(() -> configuration, commandHandlerBuilder, (config, commandHandler) -> new AnnotationCommandHandlerAdapter(commandHandler, config.parameterResolverFactory(), config.handlerDefinition(commandHandler.getClass())).subscribe(config.commandBus()))));
        return this;
    }

    @Override
    public Configurer registerQueryHandler(Function<Configuration, Object> queryHandlerBuilder) {
        this.messageHandlerRegistrars.add(new Component<MessageHandlerRegistrar>(() -> this.config, "QueryHandlerRegistrar", configuration -> new MessageHandlerRegistrar(() -> configuration, queryHandlerBuilder, (config, queryHandler) -> new AnnotationQueryHandlerAdapter(queryHandler, config.parameterResolverFactory(), config.handlerDefinition(queryHandler.getClass())).subscribe(config.queryBus()))));
        return this;
    }

    @Override
    public Configurer registerMessageHandler(Function<Configuration, Object> messageHandlerBuilder) {
        Component<Object> messageHandler = new Component<Object>(() -> this.config, "", messageHandlerBuilder);
        this.registerCommandHandler(c -> messageHandler.get());
        this.eventProcessing().registerEventHandler(c -> messageHandler.get());
        this.registerQueryHandler(c -> messageHandler.get());
        return this;
    }

    @Override
    public Configurer configureEmbeddedEventStore(Function<Configuration, EventStorageEngine> storageEngineBuilder) {
        return this.configureEventStore(c -> {
            MessageMonitor<Message<?>> monitor = this.messageMonitorFactoryComponent.get().apply(EmbeddedEventStore.class, "eventStore");
            EmbeddedEventStore eventStore = EmbeddedEventStore.builder().storageEngine((EventStorageEngine)storageEngineBuilder.apply((Configuration)c)).messageMonitor(monitor).build();
            c.onShutdown(() -> ((EmbeddedEventStore)eventStore).shutDown());
            return eventStore;
        });
    }

    @Override
    public Configurer configureEventSerializer(Function<Configuration, Serializer> eventSerializerBuilder) {
        this.eventSerializer.update(eventSerializerBuilder);
        return this;
    }

    @Override
    public Configurer configureMessageSerializer(Function<Configuration, Serializer> messageSerializerBuilder) {
        this.messageSerializer.update(messageSerializerBuilder);
        return this;
    }

    @Override
    public <A> Configurer configureAggregate(AggregateConfiguration<A> aggregateConfiguration) {
        return this.registerModule(aggregateConfiguration);
    }

    @Override
    public Configurer registerHandlerDefinition(BiFunction<Configuration, Class, HandlerDefinition> handlerDefinitionClass) {
        this.handlerDefinition.update(c -> clazz -> (HandlerDefinition)handlerDefinitionClass.apply((Configuration)c, (Class)clazz));
        return this;
    }

    @Override
    public Configuration buildConfiguration() {
        if (!this.initialized) {
            this.verifyIdentifierFactory();
            this.prepareModules();
            this.prepareMessageHandlerRegistrars();
            this.invokeInitHandlers();
        }
        return this.config;
    }

    protected void prepareModules() {
        this.modules.forEach(module -> this.initHandlers.add(module::initialize));
    }

    private void verifyIdentifierFactory() {
        try {
            IdentifierFactory.getInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The configured IdentifierFactory could not be instantiated.", e);
        }
    }

    protected void prepareMessageHandlerRegistrars() {
        this.messageHandlerRegistrars.forEach(registrar -> this.initHandlers.add(config -> {
            MessageHandlerRegistrar cfr_ignored_0 = (MessageHandlerRegistrar)registrar.get();
        }));
    }

    protected void invokeInitHandlers() {
        this.initialized = true;
        this.initHandlers.forEach(h -> h.accept(this.config));
    }

    protected void invokeStartHandlers() {
        logger.debug("Initiating start up");
        this.lifecycleState = LifecycleState.STARTING_UP;
        this.invokeLifecycleHandlers(this.startHandlers, e -> {
            logger.debug("Start up is being ended prematurely due to an exception");
            this.invokeShutdownHandlers();
            throw new LifecycleHandlerInvocationException(String.format("One of the start handlers in phase [%d] failed with the following exception:", this.currentLifecyclePhase), (Throwable)e);
        });
        this.lifecycleState = LifecycleState.UP;
        logger.debug("Finalized start sequence");
    }

    protected void invokeShutdownHandlers() {
        logger.debug("Initiating shutdown");
        this.lifecycleState = LifecycleState.SHUTTING_DOWN;
        this.invokeLifecycleHandlers(this.shutdownHandlers, e -> logger.warn("One of the shutdown handlers in phase [{}] failed with the following exception: ", (Object)this.currentLifecyclePhase, e));
        this.lifecycleState = LifecycleState.DOWN;
        logger.debug("Finalized shutdown sequence");
    }

    private void invokeLifecycleHandlers(TreeMap<Integer, List<LifecycleHandler>> lifecycleHandlerMap, Consumer<Exception> exceptionHandler) {
        Map.Entry<Integer, List<LifecycleHandler>> phasedHandlers = lifecycleHandlerMap.firstEntry();
        if (phasedHandlers == null) {
            return;
        }
        do {
            this.currentLifecyclePhase = phasedHandlers.getKey();
            logger.debug("Entered {} handler lifecycle phase [{}]", (Object)this.lifecycleState.description, (Object)this.currentLifecyclePhase);
            List<LifecycleHandler> handlers = phasedHandlers.getValue();
            try {
                handlers.stream().map(LifecycleHandler::run).reduce((cf1, cf2) -> CompletableFuture.allOf(cf1, cf2)).orElse(CompletableFuture.completedFuture(null)).get(5L, TimeUnit.SECONDS);
            }
            catch (CompletionException | ExecutionException e) {
                exceptionHandler.accept(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn(String.format("Completion interrupted during %s phase [%d]. Proceeding to following phase", this.lifecycleState.description, this.currentLifecyclePhase));
            }
            catch (TimeoutException e) {
                logger.warn(String.format("Timed out during %s phase [%d] after 5 seconds. Proceeding to following phase", this.lifecycleState.description, this.currentLifecyclePhase));
            }
        } while ((phasedHandlers = lifecycleHandlerMap.higherEntry(this.currentLifecyclePhase)) != null);
        this.currentLifecyclePhase = null;
    }

    protected Configuration getConfig() {
        return this.config;
    }

    public Map<Class<?>, Component<?>> getComponents() {
        return this.components;
    }

    private static enum LifecycleState {
        DOWN("down"),
        STARTING_UP("start"),
        UP("up"),
        SHUTTING_DOWN("shutdown");

        private final String description;

        private LifecycleState(String description) {
            this.description = description;
        }
    }

    private class ConfigurationImpl
    implements Configuration {
        private ConfigurationImpl() {
        }

        @Override
        public <T> T getComponent(Class<T> componentType, Supplier<T> defaultImpl) {
            Object component = DefaultConfigurer.this.components.computeIfAbsent(componentType, k -> new Component<Object>(DefaultConfigurer.this.config, componentType.getSimpleName(), arg_0 -> ConfigurationImpl.lambda$null$0((Supplier)defaultImpl, arg_0))).get();
            return componentType.cast(component);
        }

        @Override
        public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> componentType, String componentName) {
            return (MessageMonitor)((BiFunction)DefaultConfigurer.this.messageMonitorFactoryComponent.get()).apply(componentType, componentName);
        }

        @Override
        public Serializer eventSerializer() {
            return (Serializer)DefaultConfigurer.this.eventSerializer.get();
        }

        @Override
        public Serializer messageSerializer() {
            return (Serializer)DefaultConfigurer.this.messageSerializer.get();
        }

        @Override
        public void start() {
            DefaultConfigurer.this.invokeStartHandlers();
        }

        @Override
        public void shutdown() {
            DefaultConfigurer.this.invokeShutdownHandlers();
        }

        @Override
        public List<CorrelationDataProvider> correlationDataProviders() {
            return (List)DefaultConfigurer.this.correlationProviders.get();
        }

        @Override
        public List<ModuleConfiguration> getModules() {
            return DefaultConfigurer.this.modules;
        }

        @Override
        public void onStart(int phase, LifecycleHandler startHandler) {
            if (this.isEarlierPhaseDuringStartUp(phase)) {
                logger.info("A start handler is being registered for phase [{}] whilst phase [{}] is in progress. Will run provided handler immediately instead.", (Object)phase, (Object)DefaultConfigurer.this.currentLifecyclePhase);
                startHandler.run().join();
            }
            this.registerLifecycleHandler(DefaultConfigurer.this.startHandlers, phase, startHandler);
        }

        private boolean isEarlierPhaseDuringStartUp(int phase) {
            return DefaultConfigurer.this.lifecycleState == LifecycleState.STARTING_UP && DefaultConfigurer.this.currentLifecyclePhase != null && phase <= DefaultConfigurer.this.currentLifecyclePhase;
        }

        @Override
        public void onShutdown(int phase, LifecycleHandler shutdownHandler) {
            if (this.isEarlierPhaseDuringShutdown(phase)) {
                logger.info("A shutdown handler is being registered for phase [{}] whilst phase [{}] is in progress. Will run provided handler immediately instead.", (Object)phase, (Object)DefaultConfigurer.this.currentLifecyclePhase);
                shutdownHandler.run().join();
            }
            this.registerLifecycleHandler(DefaultConfigurer.this.shutdownHandlers, phase, shutdownHandler);
        }

        private boolean isEarlierPhaseDuringShutdown(int phase) {
            return DefaultConfigurer.this.lifecycleState == LifecycleState.SHUTTING_DOWN && DefaultConfigurer.this.currentLifecyclePhase != null && phase >= DefaultConfigurer.this.currentLifecyclePhase;
        }

        private void registerLifecycleHandler(Map<Integer, List<LifecycleHandler>> lifecycleHandlers, int phase, LifecycleHandler lifecycleHandler) {
            lifecycleHandlers.compute(phase, (p, handlers) -> {
                if (handlers == null) {
                    handlers = new CopyOnWriteArrayList<LifecycleHandler>();
                }
                handlers.add(lifecycleHandler);
                return handlers;
            });
        }

        @Override
        public EventUpcasterChain upcasterChain() {
            return (EventUpcasterChain)DefaultConfigurer.this.upcasterChain.get();
        }

        @Override
        public HandlerDefinition handlerDefinition(Class<?> inspectedType) {
            return (HandlerDefinition)((Function)DefaultConfigurer.this.handlerDefinition.get()).apply(inspectedType);
        }

        private static /* synthetic */ Object lambda$null$0(Supplier defaultImpl, Configuration c) {
            return defaultImpl.get();
        }
    }
}

