/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;

public interface Configurer {
    public Configurer registerEventUpcaster(Function<Configuration, EventUpcaster> var1);

    public Configurer configureMessageMonitor(Function<Configuration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> var1);

    default public Configurer configureMessageMonitor(Class<?> componentType, Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(componentType, (Configuration configuration, Class<?> type, String name) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public Configurer configureMessageMonitor(Class<?> var1, MessageMonitorFactory var2);

    default public Configurer configureMessageMonitor(Class<?> componentType, String componentName, Function<Configuration, MessageMonitor<Message<?>>> messageMonitorBuilder) {
        return this.configureMessageMonitor(componentType, componentName, (Configuration configuration, Class<?> type, String name) -> (MessageMonitor)messageMonitorBuilder.apply(configuration));
    }

    public Configurer configureMessageMonitor(Class<?> var1, String var2, MessageMonitorFactory var3);

    public Configurer configureCorrelationDataProviders(Function<Configuration, List<CorrelationDataProvider>> var1);

    public Configurer registerModule(ModuleConfiguration var1);

    public <C> Configurer registerComponent(Class<C> var1, Function<Configuration, ? extends C> var2);

    public Configurer registerCommandHandler(Function<Configuration, Object> var1);

    @Deprecated
    default public Configurer registerCommandHandler(int phase, Function<Configuration, Object> commandHandlerBuilder) {
        return this.registerCommandHandler(commandHandlerBuilder);
    }

    public Configurer registerQueryHandler(Function<Configuration, Object> var1);

    @Deprecated
    default public Configurer registerQueryHandler(int phase, Function<Configuration, Object> queryHandlerBuilder) {
        return this.registerQueryHandler(queryHandlerBuilder);
    }

    public Configurer registerMessageHandler(Function<Configuration, Object> var1);

    public Configurer configureEmbeddedEventStore(Function<Configuration, EventStorageEngine> var1);

    default public Configurer configureEventStore(Function<Configuration, EventStore> eventStoreBuilder) {
        return this.registerComponent(EventBus.class, eventStoreBuilder);
    }

    default public Configurer configureEventBus(Function<Configuration, EventBus> eventBusBuilder) {
        return this.registerComponent(EventBus.class, eventBusBuilder);
    }

    default public Configurer configureCommandBus(Function<Configuration, CommandBus> commandBusBuilder) {
        return this.registerComponent(CommandBus.class, commandBusBuilder);
    }

    default public Configurer configureQueryBus(Function<Configuration, QueryBus> queryBusBuilder) {
        return this.registerComponent(QueryBus.class, queryBusBuilder);
    }

    default public Configurer configureQueryUpdateEmitter(Function<Configuration, QueryUpdateEmitter> queryUpdateEmitterBuilder) {
        return this.registerComponent(QueryUpdateEmitter.class, queryUpdateEmitterBuilder);
    }

    default public Configurer configureSerializer(Function<Configuration, Serializer> serializerBuilder) {
        return this.registerComponent(Serializer.class, serializerBuilder);
    }

    public Configurer configureEventSerializer(Function<Configuration, Serializer> var1);

    public Configurer configureMessageSerializer(Function<Configuration, Serializer> var1);

    default public Configurer configureTransactionManager(Function<Configuration, TransactionManager> transactionManagerBuilder) {
        return this.registerComponent(TransactionManager.class, transactionManagerBuilder);
    }

    default public Configurer configureResourceInjector(Function<Configuration, ResourceInjector> resourceInjectorBuilder) {
        return this.registerComponent(ResourceInjector.class, resourceInjectorBuilder);
    }

    default public Configurer configureTags(Function<Configuration, TagsConfiguration> tagsBuilder) {
        return this.registerComponent(TagsConfiguration.class, tagsBuilder);
    }

    public <A> Configurer configureAggregate(AggregateConfiguration<A> var1);

    default public <A> Configurer configureAggregate(Class<A> aggregate) {
        return this.configureAggregate(AggregateConfigurer.defaultConfiguration(aggregate));
    }

    public Configurer registerHandlerDefinition(BiFunction<Configuration, Class, HandlerDefinition> var1);

    default public Configurer configureSnapshotter(Function<Configuration, Snapshotter> snapshotterBuilder) {
        return this.registerComponent(Snapshotter.class, snapshotterBuilder);
    }

    public EventProcessingConfigurer eventProcessing() throws AxonConfigurationException;

    default public Configurer eventProcessing(Consumer<EventProcessingConfigurer> eventProcessingConfigurer) throws AxonConfigurationException {
        eventProcessingConfigurer.accept(this.eventProcessing());
        return this;
    }

    default public Configurer registerEventHandler(Function<Configuration, Object> eventHandlerBuilder) {
        this.eventProcessing().registerEventHandler(eventHandlerBuilder);
        return this;
    }

    default public void onInitialize(Consumer<Configuration> initHandler) {
        this.registerModule(initHandler::accept);
    }

    public Configuration buildConfiguration();

    default public Configuration start() {
        Configuration configuration = this.buildConfiguration();
        configuration.start();
        return configuration;
    }
}

