/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.AnnotationCommandHandlerAdapter;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.Registration;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.ConfigurationParameterResolverFactory;
import org.axonframework.config.ConfigurationResourceInjector;
import org.axonframework.config.ConfigurationScopeAwareProvider;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.config.MessageMonitorFactoryBuilder;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.SimpleDeadlineManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jpa.JpaTokenStore;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jpa.JpaSagaStore;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.xml.XStreamSerializer;

public class DefaultConfigurer
implements Configurer {
    private final Configuration config = new ConfigurationImpl();
    private final MessageMonitorFactoryBuilder messageMonitorFactoryBuilder = new MessageMonitorFactoryBuilder();
    private final Component<BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> messageMonitorFactoryComponent = new Component<BiFunction>(this.config, "monitorFactory", this.messageMonitorFactoryBuilder::build);
    private final Component<List<CorrelationDataProvider>> correlationProviders = new Component<List>(this.config, "correlationProviders", c -> Collections.singletonList(new MessageOriginProvider()));
    private final Map<Class<?>, Component<?>> components = new HashMap();
    private final Component<Serializer> eventSerializer = new Component<Serializer>(this.config, "eventSerializer", Configuration::messageSerializer);
    private final Component<Serializer> messageSerializer = new Component<Serializer>(this.config, "messageSerializer", Configuration::serializer);
    private final List<Component<EventUpcaster>> upcasters = new ArrayList<Component<EventUpcaster>>();
    private final Component<EventUpcasterChain> upcasterChain = new Component<EventUpcasterChain>(this.config, "eventUpcasterChain", c -> new EventUpcasterChain(this.upcasters.stream().map(Component::get).collect(Collectors.toList())));
    private final Component<Function<Class, HandlerDefinition>> handlerDefinition = new Component<Function>(this.config, "handlerDefinition", c -> this::defaultHandlerDefinition);
    private final Map<Class<?>, AggregateConfiguration> aggregateConfigurations = new HashMap();
    private final List<ConsumerHandler> initHandlers = new ArrayList<ConsumerHandler>();
    private final List<RunnableHandler> startHandlers = new ArrayList<RunnableHandler>();
    private final List<RunnableHandler> shutdownHandlers = new ArrayList<RunnableHandler>();
    private final List<ModuleConfiguration> modules = new ArrayList<ModuleConfiguration>();
    private boolean initialized = false;

    public static Configurer defaultConfiguration() {
        return DefaultConfigurer.defaultConfiguration(true);
    }

    public static Configurer defaultConfiguration(boolean autoLocateConfigurerModules) {
        DefaultConfigurer configurer = new DefaultConfigurer();
        if (autoLocateConfigurerModules) {
            ServiceLoader<ConfigurerModule> configurerModuleLoader = ServiceLoader.load(ConfigurerModule.class, configurer.getClass().getClassLoader());
            ArrayList<ConfigurerModule> configurerModules = new ArrayList<ConfigurerModule>();
            configurerModuleLoader.forEach(configurerModules::add);
            configurerModules.sort(Comparator.comparingInt(ConfigurerModule::order));
            configurerModules.forEach(cm -> cm.configureModule(configurer));
        }
        return configurer;
    }

    public static Configurer jpaConfiguration(EntityManagerProvider entityManagerProvider, TransactionManager transactionManager) {
        return new DefaultConfigurer().registerComponent(EntityManagerProvider.class, c -> entityManagerProvider).registerComponent(TransactionManager.class, c -> transactionManager).configureEmbeddedEventStore(c -> JpaEventStorageEngine.builder().snapshotSerializer(c.serializer()).upcasterChain((EventUpcaster)c.upcasterChain()).persistenceExceptionResolver(c.getComponent(PersistenceExceptionResolver.class)).eventSerializer(c.eventSerializer()).entityManagerProvider(c.getComponent(EntityManagerProvider.class)).transactionManager(c.getComponent(TransactionManager.class)).build()).registerComponent(TokenStore.class, c -> JpaTokenStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build()).registerComponent(SagaStore.class, c -> JpaSagaStore.builder().entityManagerProvider(c.getComponent(EntityManagerProvider.class)).serializer(c.serializer()).build());
    }

    public static Configurer jpaConfiguration(EntityManagerProvider entityManagerProvider) {
        return DefaultConfigurer.jpaConfiguration(entityManagerProvider, (TransactionManager)NoTransactionManager.INSTANCE);
    }

    protected DefaultConfigurer() {
        this.components.put(ParameterResolverFactory.class, new Component<ParameterResolverFactory>(this.config, "parameterResolverFactory", this::defaultParameterResolverFactory));
        this.components.put(Serializer.class, new Component<Serializer>(this.config, "serializer", this::defaultSerializer));
        this.components.put(CommandBus.class, new Component<CommandBus>(this.config, "commandBus", this::defaultCommandBus));
        this.components.put(EventBus.class, new Component<EventBus>(this.config, "eventBus", this::defaultEventBus));
        this.components.put(EventStore.class, new Component<EventStore>(this.config, "eventStore", Configuration::eventStore));
        this.components.put(CommandGateway.class, new Component<CommandGateway>(this.config, "commandGateway", this::defaultCommandGateway));
        this.components.put(QueryBus.class, new Component<QueryBus>(this.config, "queryBus", this::defaultQueryBus));
        this.components.put(QueryUpdateEmitter.class, new Component<QueryUpdateEmitter>(this.config, "queryUpdateEmitter", this::defaultQueryUpdateEmitter));
        this.components.put(QueryGateway.class, new Component<QueryGateway>(this.config, "queryGateway", this::defaultQueryGateway));
        this.components.put(ResourceInjector.class, new Component<ResourceInjector>(this.config, "resourceInjector", this::defaultResourceInjector));
        this.components.put(DeadlineManager.class, new Component<DeadlineManager>(this.config, "deadlineManager", this::defaultDeadlineManager));
        this.components.put(EventUpcaster.class, this.upcasterChain);
    }

    protected CommandGateway defaultCommandGateway(Configuration config) {
        return DefaultCommandGateway.builder().commandBus(config.commandBus()).build();
    }

    protected QueryGateway defaultQueryGateway(Configuration config) {
        return DefaultQueryGateway.builder().queryBus(config.queryBus()).build();
    }

    protected QueryBus defaultQueryBus(Configuration config) {
        return SimpleQueryBus.builder().messageMonitor(config.messageMonitor(SimpleQueryBus.class, "queryBus")).transactionManager(config.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler(config.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(config.getComponent(QueryUpdateEmitter.class)).build();
    }

    protected QueryUpdateEmitter defaultQueryUpdateEmitter(Configuration config) {
        MessageMonitor updateMessageMonitor = config.messageMonitor(QueryUpdateEmitter.class, "queryUpdateEmitter");
        return SimpleQueryUpdateEmitter.builder().updateMessageMonitor(updateMessageMonitor).build();
    }

    protected ParameterResolverFactory defaultParameterResolverFactory(Configuration config) {
        return MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getClass()), new ConfigurationParameterResolverFactory(config)});
    }

    protected HandlerDefinition defaultHandlerDefinition(Class<?> inspectedClass) {
        return ClasspathHandlerDefinition.forClass(inspectedClass);
    }

    protected CommandBus defaultCommandBus(Configuration config) {
        SimpleCommandBus commandBus = SimpleCommandBus.builder().transactionManager(config.getComponent(TransactionManager.class, () -> NoTransactionManager.INSTANCE)).messageMonitor(config.messageMonitor(SimpleCommandBus.class, "commandBus")).build();
        commandBus.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(config.correlationDataProviders()));
        return commandBus;
    }

    protected ResourceInjector defaultResourceInjector(Configuration config) {
        return new ConfigurationResourceInjector(config);
    }

    protected DeadlineManager defaultDeadlineManager(Configuration config) {
        return SimpleDeadlineManager.builder().scopeAwareProvider((ScopeAwareProvider)new ConfigurationScopeAwareProvider(config)).build();
    }

    protected EventBus defaultEventBus(Configuration config) {
        return SimpleEventBus.builder().messageMonitor(config.messageMonitor(EventBus.class, "eventBus")).build();
    }

    protected Serializer defaultSerializer(Configuration config) {
        return XStreamSerializer.builder().revisionResolver(config.getComponent(RevisionResolver.class, AnnotationRevisionResolver::new)).build();
    }

    @Override
    public EventProcessingConfigurer eventProcessing() {
        List eventProcessingConfigurers = this.modules.stream().filter(module -> module.isType(EventProcessingConfigurer.class)).map(module -> (EventProcessingConfigurer)((Object)module.unwrap())).collect(Collectors.toList());
        switch (eventProcessingConfigurers.size()) {
            case 0: {
                EventProcessingModule eventProcessingModule = new EventProcessingModule();
                this.registerModule(eventProcessingModule);
                return eventProcessingModule;
            }
            case 1: {
                return (EventProcessingConfigurer)eventProcessingConfigurers.get(0);
            }
        }
        throw new AxonConfigurationException("There are several EventProcessingConfigurers defined. The `eventProcessing()` method is used to retrieve a 'singleton' EventProcessingConfigurer.");
    }

    @Override
    public Configurer registerEventUpcaster(Function<Configuration, EventUpcaster> upcasterBuilder) {
        this.upcasters.add(new Component<EventUpcaster>(this.config, "upcaster", upcasterBuilder));
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Function<Configuration, BiFunction<Class<?>, String, MessageMonitor<Message<?>>>> builder) {
        this.messageMonitorFactoryBuilder.add((conf, type, name) -> (MessageMonitor)((BiFunction)builder.apply(conf)).apply(type, name));
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Class<?> componentType, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, messageMonitorFactory);
        return this;
    }

    @Override
    public Configurer configureMessageMonitor(Class<?> componentType, String componentName, MessageMonitorFactory messageMonitorFactory) {
        this.messageMonitorFactoryBuilder.add(componentType, componentName, messageMonitorFactory);
        return this;
    }

    @Override
    public Configurer configureCorrelationDataProviders(Function<Configuration, List<CorrelationDataProvider>> correlationDataProviderBuilder) {
        this.correlationProviders.update(correlationDataProviderBuilder);
        return this;
    }

    @Override
    public Configurer registerModule(ModuleConfiguration module) {
        if (this.initialized) {
            module.initialize(this.config);
            this.startHandlers.add(new RunnableHandler(module.phase(), module::start));
            this.shutdownHandlers.add(new RunnableHandler(module.phase(), module::shutdown));
        }
        this.modules.add(module);
        return this;
    }

    @Override
    public Configurer registerCommandHandler(int phase, Function<Configuration, Object> annotatedCommandHandlerBuilder) {
        this.startHandlers.add(new RunnableHandler(phase, () -> {
            Object handler = annotatedCommandHandlerBuilder.apply(this.config);
            Assert.notNull(handler, () -> "annotatedCommandHandler may not be null");
            Registration registration = new AnnotationCommandHandlerAdapter(handler, this.config.parameterResolverFactory(), this.config.handlerDefinition(handler.getClass())).subscribe(this.config.commandBus());
            this.shutdownHandlers.add(new RunnableHandler(phase, () -> ((Registration)registration).cancel()));
        }));
        return this;
    }

    @Override
    public Configurer registerQueryHandler(int phase, Function<Configuration, Object> annotatedQueryHandlerBuilder) {
        this.startHandlers.add(new RunnableHandler(phase, () -> {
            Object annotatedHandler = annotatedQueryHandlerBuilder.apply(this.config);
            Assert.notNull(annotatedHandler, () -> "annotatedQueryHandler may not be null");
            Registration registration = new AnnotationQueryHandlerAdapter(annotatedHandler, this.config.parameterResolverFactory(), this.config.handlerDefinition(annotatedHandler.getClass())).subscribe(this.config.queryBus());
            this.shutdownHandlers.add(new RunnableHandler(phase, () -> ((Registration)registration).cancel()));
        }));
        return this;
    }

    @Override
    public <C> Configurer registerComponent(Class<C> componentType, Function<Configuration, ? extends C> componentBuilder) {
        this.components.put(componentType, new Component<C>(this.config, componentType.getSimpleName(), componentBuilder));
        return this;
    }

    @Override
    public Configurer configureEmbeddedEventStore(Function<Configuration, EventStorageEngine> storageEngineBuilder) {
        return this.configureEventStore(c -> {
            MessageMonitor<Message<?>> monitor = this.messageMonitorFactoryComponent.get().apply(EmbeddedEventStore.class, "eventStore");
            EmbeddedEventStore eventStore = EmbeddedEventStore.builder().storageEngine((EventStorageEngine)storageEngineBuilder.apply((Configuration)c)).messageMonitor(monitor).build();
            c.onShutdown(() -> ((EmbeddedEventStore)eventStore).shutDown());
            return eventStore;
        });
    }

    @Override
    public Configurer configureEventSerializer(Function<Configuration, Serializer> eventSerializerBuilder) {
        this.eventSerializer.update(eventSerializerBuilder);
        return this;
    }

    @Override
    public Configurer configureMessageSerializer(Function<Configuration, Serializer> messageSerializerBuilder) {
        this.messageSerializer.update(messageSerializerBuilder);
        return this;
    }

    @Override
    public <A> Configurer configureAggregate(AggregateConfiguration<A> aggregateConfiguration) {
        this.modules.add(aggregateConfiguration);
        this.aggregateConfigurations.put(aggregateConfiguration.aggregateType(), aggregateConfiguration);
        this.initHandlers.add(new ConsumerHandler(aggregateConfiguration.phase(), aggregateConfiguration::initialize));
        this.startHandlers.add(new RunnableHandler(aggregateConfiguration.phase(), aggregateConfiguration::start));
        this.shutdownHandlers.add(new RunnableHandler(aggregateConfiguration.phase(), aggregateConfiguration::shutdown));
        return this;
    }

    @Override
    public Configurer registerHandlerDefinition(BiFunction<Configuration, Class, HandlerDefinition> handlerDefinitionClass) {
        this.handlerDefinition.update(c -> clazz -> (HandlerDefinition)handlerDefinitionClass.apply((Configuration)c, (Class)clazz));
        return this;
    }

    @Override
    public Configuration buildConfiguration() {
        if (!this.initialized) {
            this.verifyIdentifierFactory();
            this.prepareModules();
            this.invokeInitHandlers();
        }
        return this.config;
    }

    protected void prepareModules() {
        this.modules.forEach(module -> {
            this.initHandlers.add(new ConsumerHandler(module.phase(), module::initialize));
            this.startHandlers.add(new RunnableHandler(module.phase(), module::start));
            this.shutdownHandlers.add(new RunnableHandler(module.phase(), module::shutdown));
        });
    }

    private void verifyIdentifierFactory() {
        try {
            IdentifierFactory.getInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The configured IdentifierFactory could not be instantiated.", e);
        }
    }

    protected void invokeInitHandlers() {
        this.initialized = true;
        this.initHandlers.stream().sorted(Comparator.comparingInt(ConsumerHandler::phase)).forEach(h -> h.accept(this.config));
    }

    protected void invokeStartHandlers() {
        this.startHandlers.stream().sorted(Comparator.comparingInt(RunnableHandler::phase)).forEach(RunnableHandler::run);
    }

    protected void invokeShutdownHandlers() {
        this.shutdownHandlers.stream().sorted(Comparator.comparingInt(RunnableHandler::phase).reversed()).forEach(RunnableHandler::run);
    }

    protected Configuration getConfig() {
        return this.config;
    }

    public Map<Class<?>, Component<?>> getComponents() {
        return this.components;
    }

    private class ConfigurationImpl
    implements Configuration {
        private ConfigurationImpl() {
        }

        @Override
        public <T> Repository<T> repository(Class<T> aggregateType) {
            AggregateConfiguration aggregateConfigurer = (AggregateConfiguration)DefaultConfigurer.this.aggregateConfigurations.get(aggregateType);
            if (aggregateConfigurer == null) {
                throw new IllegalArgumentException("Aggregate " + aggregateType.getSimpleName() + " has not been configured");
            }
            return aggregateConfigurer.repository();
        }

        @Override
        public <T> T getComponent(Class<T> componentType, Supplier<T> defaultImpl) {
            return componentType.cast(DefaultConfigurer.this.components.computeIfAbsent(componentType, k -> new Component<Object>(DefaultConfigurer.this.config, componentType.getSimpleName(), arg_0 -> ConfigurationImpl.lambda$null$0((Supplier)defaultImpl, arg_0))).get());
        }

        @Override
        public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> componentType, String componentName) {
            return (MessageMonitor)((BiFunction)DefaultConfigurer.this.messageMonitorFactoryComponent.get()).apply(componentType, componentName);
        }

        @Override
        public Serializer eventSerializer() {
            return (Serializer)DefaultConfigurer.this.eventSerializer.get();
        }

        @Override
        public Serializer messageSerializer() {
            return (Serializer)DefaultConfigurer.this.messageSerializer.get();
        }

        @Override
        public void start() {
            DefaultConfigurer.this.invokeStartHandlers();
        }

        @Override
        public void shutdown() {
            DefaultConfigurer.this.invokeShutdownHandlers();
        }

        @Override
        public List<CorrelationDataProvider> correlationDataProviders() {
            return (List)DefaultConfigurer.this.correlationProviders.get();
        }

        @Override
        public List<ModuleConfiguration> getModules() {
            return DefaultConfigurer.this.modules;
        }

        @Override
        public void onShutdown(int phase, Runnable shutdownHandler) {
            DefaultConfigurer.this.shutdownHandlers.add(new RunnableHandler(phase, shutdownHandler));
        }

        @Override
        public EventUpcasterChain upcasterChain() {
            return (EventUpcasterChain)DefaultConfigurer.this.upcasterChain.get();
        }

        @Override
        public void onStart(int phase, Runnable startHandler) {
            DefaultConfigurer.this.startHandlers.add(new RunnableHandler(phase, startHandler));
        }

        @Override
        public HandlerDefinition handlerDefinition(Class<?> inspectedType) {
            return (HandlerDefinition)((Function)DefaultConfigurer.this.handlerDefinition.get()).apply(inspectedType);
        }

        private static /* synthetic */ Object lambda$null$0(Supplier defaultImpl, Configuration c) {
            return defaultImpl.get();
        }
    }

    private static class RunnableHandler {
        private final int phase;
        private final Runnable handler;

        private RunnableHandler(int phase, Runnable handler) {
            this.phase = phase;
            this.handler = handler;
        }

        public int phase() {
            return this.phase;
        }

        public void run() {
            this.handler.run();
        }
    }

    private static class ConsumerHandler {
        private final int phase;
        private final Consumer<Configuration> handler;

        private ConsumerHandler(int phase, Consumer<Configuration> handler) {
            this.phase = phase;
            this.handler = handler;
        }

        public int phase() {
            return this.phase;
        }

        public void accept(Configuration configuration) {
            this.handler.accept(configuration);
        }
    }
}

