/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.common.TypeReference;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.infra.DescribableComponent;

public interface Component<C>
extends DescribableComponent {
    public Identifier<C> identifier();

    public C resolve(@Nonnull Configuration var1);

    public boolean isInstantiated();

    public void initLifecycle(@Nonnull Configuration var1, @Nonnull LifecycleRegistry var2);

    public boolean isInitialized();

    public record Identifier<C>(@Nonnull TypeReference<C> type, @Nullable String name) {
        public Identifier(@Nonnull Class<C> clazz, @Nullable String name) {
            this(TypeReference.fromClass(clazz), name);
        }

        public Identifier(@Nonnull Type type, @Nullable String name) {
            this(TypeReference.fromType(type), name);
        }

        public Identifier {
            Objects.requireNonNull(type, "The given type is unsupported because it is null.");
            if (name != null) {
                Assert.nonEmpty(name, "The given name is unsupported because it is empty.");
            }
        }

        public boolean matches(@Nonnull Identifier<?> other) {
            return this.matchesType(other) && Objects.equals(other.name(), this.name);
        }

        public boolean matchesType(@Nonnull Identifier<?> other) {
            return this.type.getTypeAsClass().isAssignableFrom(other.type().getTypeAsClass());
        }

        public Class<C> typeAsClass() {
            return this.type.getTypeAsClass();
        }

        public boolean areTypeAndNameEqual() {
            return this.type.getTypeAsClass().getName().equals(this.name);
        }

        @Override
        public String toString() {
            return this.type.getTypeAsClass().getName() + ":" + this.name;
        }
    }
}

