/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleHandler;
import org.axonframework.common.configuration.LifecycleRegistry;

public class HierarchicalConfiguration
implements LifecycleRegistry {
    private final LifecycleRegistry parentLifecycleRegistry;
    private final Configuration childConfiguration;

    public static Configuration build(LifecycleRegistry parentLifecycleRegistry, Function<LifecycleRegistry, Configuration> childConfigurationBuilder) {
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration(parentLifecycleRegistry, childConfigurationBuilder);
        return hierarchicalConfiguration.getConfiguration();
    }

    private Configuration getConfiguration() {
        return this.childConfiguration;
    }

    private HierarchicalConfiguration(@Nonnull LifecycleRegistry parentLifecycleRegistry, @Nonnull Function<LifecycleRegistry, Configuration> childConfigurationBuilder) {
        this.parentLifecycleRegistry = Objects.requireNonNull(parentLifecycleRegistry, "parentLifecycleRegistry may not be null");
        this.childConfiguration = childConfigurationBuilder.apply(this);
    }

    @Override
    public LifecycleRegistry registerLifecyclePhaseTimeout(long timeout, @Nonnull TimeUnit timeUnit) {
        this.parentLifecycleRegistry.registerLifecyclePhaseTimeout(timeout, timeUnit);
        return this;
    }

    @Override
    public LifecycleRegistry onStart(int phase, @Nonnull LifecycleHandler startHandler) {
        this.parentLifecycleRegistry.onStart(phase, (Configuration parentConfiguration) -> startHandler.run(this.childConfiguration));
        return this;
    }

    @Override
    public LifecycleRegistry onShutdown(int phase, @Nonnull LifecycleHandler shutdownHandler) {
        this.parentLifecycleRegistry.onShutdown(phase, (Configuration parentConfiguration) -> shutdownHandler.run(this.childConfiguration));
        return this;
    }
}

