/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.configuration.ApplicationConfigurer;
import org.axonframework.common.configuration.AxonConfiguration;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.DefaultComponentRegistry;
import org.axonframework.common.configuration.LifecycleHandler;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.lifecycle.LifecycleHandlerInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAxonApplication
implements ApplicationConfigurer,
LifecycleRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Runnable NOTHING = () -> {};
    private final TreeMap<Integer, List<LifecycleHandler>> startHandlers = new TreeMap();
    private final TreeMap<Integer, List<LifecycleHandler>> shutdownHandlers = new TreeMap(Comparator.reverseOrder());
    private final DefaultComponentRegistry componentRegistry;
    private long lifecyclePhaseTimeout = 5L;
    private TimeUnit lifecyclePhaseTimeunit = TimeUnit.SECONDS;
    private final AtomicReference<AxonConfiguration> configuration = new AtomicReference();

    public DefaultAxonApplication() {
        this.componentRegistry = new DefaultComponentRegistry();
    }

    @Override
    public DefaultAxonApplication onStart(int phase, @Nonnull LifecycleHandler startHandler) {
        return this.registerLifecycleHandler(this.startHandlers, phase, startHandler);
    }

    @Override
    public DefaultAxonApplication onShutdown(int phase, @Nonnull LifecycleHandler shutdownHandler) {
        return this.registerLifecycleHandler(this.shutdownHandlers, phase, shutdownHandler);
    }

    private DefaultAxonApplication registerLifecycleHandler(Map<Integer, List<LifecycleHandler>> lifecycleHandlers, int phase, @Nonnull LifecycleHandler lifecycleHandler) {
        if (this.configuration.get() != null) {
            throw new IllegalArgumentException("Cannot register lifecycle handlers when the configuration is already initialized");
        }
        lifecycleHandlers.computeIfAbsent(phase, p -> new CopyOnWriteArrayList()).add(Objects.requireNonNull(lifecycleHandler, "Cannot register null lifecycle handlers."));
        return this;
    }

    @Override
    public DefaultAxonApplication registerLifecyclePhaseTimeout(long timeout, @Nonnull TimeUnit timeUnit) {
        Assert.assertStrictPositive(timeout, "The lifecycle phase timeout should be strictly positive");
        Objects.requireNonNull(timeUnit, "The lifecycle phase time unit should not be null");
        this.lifecyclePhaseTimeout = timeout;
        this.lifecyclePhaseTimeunit = timeUnit;
        return this;
    }

    @Override
    public synchronized AxonConfiguration build() {
        if (this.configuration.get() == null) {
            this.configuration.set(new AxonConfigurationImpl(this.componentRegistry.build(this)));
        }
        return this.configuration.get();
    }

    @Override
    public ApplicationConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        componentRegistrar.accept(this.componentRegistry);
        return this;
    }

    @Override
    public ApplicationConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        lifecycleRegistrar.accept(this);
        return this;
    }

    private class AxonConfigurationImpl
    implements AxonConfiguration {
        private final Configuration config;
        private final AtomicReference<LifecycleState> lifecycleState = new AtomicReference<LifecycleState>(LifecycleState.DOWN);

        private AxonConfigurationImpl(Configuration config) {
            this.config = config;
        }

        @Override
        public void start() {
            if (this.lifecycleState.compareAndSet(LifecycleState.DOWN, LifecycleState.STARTING_UP)) {
                logger.debug("Initiating start up");
                this.verifyIdentifierFactory();
                this.invokeStartHandlers();
                this.lifecycleState.set(LifecycleState.UP);
                logger.debug("Finalized start sequence");
            }
        }

        private void invokeStartHandlers() {
            this.invokeLifecycleHandlers(DefaultAxonApplication.this.startHandlers, (phase, e) -> {
                logger.debug("Start up is being ended prematurely due to an exception");
                String startFailure = String.format("One of the start handlers in phase [%d] failed with the following exception: ", phase);
                logger.warn(startFailure, (Throwable)e);
                this.invokeShutdownHandlers();
                throw new LifecycleHandlerInvocationException(startFailure, (Throwable)e);
            });
        }

        private void verifyIdentifierFactory() {
            try {
                IdentifierFactory.getInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The configured IdentifierFactory could not be instantiated.", e);
            }
        }

        @Override
        public void shutdown() {
            if (this.lifecycleState.compareAndSet(LifecycleState.UP, LifecycleState.SHUTTING_DOWN)) {
                logger.debug("Initiating shutdown");
                this.invokeShutdownHandlers();
                this.lifecycleState.set(LifecycleState.DOWN);
                logger.debug("Finalized shutdown sequence");
            }
        }

        protected void invokeShutdownHandlers() {
            this.invokeLifecycleHandlers(DefaultAxonApplication.this.shutdownHandlers, (phase, e) -> logger.warn("One of the shutdown handlers in phase [{}] failed with the following exception: ", phase, e));
        }

        private void invokeLifecycleHandlers(TreeMap<Integer, List<LifecycleHandler>> lifecycleHandlerMap, BiConsumer<Integer, Exception> exceptionHandler) {
            Integer currentLifecyclePhase;
            Map.Entry<Integer, List<LifecycleHandler>> phasedHandlers = lifecycleHandlerMap.firstEntry();
            if (phasedHandlers == null) {
                return;
            }
            do {
                currentLifecyclePhase = phasedHandlers.getKey();
                logger.debug("Entered {} handler lifecycle phase [{}]", (Object)this.lifecycleState.get().description, (Object)currentLifecyclePhase);
                List<LifecycleHandler> handlers = phasedHandlers.getValue();
                try {
                    handlers.stream().map(lch -> lch.run(this)).map(c -> c.thenRun(NOTHING)).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).orElse(FutureUtils.emptyCompletedFuture()).get(DefaultAxonApplication.this.lifecyclePhaseTimeout, DefaultAxonApplication.this.lifecyclePhaseTimeunit);
                }
                catch (CompletionException | ExecutionException e) {
                    exceptionHandler.accept(currentLifecyclePhase, e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Completion interrupted during {} phase [{}]. Proceeding to following phase", (Object)this.lifecycleState.get().description, (Object)currentLifecyclePhase);
                }
                catch (TimeoutException e) {
                    long lifecyclePhaseTimeoutInMillis = TimeUnit.MILLISECONDS.convert(DefaultAxonApplication.this.lifecyclePhaseTimeout, DefaultAxonApplication.this.lifecyclePhaseTimeunit);
                    logger.warn("Timed out during {} phase [{}] after {}ms. Proceeding to following phase", new Object[]{this.lifecycleState.get().description, currentLifecyclePhase, lifecyclePhaseTimeoutInMillis});
                }
            } while ((phasedHandlers = lifecycleHandlerMap.higherEntry(currentLifecyclePhase)) != null);
        }

        @Override
        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type, @Nullable String name) {
            return this.config.getOptionalComponent(type, name);
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name, @Nonnull Supplier<C> defaultImpl) {
            return this.config.getComponent(type, name, defaultImpl);
        }

        @Override
        public Configuration getParent() {
            return null;
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type) {
            return this.config.getComponent(type);
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nonnull Supplier<C> defaultImpl) {
            return this.config.getComponent(type, defaultImpl);
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name) {
            return this.config.getComponent(type, name);
        }

        @Override
        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type) {
            return this.config.getOptionalComponent(type);
        }

        @Override
        public List<Configuration> getModuleConfigurations() {
            return this.config.getModuleConfigurations();
        }

        @Override
        public Optional<Configuration> getModuleConfiguration(@Nonnull String name) {
            return this.config.getModuleConfiguration(name);
        }

        @Override
        @Nonnull
        public <C> Map<String, C> getComponents(@Nonnull Class<C> type) {
            return this.config.getComponents(type);
        }

        @Override
        public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            descriptor.describeProperty("components", DefaultAxonApplication.this.componentRegistry);
            descriptor.describeProperty("lifecycleState", (Object)this.lifecycleState.get());
        }
    }

    private static enum LifecycleState {
        DOWN("down"),
        STARTING_UP("start"),
        UP("up"),
        SHUTTING_DOWN("shutdown");

        private final String description;

        private LifecycleState(String description) {
            this.description = description;
        }
    }
}

