/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.axonframework.common.DefaultIdentifierFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentifierFactory {
    private static final Logger logger = LoggerFactory.getLogger(IdentifierFactory.class);
    private static final IdentifierFactory INSTANCE;

    private static IdentifierFactory locateFactories(ClassLoader classLoader, String classLoaderName) {
        IdentifierFactory found = null;
        Iterator<IdentifierFactory> services = ServiceLoader.load(IdentifierFactory.class, classLoader).iterator();
        if (services.hasNext()) {
            logger.debug("Found IdentifierFactory implementation using the {} Class Loader", (Object)classLoaderName);
            found = services.next();
            if (services.hasNext()) {
                logger.warn("More than one IdentifierFactory implementation was found using the {} Class Loader. This may result in different selections being made after restart of the application.", (Object)classLoaderName);
            }
        }
        return found;
    }

    public static IdentifierFactory getInstance() {
        return INSTANCE;
    }

    public abstract String generateIdentifier();

    static {
        logger.debug("Looking for IdentifierFactory implementation using the context class loader");
        IdentifierFactory factory = IdentifierFactory.locateFactories(Thread.currentThread().getContextClassLoader(), "Context");
        if (factory == null) {
            logger.debug("Looking for IdentifierFactory implementation using the IdentifierFactory class loader.");
            factory = IdentifierFactory.locateFactories(IdentifierFactory.class.getClassLoader(), "IdentifierFactory");
        }
        if (factory == null) {
            factory = new DefaultIdentifierFactory();
            logger.debug("Using default UUID-based IdentifierFactory");
        } else {
            logger.info("Found custom IdentifierFactory implementation: {}", (Object)factory.getClass().getName());
        }
        INSTANCE = factory;
    }
}

