/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseDate;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ScalarTypeYearMonthDate
extends ScalarTypeBaseDate<YearMonth> {
    public ScalarTypeYearMonthDate() {
        super(YearMonth.class, false, 91);
    }

    protected LocalDate toLocalDate(YearMonth yearMonth) {
        return LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
    }

    protected YearMonth fromLocalDate(LocalDate localDate) {
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    @Override
    public YearMonth convertFromMillis(long systemTimeMillis) {
        return this.fromLocalDate(new Timestamp(systemTimeMillis).toLocalDateTime().toLocalDate());
    }

    @Override
    public long convertToMillis(YearMonth value) {
        LocalDate localDate = this.toLocalDate(value);
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public YearMonth convertFromDate(Date ts) {
        return this.fromLocalDate(ts.toLocalDate());
    }

    @Override
    public Date convertToDate(YearMonth t) {
        return Date.valueOf(this.toLocalDate(t));
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof YearMonth) {
            return Date.valueOf(this.toLocalDate((YearMonth)value));
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public YearMonth toBeanType(Object value) {
        if (value instanceof YearMonth) {
            return (YearMonth)value;
        }
        if (value instanceof LocalDate) {
            return this.fromLocalDate((LocalDate)value);
        }
        return this.fromLocalDate(BasicTypeConverter.toDate(value).toLocalDate());
    }
}

