/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeUUIDBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;

public class ScalarTypeUUIDBinary
extends ScalarTypeUUIDBase {
    protected ScalarTypeUUIDBinary() {
        super(false, -2);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public Object toJdbcType(Object value) {
        return ScalarTypeUUIDBinary.convertToBytes(value);
    }

    @Override
    public UUID toBeanType(Object value) {
        if (value instanceof byte[]) {
            return ScalarTypeUUIDBinary.convertFromBytes((byte[])value);
        }
        return BasicTypeConverter.toUUID(value);
    }

    @Override
    public void bind(DataBind b, UUID value) throws SQLException {
        if (value == null) {
            b.setNull(-2);
        } else {
            b.setBytes(ScalarTypeUUIDBinary.convertToBytes(value));
        }
    }

    @Override
    public UUID read(DataReader dataReader) throws SQLException {
        byte[] bytes = dataReader.getBytes();
        if (bytes == null) {
            return null;
        }
        return ScalarTypeUUIDBinary.convertFromBytes(bytes);
    }

    public static UUID convertFromBytes(byte[] bytes) {
        int usableBytes = Math.min(bytes.length, 16);
        byte[] barr = new byte[16];
        int i = 15;
        for (int j = usableBytes - 1; j >= 0; --j) {
            barr[i] = bytes[j];
            --i;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(barr);
        DataInputStream inputStream = new DataInputStream(bais);
        try {
            long msb = inputStream.readLong();
            long lsb = inputStream.readLong();
            return new UUID(msb, lsb);
        }
        catch (IOException e) {
            throw new RuntimeException("Not Expecting this", e);
        }
    }

    public static byte[] convertToBytes(Object value) {
        UUID uuid = (UUID)value;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeLong(uuid.getMostSignificantBits());
            outputStream.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException e) {
            throw new RuntimeException("Not Expecting this", e);
        }
        return baos.toByteArray();
    }
}

