/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.PostgresHelper;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonCollection;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonSet {
    public static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docPropertyType) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docPropertyType);
                }
                case 5001: {
                    return new Json(docPropertyType);
                }
            }
        }
        return new Varchar(docPropertyType);
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docPropertyType) {
            super(jdbcType, docPropertyType);
            this.pgType = pgType;
        }

        @Override
        public void bind(DataBind bind, Set value) throws SQLException {
            String rawJson = value == null ? null : this.formatValue(value);
            bind.setObject(PostgresHelper.asObject(this.pgType, rawJson));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<Set> {
        public Base(int dbType, DocPropertyType docPropertyType) {
            super(Set.class, dbType, docPropertyType);
        }

        @Override
        public Set read(DataReader dataReader) throws SQLException {
            try {
                return EJson.parseSet(dataReader.getString(), true);
            }
            catch (IOException e) {
                throw new SQLException("Failed to parse JSON content as List: [" + dataReader.getString() + "]", e);
            }
        }

        @Override
        public void bind(DataBind b, Set value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else if (value.isEmpty()) {
                b.setString("[]");
            } else {
                try {
                    b.setString(EJson.write(value));
                }
                catch (IOException e) {
                    throw new SQLException("Failed to format Set into JSON content", e);
                }
            }
        }

        @Override
        public String formatValue(Set value) {
            try {
                return EJson.write(value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
            }
        }

        @Override
        public Set parse(String value) {
            try {
                return this.convertList(EJson.parseList(value));
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as Set: [" + value + "]", (Throwable)e);
            }
        }

        @Override
        public Set jsonRead(JsonParser parser) throws IOException {
            return this.convertList(EJson.parseList(parser, parser.getCurrentToken()));
        }

        @Override
        public void jsonWrite(JsonGenerator writer, Set value) throws IOException {
            EJson.write((Object)value, writer);
        }

        private Set convertList(List list) {
            LinkedHashSet set = new LinkedHashSet();
            set.addAll(list);
            return set;
        }
    }

    private static class JsonB
    extends PgBase {
        public JsonB(DocPropertyType docPropertyType) {
            super(5002, "jsonb", docPropertyType);
        }
    }

    private static class Json
    extends PgBase {
        public Json(DocPropertyType docPropertyType) {
            super(5001, "json", docPropertyType);
        }
    }

    private static class Varchar
    extends Base {
        public Varchar(DocPropertyType docPropertyType) {
            super(12, docPropertyType);
        }
    }
}

