/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.type.ArrayElementConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareList;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonCollection;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.PersistenceException;

public class ScalarTypeArrayList
extends ScalarTypeJsonCollection<List> {
    private static ScalarTypeArrayList UUID = new ScalarTypeArrayList("uuid", DocPropertyType.UUID, ArrayElementConverter.UUID);
    private static ScalarTypeArrayList LONG = new ScalarTypeArrayList("bigint", DocPropertyType.LONG, ArrayElementConverter.LONG);
    private static ScalarTypeArrayList INTEGER = new ScalarTypeArrayList("integer", DocPropertyType.INTEGER, ArrayElementConverter.INTEGER);
    private static ScalarTypeArrayList STRING = new ScalarTypeArrayList("varchar", DocPropertyType.STRING, ArrayElementConverter.STRING);
    private final String arrayType;
    private final ArrayElementConverter converter;

    public static ScalarTypeArrayList typeFor(Type valueType) {
        if (valueType.equals(UUID.class)) {
            return UUID;
        }
        if (valueType.equals(Long.class)) {
            return LONG;
        }
        if (valueType.equals(Integer.class)) {
            return INTEGER;
        }
        if (valueType.equals(String.class)) {
            return STRING;
        }
        throw new IllegalArgumentException("Type [" + valueType + "] not supported for @DbArray mapping");
    }

    public ScalarTypeArrayList(String arrayType, DocPropertyType docPropertyType, ArrayElementConverter converter) {
        super(List.class, 2003, docPropertyType);
        this.arrayType = arrayType;
        this.converter = converter;
    }

    @Override
    public DocPropertyType getDocType() {
        return this.docPropertyType;
    }

    public String getDbColumnDefn() {
        return this.arrayType + "[]";
    }

    private List fromArray(Object[] array1) {
        ArrayList list = new ArrayList();
        for (Object element : array1) {
            list.add(this.converter.toElement(element));
        }
        return new ModifyAwareList(list);
    }

    private Object[] toArray(List value) {
        return value.toArray();
    }

    @Override
    public List read(DataReader reader) throws SQLException {
        Array array = reader.getArray();
        if (array == null) {
            return null;
        }
        return this.fromArray((Object[])array.getArray());
    }

    @Override
    public void bind(DataBind bind, List value) throws SQLException {
        if (value == null) {
            bind.setNull(2003);
        } else {
            bind.setArray(this.arrayType, this.toArray(value));
        }
    }

    @Override
    public String formatValue(List value) {
        try {
            return EJson.write(value);
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
        }
    }

    @Override
    public List parse(String value) {
        try {
            return EJson.parseList(value, false);
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to parse JSON content as List: [" + value + "]", (Throwable)e);
        }
    }

    @Override
    public List jsonRead(JsonParser parser) throws IOException {
        return EJson.parseList(parser, parser.getCurrentToken());
    }

    @Override
    public void jsonWrite(JsonGenerator writer, List value) throws IOException {
        EJson.write((Object)value, writer);
    }
}

