/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.ModifyAwareFlag;
import com.avaje.ebeaninternal.server.type.ModifyAwareIterator;
import com.avaje.ebeaninternal.server.type.ModifyAwareListIterator;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ModifyAwareSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;

public class ModifyAwareList<E>
implements List<E>,
ModifyAwareOwner {
    final List<E> list;
    final ModifyAwareOwner owner;

    public ModifyAwareList(List<E> list) {
        this.list = list;
        this.owner = new ModifyAwareFlag();
    }

    public ModifyAwareList(ModifyAwareOwner owner, List<E> list) {
        this.list = list;
        this.owner = owner;
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isMarkedDirty() {
        return this.owner.isMarkedDirty();
    }

    @Override
    public void markAsModified() {
        this.owner.markAsModified();
    }

    @Override
    public void resetMarkedDirty() {
        this.owner.resetMarkedDirty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ModifyAwareIterator<E>(this.owner, this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.owner.markAsModified();
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.owner.markAsModified();
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.owner.markAsModified();
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.owner.markAsModified();
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.owner.markAsModified();
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.owner.markAsModified();
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.owner.markAsModified();
        this.list.clear();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.owner.markAsModified();
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.owner.markAsModified();
        this.list.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.owner.markAsModified();
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ModifyAwareListIterator<E>(this.owner, this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ModifyAwareListIterator<E>(this.owner, this.list.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ModifyAwareList<E>(this.owner, this.list.subList(fromIndex, toIndex));
    }

    public ModifyAwareSet<E> asSet() {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.addAll(this.list);
        return new ModifyAwareSet(this.owner, set);
    }
}

