/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.annotation.DbArray;
import com.avaje.ebean.annotation.DbEnumType;
import com.avaje.ebean.annotation.DbEnumValue;
import com.avaje.ebean.annotation.EnumValue;
import com.avaje.ebean.config.CompoundType;
import com.avaje.ebean.config.CompoundTypeProperty;
import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebean.config.ScalarTypeConverter;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.type.CompoundTypePeriod;
import com.avaje.ebeaninternal.server.type.CtCompoundType;
import com.avaje.ebeaninternal.server.type.DefaultTypeFactory;
import com.avaje.ebeaninternal.server.type.EnumToDbValueMap;
import com.avaje.ebeaninternal.server.type.ScalarDataReader;
import com.avaje.ebeaninternal.server.type.ScalarType;
import com.avaje.ebeaninternal.server.type.ScalarTypeArrayList;
import com.avaje.ebeaninternal.server.type.ScalarTypeBigDecimal;
import com.avaje.ebeaninternal.server.type.ScalarTypeBool;
import com.avaje.ebeaninternal.server.type.ScalarTypeByte;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesBinary;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesBlob;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesLongVarbinary;
import com.avaje.ebeaninternal.server.type.ScalarTypeBytesVarbinary;
import com.avaje.ebeaninternal.server.type.ScalarTypeChar;
import com.avaje.ebeaninternal.server.type.ScalarTypeCharArray;
import com.avaje.ebeaninternal.server.type.ScalarTypeClass;
import com.avaje.ebeaninternal.server.type.ScalarTypeClob;
import com.avaje.ebeaninternal.server.type.ScalarTypeCurrency;
import com.avaje.ebeaninternal.server.type.ScalarTypeDate;
import com.avaje.ebeaninternal.server.type.ScalarTypeDayOfWeek;
import com.avaje.ebeaninternal.server.type.ScalarTypeDouble;
import com.avaje.ebeaninternal.server.type.ScalarTypeDuration;
import com.avaje.ebeaninternal.server.type.ScalarTypeDurationWithNanos;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnumWithMapping;
import com.avaje.ebeaninternal.server.type.ScalarTypeFile;
import com.avaje.ebeaninternal.server.type.ScalarTypeFloat;
import com.avaje.ebeaninternal.server.type.ScalarTypeInetAddress;
import com.avaje.ebeaninternal.server.type.ScalarTypeInstant;
import com.avaje.ebeaninternal.server.type.ScalarTypeInteger;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaDateMidnight;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaDateTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaLocalDate;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaLocalDateTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaLocalTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeJodaLocalTimeUTC;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonList;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonMap;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonNode;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonNodePostgres;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonObjectMapper;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonSet;
import com.avaje.ebeaninternal.server.type.ScalarTypeLocalDate;
import com.avaje.ebeaninternal.server.type.ScalarTypeLocalDateTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeLocalTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeLocalTimeWithNanos;
import com.avaje.ebeaninternal.server.type.ScalarTypeLocale;
import com.avaje.ebeaninternal.server.type.ScalarTypeLong;
import com.avaje.ebeaninternal.server.type.ScalarTypeLongToTimestamp;
import com.avaje.ebeaninternal.server.type.ScalarTypeLongVarchar;
import com.avaje.ebeaninternal.server.type.ScalarTypeMonth;
import com.avaje.ebeaninternal.server.type.ScalarTypeMonthDay;
import com.avaje.ebeaninternal.server.type.ScalarTypeOffsetDateTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeOffsetTime;
import com.avaje.ebeaninternal.server.type.ScalarTypePath;
import com.avaje.ebeaninternal.server.type.ScalarTypePostgresHstore;
import com.avaje.ebeaninternal.server.type.ScalarTypeShort;
import com.avaje.ebeaninternal.server.type.ScalarTypeString;
import com.avaje.ebeaninternal.server.type.ScalarTypeTime;
import com.avaje.ebeaninternal.server.type.ScalarTypeTimeZone;
import com.avaje.ebeaninternal.server.type.ScalarTypeTimestamp;
import com.avaje.ebeaninternal.server.type.ScalarTypeURI;
import com.avaje.ebeaninternal.server.type.ScalarTypeURL;
import com.avaje.ebeaninternal.server.type.ScalarTypeUUIDBase;
import com.avaje.ebeaninternal.server.type.ScalarTypeUUIDBinary;
import com.avaje.ebeaninternal.server.type.ScalarTypeUUIDNative;
import com.avaje.ebeaninternal.server.type.ScalarTypeUUIDVarchar;
import com.avaje.ebeaninternal.server.type.ScalarTypeWrapper;
import com.avaje.ebeaninternal.server.type.ScalarTypeYear;
import com.avaje.ebeaninternal.server.type.ScalarTypeYearMonthDate;
import com.avaje.ebeaninternal.server.type.ScalarTypeZoneId;
import com.avaje.ebeaninternal.server.type.ScalarTypeZoneOffset;
import com.avaje.ebeaninternal.server.type.ScalarTypeZonedDateTime;
import com.avaje.ebeaninternal.server.type.TypeManager;
import com.avaje.ebeaninternal.server.type.TypeReflectHelper;
import com.avaje.ebeaninternal.server.type.reflect.CheckImmutable;
import com.avaje.ebeaninternal.server.type.reflect.CheckImmutableResponse;
import com.avaje.ebeaninternal.server.type.reflect.ImmutableMeta;
import com.avaje.ebeaninternal.server.type.reflect.ImmutableMetaFactory;
import com.avaje.ebeaninternal.server.type.reflect.KnownImmutable;
import com.avaje.ebeaninternal.server.type.reflect.ReflectionBasedCompoundType;
import com.avaje.ebeaninternal.server.type.reflect.ReflectionBasedCompoundTypeProperty;
import com.avaje.ebeaninternal.server.type.reflect.ReflectionBasedTypeBuilder;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTypeManager
implements TypeManager,
KnownImmutable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypeManager.class);
    private final ConcurrentHashMap<Class<?>, CtCompoundType<?>> compoundTypeMap;
    private final ConcurrentHashMap<Class<?>, ScalarType<?>> typeMap;
    private final ConcurrentHashMap<Integer, ScalarType<?>> nativeMap;
    private final DefaultTypeFactory extraTypeFactory;
    private final ScalarType<?> hstoreType = new ScalarTypePostgresHstore();
    private final ScalarTypeFile fileType = new ScalarTypeFile();
    private final ScalarType<?> charType = new ScalarTypeChar();
    private final ScalarType<?> charArrayType = new ScalarTypeCharArray();
    private final ScalarType<?> longVarcharType = new ScalarTypeLongVarchar();
    private final ScalarType<?> clobType = new ScalarTypeClob();
    private final ScalarType<?> byteType = new ScalarTypeByte();
    private final ScalarType<?> binaryType = new ScalarTypeBytesBinary();
    private final ScalarType<?> blobType = new ScalarTypeBytesBlob();
    private final ScalarType<?> varbinaryType = new ScalarTypeBytesVarbinary();
    private final ScalarType<?> longVarbinaryType = new ScalarTypeBytesLongVarbinary();
    private final ScalarType<?> shortType = new ScalarTypeShort();
    private final ScalarType<?> integerType = new ScalarTypeInteger();
    private final ScalarType<?> longType = new ScalarTypeLong();
    private final ScalarType<?> doubleType = new ScalarTypeDouble();
    private final ScalarType<?> floatType = new ScalarTypeFloat();
    private final ScalarType<?> bigDecimalType = new ScalarTypeBigDecimal();
    private final ScalarType<?> timeType = new ScalarTypeTime();
    private final ScalarType<?> dateType = new ScalarTypeDate();
    private final ScalarType<?> inetAddressType = new ScalarTypeInetAddress();
    private final ScalarType<?> urlType = new ScalarTypeURL();
    private final ScalarType<?> uriType = new ScalarTypeURI();
    private final ScalarType<?> localeType = new ScalarTypeLocale();
    private final ScalarType<?> currencyType = new ScalarTypeCurrency();
    private final ScalarType<?> timeZoneType = new ScalarTypeTimeZone();
    private final ScalarType<?> stringType = new ScalarTypeString();
    private final ScalarType<?> classType = new ScalarTypeClass();
    private final List<ScalarType<?>> customScalarTypes = new ArrayList();
    private final CheckImmutable checkImmutable;
    private final ImmutableMetaFactory immutableMetaFactory = new ImmutableMetaFactory();
    private final ReflectionBasedTypeBuilder reflectScalarBuilder;
    private final JsonConfig.DateTime jsonDateTime;
    private final Object objectMapper;
    private final boolean java7Present;
    private final boolean postgres;
    private final boolean offlineMigrationGeneration;
    private ScalarType<?> jsonNodeClob;
    private ScalarType<?> jsonNodeBlob;
    private ScalarType<?> jsonNodeVarchar;
    private ScalarType<?> jsonNodeJson;
    private ScalarType<?> jsonNodeJsonb;

    public DefaultTypeManager(ServerConfig config, BootupClasses bootupClasses) {
        this.java7Present = config.getClassLoadConfig().isJava7Present();
        this.jsonDateTime = config.getJsonDateTime();
        this.checkImmutable = new CheckImmutable(this);
        this.reflectScalarBuilder = new ReflectionBasedTypeBuilder(this);
        this.compoundTypeMap = new ConcurrentHashMap();
        this.typeMap = new ConcurrentHashMap();
        this.nativeMap = new ConcurrentHashMap();
        boolean objectMapperPresent = config.getClassLoadConfig().isJacksonObjectMapperPresent();
        this.objectMapper = objectMapperPresent ? this.initObjectMapper(config) : null;
        this.extraTypeFactory = new DefaultTypeFactory(config);
        this.postgres = this.isPostgres(config.getDatabasePlatform());
        this.offlineMigrationGeneration = DbOffline.isGenerateMigration();
        this.initialiseStandard(this.jsonDateTime, config);
        this.initialiseJavaTimeTypes(this.jsonDateTime, config);
        this.initialiseJodaTypes(this.jsonDateTime, config);
        this.initialiseJacksonTypes(config);
        if (bootupClasses != null) {
            this.initialiseCustomScalarTypes(this.jsonDateTime, bootupClasses);
            this.initialiseScalarConverters(bootupClasses);
            this.initialiseCompoundTypes(bootupClasses);
        }
    }

    private boolean isPostgres(DatabasePlatform databasePlatform) {
        return databasePlatform.getName().toLowerCase().startsWith("postgre");
    }

    @Override
    public boolean isKnownImmutable(Class<?> cls) {
        if (cls == null) {
            return true;
        }
        if (cls.isPrimitive() || Object.class.equals(cls)) {
            return true;
        }
        ScalarDataReader<?> scalarDataReader = this.getScalarDataReader(cls);
        return scalarDataReader != null;
    }

    @Override
    public CheckImmutableResponse checkImmutable(Class<?> cls) {
        return this.checkImmutable.checkImmutable(cls);
    }

    private ScalarType<?> register(ScalarType<?> st) {
        this.add(st);
        logger.debug("Registering ScalarType for " + st.getType() + " implemented using reflection");
        return st;
    }

    @Override
    public ScalarDataReader<?> recursiveCreateScalarDataReader(Class<?> cls) {
        ScalarDataReader<?> scalarReader = this.getScalarDataReader(cls);
        if (scalarReader != null) {
            return scalarReader;
        }
        ImmutableMeta meta = this.immutableMetaFactory.createImmutableMeta(cls);
        if (!meta.isCompoundType()) {
            return this.register(this.reflectScalarBuilder.buildScalarType(meta));
        }
        ReflectionBasedCompoundType compoundType = this.reflectScalarBuilder.buildCompound(meta);
        Class<?> compoundTypeClass = compoundType.getCompoundType();
        return this.createCompoundScalarDataReader(compoundTypeClass, compoundType, " using reflection");
    }

    @Override
    public ScalarType<?> recursiveCreateScalarTypes(Class<?> cls) {
        ScalarType<?> scalarType = this.getScalarType(cls);
        if (scalarType != null) {
            return scalarType;
        }
        ImmutableMeta meta = this.immutableMetaFactory.createImmutableMeta(cls);
        if (!meta.isCompoundType()) {
            return this.register(this.reflectScalarBuilder.buildScalarType(meta));
        }
        throw new RuntimeException("Not allowed compound types here");
    }

    @Override
    public void add(ScalarType<?> scalarType) {
        this.typeMap.put(scalarType.getType(), scalarType);
        this.logAdd(scalarType);
    }

    protected void logAdd(ScalarType<?> scalarType) {
        if (logger.isDebugEnabled()) {
            String msg = "ScalarType register [" + scalarType.getClass().getName() + "]";
            msg = msg + " for [" + scalarType.getType().getName() + "]";
            logger.debug(msg);
        }
    }

    @Override
    public CtCompoundType<?> getCompoundType(Class<?> type) {
        return this.compoundTypeMap.get(type);
    }

    @Override
    public ScalarType<?> getScalarType(int jdbcType) {
        return this.nativeMap.get(jdbcType);
    }

    @Override
    public ScalarType<?> getScalarType(Class<?> type) {
        ScalarType<?> found = this.typeMap.get(type);
        if (found == null) {
            if (type.getName().equals("org.joda.time.LocalTime")) {
                throw new IllegalStateException("ScalarType of Joda LocalTime not defined. You need to set ServerConfig.jodaLocalTimeMode to either 'normal' or 'utc'.  UTC is the old mode using UTC timezone but local time zone is now preferred as 'normal' mode.");
            }
            found = this.checkInterfaceTypes(type);
        }
        return found;
    }

    private ScalarType<?> checkInterfaceTypes(Class<?> type) {
        if (this.java7Present) {
            return this.checkJava7InterfaceTypes(type);
        }
        return null;
    }

    private ScalarType<?> checkJava7InterfaceTypes(Class<?> type) {
        if (Path.class.isAssignableFrom(type)) {
            return this.typeMap.get(Path.class);
        }
        return null;
    }

    public ScalarDataReader<?> getScalarDataReader(Class<?> propertyType, int sqlType) {
        if (sqlType == 0) {
            return this.recursiveCreateScalarDataReader(propertyType);
        }
        for (int i = 0; i < this.customScalarTypes.size(); ++i) {
            ScalarType<?> customScalarType = this.customScalarTypes.get(i);
            if (sqlType != customScalarType.getJdbcType() || !propertyType.equals(customScalarType.getType())) continue;
            return customScalarType;
        }
        String msg = "Unable to find a custom ScalarType with type [" + propertyType + "] and java.sql.Type [" + sqlType + "]";
        throw new RuntimeException(msg);
    }

    public ScalarDataReader<?> getScalarDataReader(Class<?> type) {
        ScalarDataReader reader = this.typeMap.get(type);
        if (reader == null) {
            reader = this.compoundTypeMap.get(type);
        }
        return reader;
    }

    @Override
    public ScalarType<?> getHstoreScalarType() {
        return this.postgres ? this.hstoreType : ScalarTypeJsonMap.typeFor(false, 12);
    }

    @Override
    public ScalarType<?> getArrayScalarType(Class<?> type, DbArray dbArray, Type genericType) {
        if (type.equals(List.class)) {
            if (this.postgres) {
                Type valueType = this.getValueType(genericType);
                return ScalarTypeArrayList.typeFor(valueType);
            }
            return new ScalarTypeJsonList.Varchar(this.getDocType(this.getValueType(genericType)));
        }
        throw new IllegalStateException("Type [" + type + "] not supported for @DbArray");
    }

    @Override
    public ScalarType<?> getJsonScalarType(Class<?> type, int dbType, int dbLength, Type genericType) {
        if (type.equals(List.class)) {
            DocPropertyType docType = this.getDocType(genericType);
            if (this.isValueTypeSimple(genericType)) {
                return ScalarTypeJsonList.typeFor(this.postgres, dbType, docType);
            }
            return this.createJsonObjectMapperType(type, genericType, dbType, docType);
        }
        if (type.equals(Set.class)) {
            DocPropertyType docType = this.getDocType(genericType);
            if (this.isValueTypeSimple(genericType)) {
                return ScalarTypeJsonSet.typeFor(this.postgres, dbType, docType);
            }
            return this.createJsonObjectMapperType(type, genericType, dbType, docType);
        }
        if (type.equals(Map.class)) {
            if (this.isMapValueTypeObject(genericType)) {
                return ScalarTypeJsonMap.typeFor(this.postgres, dbType);
            }
            return this.createJsonObjectMapperType(type, genericType, dbType, DocPropertyType.OBJECT);
        }
        if (type.equals(JsonNode.class)) {
            switch (dbType) {
                case 12: {
                    return this.jsonNodeVarchar;
                }
                case 2004: {
                    return this.jsonNodeBlob;
                }
                case 2005: {
                    return this.jsonNodeClob;
                }
                case 5002: {
                    return this.jsonNodeJsonb;
                }
                case 5001: {
                    return this.jsonNodeJson;
                }
            }
            return this.jsonNodeJson;
        }
        return this.createJsonObjectMapperType(type, type, dbType, DocPropertyType.OBJECT);
    }

    private DocPropertyType getDocType(Type genericType) {
        ScalarType<?> found;
        if (genericType instanceof Class && (found = this.typeMap.get(genericType)) != null) {
            return found.getDocType();
        }
        return DocPropertyType.OBJECT;
    }

    private boolean isValueTypeSimple(Type genericType) {
        Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
        return String.class.equals((Object)typeArgs[0]) || Long.class.equals((Object)typeArgs[0]);
    }

    private Type getValueType(Type genericType) {
        Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
        return typeArgs[0];
    }

    private boolean isMapValueTypeObject(Type genericType) {
        Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
        return Object.class.equals((Object)typeArgs[1]);
    }

    private ScalarType<?> createJsonObjectMapperType(Class<?> type, Type genericType, int dbType, DocPropertyType docType) {
        if (this.objectMapper == null) {
            throw new IllegalArgumentException("Type [" + type + "] unsupported for @DbJson mapping - Jackson ObjectMapper not present");
        }
        return ScalarTypeJsonObjectMapper.createTypeFor(this.postgres, type, (ObjectMapper)this.objectMapper, genericType, dbType, docType);
    }

    @Override
    public ScalarType<?> getScalarType(Class<?> type, int jdbcType) {
        if (File.class.equals(type)) {
            return this.fileType;
        }
        ScalarType<?> scalarType = this.getLobTypes(jdbcType);
        if (scalarType != null) {
            return scalarType;
        }
        scalarType = this.typeMap.get(type);
        if (scalarType != null && (jdbcType == 0 || scalarType.getJdbcType() == jdbcType)) {
            return scalarType;
        }
        if (type.equals(Date.class)) {
            return this.extraTypeFactory.createUtilDate(this.jsonDateTime, jdbcType);
        }
        if (type.equals(Calendar.class)) {
            return this.extraTypeFactory.createCalendar(this.jsonDateTime, jdbcType);
        }
        throw new IllegalArgumentException("Unmatched ScalarType for " + type + " jdbcType:" + jdbcType);
    }

    private ScalarType<?> getLobTypes(int jdbcType) {
        return this.getScalarType(jdbcType);
    }

    public Object convert(Object value, int toJdbcType) {
        if (value == null) {
            return null;
        }
        ScalarType<?> type = this.nativeMap.get(toJdbcType);
        if (type != null) {
            return type.toJdbcType(value);
        }
        return value;
    }

    protected boolean isIntegerType(String s) {
        if (this.isLeadingZeros(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isLeadingZeros(String s) {
        return s.length() > 1 && s.charAt(0) == '0';
    }

    private ScalarType<?> createEnumScalarType2(Class<?> enumType) {
        boolean integerType = true;
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        Field[] fields = enumType.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            EnumValue enumValue = fields[i].getAnnotation(EnumValue.class);
            if (enumValue == null) continue;
            nameValueMap.put(fields[i].getName(), enumValue.value());
            if (!integerType || this.isIntegerType(enumValue.value())) continue;
            integerType = false;
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, 0);
    }

    @Override
    public ScalarType<?> createEnumScalarType(Class<? extends Enum<?>> enumType) {
        Method[] methods = enumType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            DbEnumValue dbValue = methods[i].getAnnotation(DbEnumValue.class);
            if (dbValue == null) continue;
            boolean integerValues = DbEnumType.INTEGER == dbValue.storage();
            return this.createEnumScalarTypeDbValue(enumType, methods[i], integerValues);
        }
        return this.createEnumScalarType2(enumType);
    }

    private ScalarType<?> createEnumScalarTypeDbValue(Class<? extends Enum<?>> enumType, Method method, boolean integerType) {
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        Enum<?>[] enumConstants = enumType.getEnumConstants();
        for (int i = 0; i < enumConstants.length; ++i) {
            try {
                Object value = method.invoke(enumConstants[i], new Object[0]);
                nameValueMap.put(enumConstants[i].name(), value.toString());
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error trying to invoke DbEnumValue method on " + enumConstants[i], e);
            }
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, 0);
    }

    private ScalarType<?> createEnumScalarType(Class enumType, Map<String, String> nameValueMap, boolean integerType, int dbColumnLength) {
        EnumToDbValueMap<?> beanDbMap = EnumToDbValueMap.create(integerType);
        int maxValueLen = 0;
        for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            maxValueLen = Math.max(maxValueLen, value.length());
            Object enumValue = Enum.valueOf(enumType, name.trim());
            beanDbMap.add(enumValue, value, name.trim());
        }
        if (dbColumnLength == 0 && !integerType) {
            dbColumnLength = maxValueLen;
        }
        return new ScalarTypeEnumWithMapping(beanDbMap, enumType, dbColumnLength);
    }

    protected void initialiseCustomScalarTypes(JsonConfig.DateTime mode, BootupClasses bootupClasses) {
        ScalarTypeLongToTimestamp longToTimestamp = new ScalarTypeLongToTimestamp(mode);
        this.customScalarTypes.add(longToTimestamp);
        List<Class<?>> foundTypes = bootupClasses.getScalarTypes();
        for (int i = 0; i < foundTypes.size(); ++i) {
            Class<?> cls = foundTypes.get(i);
            try {
                ScalarType scalarType;
                if (this.objectMapper == null) {
                    scalarType = (ScalarType)cls.newInstance();
                } else {
                    try {
                        Constructor<?> constructor = cls.getConstructor(ObjectMapper.class);
                        scalarType = (ScalarType)constructor.newInstance((ObjectMapper)this.objectMapper);
                    }
                    catch (NoSuchMethodException e) {
                        scalarType = (ScalarType)cls.newInstance();
                    }
                }
                this.add(scalarType);
                this.customScalarTypes.add(scalarType);
                continue;
            }
            catch (Exception e) {
                String msg = "Error loading ScalarType [" + cls.getName() + "]";
                logger.error(msg, (Throwable)e);
            }
        }
    }

    private Object initObjectMapper(ServerConfig serverConfig) {
        Object objectMapper = serverConfig.getObjectMapper();
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            serverConfig.setObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    protected void initialiseScalarConverters(BootupClasses bootupClasses) {
        List<Class<?>> foundTypes = bootupClasses.getScalarConverters();
        for (int i = 0; i < foundTypes.size(); ++i) {
            Class<?> cls = foundTypes.get(i);
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(cls, ScalarTypeConverter.class);
                if (paramTypes.length != 2) {
                    throw new IllegalStateException("Expected 2 generics paramtypes but got: " + Arrays.toString(paramTypes));
                }
                Class<?> logicalType = paramTypes[0];
                Class<?> persistType = paramTypes[1];
                ScalarType<?> wrappedType = this.getScalarType(persistType);
                if (wrappedType == null) {
                    throw new IllegalStateException("Could not find ScalarType for: " + paramTypes[1]);
                }
                ScalarTypeConverter converter = (ScalarTypeConverter)cls.newInstance();
                ScalarTypeWrapper stw = new ScalarTypeWrapper(logicalType, wrappedType, converter);
                logger.debug("Register ScalarTypeWrapper from " + logicalType + " -> " + persistType + " using:" + cls);
                this.add(stw);
                continue;
            }
            catch (Exception e) {
                String msg = "Error loading ScalarType [" + cls.getName() + "]";
                logger.error(msg, (Throwable)e);
            }
        }
    }

    protected void initialiseCompoundTypes(BootupClasses bootupClasses) {
        List<Class<?>> compoundTypes = bootupClasses.getCompoundTypes();
        for (int j = 0; j < compoundTypes.size(); ++j) {
            Class<?> type = compoundTypes.get(j);
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(type, CompoundType.class);
                if (paramTypes.length != 1) {
                    throw new RuntimeException("Expecting 1 generic paramter type but got " + Arrays.toString(paramTypes) + " for " + type);
                }
                Class<?> compoundTypeClass = paramTypes[0];
                CompoundType compoundType = (CompoundType)type.newInstance();
                this.createCompoundScalarDataReader(compoundTypeClass, compoundType, "");
                continue;
            }
            catch (Exception e) {
                String msg = "Error initialising component " + type;
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected CtCompoundType createCompoundScalarDataReader(Class<?> compoundTypeClass, CompoundType<?> compoundType, String info) {
        CtCompoundType<?> ctCompoundType = this.compoundTypeMap.get(compoundTypeClass);
        if (ctCompoundType != null) {
            logger.info("Already registered compound type " + compoundTypeClass);
            return ctCompoundType;
        }
        CompoundTypeProperty<?, ?>[] cprops = compoundType.getProperties();
        ScalarDataReader[] dataReaders = new ScalarDataReader[cprops.length];
        for (int i = 0; i < cprops.length; ++i) {
            Class<?> propertyType = this.getCompoundPropertyType(cprops[i]);
            ScalarDataReader<?> scalarDataReader = this.getScalarDataReader(propertyType, cprops[i].getDbType());
            if (scalarDataReader == null) {
                throw new RuntimeException("Could not find ScalarDataReader for " + propertyType);
            }
            dataReaders[i] = scalarDataReader;
        }
        CtCompoundType ctType = new CtCompoundType(compoundTypeClass, compoundType, dataReaders);
        logger.debug("Registering CompoundType " + compoundTypeClass + " " + info);
        this.compoundTypeMap.put(compoundTypeClass, ctType);
        return ctType;
    }

    private Class<?> getCompoundPropertyType(CompoundTypeProperty<?, ?> prop) {
        if (prop instanceof ReflectionBasedCompoundTypeProperty) {
            return ((ReflectionBasedCompoundTypeProperty)prop).getPropertyType();
        }
        Object[] propParamTypes = TypeReflectHelper.getParams(prop.getClass(), CompoundTypeProperty.class);
        if (propParamTypes.length != 2) {
            throw new RuntimeException("Expecting 2 generic paramter types but got " + Arrays.toString(propParamTypes) + " for " + prop.getClass());
        }
        return propParamTypes[1];
    }

    protected void initialiseJacksonTypes(ServerConfig config) {
        if (this.objectMapper != null) {
            logger.trace("Registering JsonNode type support");
            ObjectMapper mapper = (ObjectMapper)this.objectMapper;
            this.jsonNodeClob = new ScalarTypeJsonNode.Clob(mapper);
            this.jsonNodeBlob = new ScalarTypeJsonNode.Blob(mapper);
            this.jsonNodeVarchar = new ScalarTypeJsonNode.Varchar(mapper);
            this.jsonNodeJson = this.jsonNodeClob;
            this.jsonNodeJsonb = this.jsonNodeClob;
            if (this.isPostgres(config.getDatabasePlatform())) {
                this.jsonNodeJson = new ScalarTypeJsonNodePostgres.JSON(mapper);
                this.jsonNodeJsonb = new ScalarTypeJsonNodePostgres.JSONB(mapper);
            }
            this.typeMap.put(JsonNode.class, this.jsonNodeJson);
        }
    }

    protected void initialiseJavaTimeTypes(JsonConfig.DateTime mode, ServerConfig config) {
        if (this.java7Present) {
            this.typeMap.put(Path.class, new ScalarTypePath());
        }
        if (config.getClassLoadConfig().isJavaTimePresent()) {
            logger.debug("Registering java.time data types");
            this.typeMap.put(LocalDate.class, new ScalarTypeLocalDate());
            this.typeMap.put(java.time.LocalDateTime.class, new ScalarTypeLocalDateTime(mode));
            this.typeMap.put(OffsetDateTime.class, new ScalarTypeOffsetDateTime(mode));
            this.typeMap.put(ZonedDateTime.class, new ScalarTypeZonedDateTime(mode));
            this.typeMap.put(Instant.class, new ScalarTypeInstant(mode));
            this.typeMap.put(DayOfWeek.class, new ScalarTypeDayOfWeek());
            this.typeMap.put(Month.class, new ScalarTypeMonth());
            this.typeMap.put(Year.class, new ScalarTypeYear());
            this.typeMap.put(YearMonth.class, new ScalarTypeYearMonthDate());
            this.typeMap.put(MonthDay.class, new ScalarTypeMonthDay());
            this.typeMap.put(OffsetTime.class, new ScalarTypeOffsetTime());
            this.typeMap.put(ZoneId.class, new ScalarTypeZoneId());
            this.typeMap.put(ZoneOffset.class, new ScalarTypeZoneOffset());
            this.createCompoundScalarDataReader(Period.class, new CompoundTypePeriod(), "");
            boolean localTimeNanos = config.isLocalTimeWithNanos();
            this.typeMap.put(java.time.LocalTime.class, localTimeNanos ? new ScalarTypeLocalTimeWithNanos() : new ScalarTypeLocalTime());
            boolean durationNanos = config.isDurationWithNanos();
            this.typeMap.put(Duration.class, durationNanos ? new ScalarTypeDurationWithNanos() : new ScalarTypeDuration());
        }
    }

    protected void initialiseJodaTypes(JsonConfig.DateTime mode, ServerConfig config) {
        if (config.getClassLoadConfig().isJodaTimePresent()) {
            logger.debug("Registering Joda data types");
            this.typeMap.put(LocalDateTime.class, new ScalarTypeJodaLocalDateTime(mode));
            this.typeMap.put(DateTime.class, new ScalarTypeJodaDateTime(mode));
            this.typeMap.put(org.joda.time.LocalDate.class, new ScalarTypeJodaLocalDate());
            this.typeMap.put(DateMidnight.class, new ScalarTypeJodaDateMidnight());
            String jodaLocalTimeMode = config.getJodaLocalTimeMode();
            if ("normal".equalsIgnoreCase(jodaLocalTimeMode)) {
                this.typeMap.put(LocalTime.class, new ScalarTypeJodaLocalTime());
                logger.debug("registered ScalarTypeJodaLocalTime");
            } else if ("utc".equalsIgnoreCase(jodaLocalTimeMode)) {
                this.typeMap.put(LocalTime.class, new ScalarTypeJodaLocalTimeUTC());
                logger.debug("registered ScalarTypeJodaLocalTimeUTC");
            }
        }
    }

    protected void initialiseStandard(JsonConfig.DateTime mode, ServerConfig config) {
        DatabasePlatform databasePlatform = config.getDatabasePlatform();
        int platformClobType = databasePlatform.getClobDbType();
        int platformBlobType = databasePlatform.getBlobDbType();
        this.nativeMap.put(5000, this.hstoreType);
        ScalarType<Date> utilDateType = this.extraTypeFactory.createUtilDate(mode);
        this.typeMap.put(Date.class, utilDateType);
        ScalarType<Calendar> calType = this.extraTypeFactory.createCalendar(mode);
        this.typeMap.put(Calendar.class, calType);
        ScalarType<BigInteger> mathBigIntType = this.extraTypeFactory.createMathBigInteger();
        this.typeMap.put(BigInteger.class, mathBigIntType);
        ScalarTypeBool booleanType = this.extraTypeFactory.createBoolean();
        this.typeMap.put(Boolean.class, booleanType);
        this.typeMap.put(Boolean.TYPE, booleanType);
        databasePlatform.setDbTrueLiteral(booleanType.getDbTrueLiteral());
        databasePlatform.setDbFalseLiteral(booleanType.getDbFalseLiteral());
        this.nativeMap.put(16, booleanType);
        if (booleanType.getJdbcType() == -7) {
            this.nativeMap.put(-7, booleanType);
        }
        ServerConfig.DbUuid dbUuid = config.getDbUuid();
        if (this.offlineMigrationGeneration || databasePlatform.isNativeUuidType() && dbUuid.useNativeType()) {
            this.typeMap.put(UUID.class, new ScalarTypeUUIDNative());
        } else {
            ScalarTypeUUIDBase uuidType = dbUuid.useBinary() ? new ScalarTypeUUIDBinary() : new ScalarTypeUUIDVarchar();
            this.typeMap.put(UUID.class, uuidType);
        }
        this.typeMap.put(File.class, this.fileType);
        this.typeMap.put(InetAddress.class, this.inetAddressType);
        this.typeMap.put(Locale.class, this.localeType);
        this.typeMap.put(Currency.class, this.currencyType);
        this.typeMap.put(TimeZone.class, this.timeZoneType);
        this.typeMap.put(URL.class, this.urlType);
        this.typeMap.put(URI.class, this.uriType);
        this.typeMap.put(char[].class, this.charArrayType);
        this.typeMap.put(Character.TYPE, this.charType);
        this.typeMap.put(String.class, this.stringType);
        this.nativeMap.put(12, this.stringType);
        this.nativeMap.put(1, this.stringType);
        this.nativeMap.put(-1, this.longVarcharType);
        this.typeMap.put(Class.class, this.classType);
        if (platformClobType == 2005) {
            this.nativeMap.put(2005, this.clobType);
        } else {
            ScalarType<?> platClobScalarType = this.nativeMap.get(platformClobType);
            if (platClobScalarType == null) {
                throw new IllegalArgumentException("Type for dbPlatform clobType [" + this.clobType + "] not found.");
            }
            this.nativeMap.put(2005, platClobScalarType);
        }
        this.typeMap.put(byte[].class, this.varbinaryType);
        this.nativeMap.put(-2, this.binaryType);
        this.nativeMap.put(-3, this.varbinaryType);
        this.nativeMap.put(-4, this.longVarbinaryType);
        if (platformBlobType == 2004) {
            this.nativeMap.put(2004, this.blobType);
        } else {
            ScalarType<?> platBlobScalarType = this.nativeMap.get(platformBlobType);
            if (platBlobScalarType == null) {
                throw new IllegalArgumentException("Type for dbPlatform blobType [" + this.blobType + "] not found.");
            }
            this.nativeMap.put(2004, platBlobScalarType);
        }
        this.typeMap.put(Byte.class, this.byteType);
        this.typeMap.put(Byte.TYPE, this.byteType);
        this.nativeMap.put(-6, this.byteType);
        this.typeMap.put(Short.class, this.shortType);
        this.typeMap.put(Short.TYPE, this.shortType);
        this.nativeMap.put(5, this.shortType);
        this.typeMap.put(Integer.class, this.integerType);
        this.typeMap.put(Integer.TYPE, this.integerType);
        this.nativeMap.put(4, this.integerType);
        this.typeMap.put(Long.class, this.longType);
        this.typeMap.put(Long.TYPE, this.longType);
        this.nativeMap.put(-5, this.longType);
        this.typeMap.put(Double.class, this.doubleType);
        this.typeMap.put(Double.TYPE, this.doubleType);
        this.nativeMap.put(6, this.doubleType);
        this.nativeMap.put(8, this.doubleType);
        this.typeMap.put(Float.class, this.floatType);
        this.typeMap.put(Float.TYPE, this.floatType);
        this.nativeMap.put(7, this.floatType);
        this.typeMap.put(BigDecimal.class, this.bigDecimalType);
        this.nativeMap.put(3, this.bigDecimalType);
        this.nativeMap.put(2, this.bigDecimalType);
        this.typeMap.put(Time.class, this.timeType);
        this.nativeMap.put(92, this.timeType);
        this.typeMap.put(java.sql.Date.class, this.dateType);
        this.nativeMap.put(91, this.dateType);
        ScalarTypeTimestamp timestampType = new ScalarTypeTimestamp(mode);
        this.typeMap.put(Timestamp.class, timestampType);
        this.nativeMap.put(93, timestampType);
    }
}

