/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeJsonParser {
    private final SimpleDateFormat dateTimeProto20 = this.init("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat dateTimeProto22 = this.init("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    private final SimpleDateFormat dateTimeProto23 = this.init("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
    private final SimpleDateFormat dateTimeProto24 = this.init("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    private SimpleDateFormat init(String dateTimeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    private SimpleDateFormat dtFormat(int length) {
        switch (length) {
            case 24: {
                return (SimpleDateFormat)this.dateTimeProto24.clone();
            }
            case 23: {
                return (SimpleDateFormat)this.dateTimeProto23.clone();
            }
            case 22: {
                return (SimpleDateFormat)this.dateTimeProto22.clone();
            }
            case 20: {
                return (SimpleDateFormat)this.dateTimeProto20.clone();
            }
        }
        return (SimpleDateFormat)this.dateTimeProto24.clone();
    }

    public Timestamp parse(String jsonDateTime) {
        try {
            Date d = this.dtFormat(jsonDateTime.length()).parse(jsonDateTime);
            return new Timestamp(d.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing Datetime[" + jsonDateTime + "]", e);
        }
    }

    public String format(Date value) {
        return this.dtFormat(24).format(value);
    }
}

