/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public final class ConvertInetAddresses {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;

    private ConvertInetAddresses() {
    }

    public static InetAddress forString(String ipString) {
        byte[] addr = ConvertInetAddresses.textToNumericFormatV4(ipString);
        if (addr == null) {
            addr = ConvertInetAddresses.textToNumericFormatV6(ipString);
        }
        if (addr == null) {
            throw new IllegalArgumentException(String.format("'%s' is not an IP string literal.", ipString));
        }
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("'%s' is extremely broken.", ipString), e);
        }
    }

    public static boolean isInetAddress(String ipString) {
        try {
            ConvertInetAddresses.forString(ipString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static byte[] textToNumericFormatV4(String ipString) {
        boolean isIpv6 = false;
        if (ipString.toUpperCase(Locale.US).startsWith("::FFFF:")) {
            ipString = ipString.substring(7);
        } else if (ipString.startsWith("::")) {
            ipString = ipString.substring(2);
            isIpv6 = true;
        }
        String[] address = ipString.split("\\.");
        if (address.length != 4) {
            return null;
        }
        try {
            byte[] bytes = new byte[4];
            for (int i = 0; i < bytes.length; ++i) {
                int piece = Integer.parseInt(address[i]);
                if (piece < 0 || piece > 255) {
                    return null;
                }
                if (address[i].startsWith("0") && address[i].length() != 1) {
                    return null;
                }
                bytes[i] = (byte)piece;
            }
            if (isIpv6) {
                byte[] data = new byte[16];
                System.arraycopy(bytes, 0, data, 12, 4);
                return data;
            }
            return bytes;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static byte[] textToNumericFormatV6(String ipString) {
        if (!ipString.contains(":")) {
            return null;
        }
        if (ipString.contains(":::")) {
            return null;
        }
        if (ipString.contains(".") && (ipString = ConvertInetAddresses.convertDottedQuadToHex(ipString)) == null) {
            return null;
        }
        ipString = ConvertInetAddresses.padIpString(ipString);
        try {
            String[] address = ipString.split(":", 8);
            if (address.length != 8) {
                return null;
            }
            byte[] bytes = new byte[16];
            for (int i = 0; i < 8; ++i) {
                int piece = address[i].equals("") ? 0 : Integer.parseInt(address[i], 16);
                bytes[2 * i] = (byte)((piece & 0xFF00) >>> 8);
                bytes[2 * i + 1] = (byte)(piece & 0xFF);
            }
            return bytes;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String padIpString(String ipString) {
        if (ipString.contains("::")) {
            int count = ConvertInetAddresses.numberOfColons(ipString);
            StringBuilder buffer = new StringBuilder("::");
            int i = 0;
            while (i + count < 7) {
                buffer.append(":");
                ++i;
            }
            ipString = ipString.replace("::", buffer);
        }
        return ipString;
    }

    private static int numberOfColons(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ':') continue;
            ++count;
        }
        return count;
    }

    private static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = ConvertInetAddresses.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    public static String toUriString(InetAddress ip) {
        if (ip instanceof Inet6Address) {
            return "[" + ip.getHostAddress() + "]";
        }
        return ip.getHostAddress();
    }

    public static InetAddress forUriString(String hostAddr) {
        InetAddress retval;
        try {
            retval = ConvertInetAddresses.forString(hostAddr);
            if (retval instanceof Inet4Address) {
                return retval;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!hostAddr.startsWith("[") || !hostAddr.endsWith("]")) {
            throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
        }
        retval = ConvertInetAddresses.forString(hostAddr.substring(1, hostAddr.length() - 1));
        if (retval instanceof Inet6Address) {
            return retval;
        }
        throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
    }
}

