/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.Query;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionFactory;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.expression.FilterExprPath;
import com.avaje.ebeaninternal.server.expression.FilterExpressionList;
import com.avaje.ebeaninternal.server.expression.Same;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryPropertiesParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OrmQueryProperties
implements Serializable {
    private static final long serialVersionUID = -8785582703966455658L;
    protected static final FetchConfig DEFAULT_FETCH = new FetchConfig();
    private final String parentPath;
    private final String path;
    private final String rawProperties;
    private final String trimmedProperties;
    private final LinkedHashSet<String> included;
    private final FetchConfig fetchConfig;
    private boolean markForQueryJoin;
    private boolean cache;
    private boolean readOnly;
    private Set<String> includedBeanJoin;
    private Set<String> secondaryQueryJoins;
    private List<OrmQueryProperties> secondaryChildren;
    private OrderBy orderBy;
    private SpiExpressionList filterMany;

    public OrmQueryProperties() {
        this((String)null);
    }

    public OrmQueryProperties(String path) {
        this.path = path;
        this.parentPath = SplitName.parent(path);
        this.rawProperties = null;
        this.trimmedProperties = null;
        this.included = null;
        this.fetchConfig = DEFAULT_FETCH;
    }

    public OrmQueryProperties(String path, String rawProperties) {
        this(path, rawProperties, null);
    }

    public OrmQueryProperties(String path, String rawProperties, FetchConfig fetchConfig) {
        OrmQueryPropertiesParser.Response response = OrmQueryPropertiesParser.parse(rawProperties);
        this.path = path;
        this.parentPath = SplitName.parent(path);
        this.rawProperties = rawProperties;
        this.trimmedProperties = response.properties;
        this.included = response.included;
        this.cache = response.cache;
        this.readOnly = response.readOnly;
        this.fetchConfig = fetchConfig != null ? fetchConfig : response.fetchConfig;
    }

    public OrmQueryProperties(String path, LinkedHashSet<String> parsedProperties) {
        if (parsedProperties == null) {
            throw new IllegalArgumentException("parsedProperties is null");
        }
        this.path = path;
        this.parentPath = SplitName.parent(path);
        this.included = parsedProperties;
        this.trimmedProperties = this.rawProperties = this.join(parsedProperties);
        this.cache = false;
        this.readOnly = false;
        this.fetchConfig = DEFAULT_FETCH;
    }

    private String join(LinkedHashSet<String> parsedProperties) {
        StringBuilder sb = new StringBuilder(50);
        boolean first = true;
        for (String property : parsedProperties) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(property);
        }
        return sb.toString();
    }

    private OrmQueryProperties(OrmQueryProperties source) {
        this.parentPath = source.parentPath;
        this.path = source.path;
        this.rawProperties = source.rawProperties;
        this.trimmedProperties = source.trimmedProperties;
        this.cache = source.cache;
        this.readOnly = source.readOnly;
        this.fetchConfig = source.fetchConfig;
        this.filterMany = source.filterMany;
        LinkedHashSet<String> linkedHashSet = this.included = source.included == null ? null : new LinkedHashSet<String>(source.included);
        if (this.includedBeanJoin != null) {
            this.includedBeanJoin = new HashSet<String>(source.includedBeanJoin);
        }
    }

    public OrmQueryProperties copy() {
        return new OrmQueryProperties(this);
    }

    public void addSecJoinOrderProperty(OrderBy.Property orderProp) {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        this.orderBy.add(orderProp);
    }

    public FetchConfig getFetchConfig() {
        return this.fetchConfig;
    }

    public <T> SpiExpressionList<T> filterMany(Query<T> rootQuery) {
        if (this.filterMany == null) {
            FilterExprPath exprPath = new FilterExprPath(this.path);
            SpiExpressionFactory queryEf = (SpiExpressionFactory)rootQuery.getExpressionFactory();
            ExpressionFactory filterEf = queryEf.createExpressionFactory();
            this.filterMany = new FilterExpressionList<T>(exprPath, filterEf, rootQuery);
            this.markForQueryJoin = true;
        }
        return this.filterMany;
    }

    public SpiExpressionList<?> getFilterManyTrimPath(int trimPath) {
        if (this.filterMany == null) {
            return null;
        }
        return this.filterMany.trimPath(trimPath);
    }

    public SpiExpressionList<?> getFilterMany() {
        return this.filterMany;
    }

    public void setFilterMany(SpiExpressionList<?> filterMany) {
        this.filterMany = filterMany;
        this.markForQueryJoin = true;
    }

    public void configureBeanQuery(SpiQuery<?> query) {
        if (this.trimmedProperties != null && !this.trimmedProperties.isEmpty()) {
            query.select(this.trimmedProperties);
        }
        if (this.filterMany != null) {
            SpiExpressionList<?> trimPath = this.filterMany.trimPath(this.path.length() + 1);
            List<SpiExpression> underlyingList = trimPath.getUnderlyingList();
            for (SpiExpression spiExpression : underlyingList) {
                query.where().add(spiExpression);
            }
        }
        if (this.secondaryChildren != null) {
            int trimPath = this.path.length() + 1;
            for (int i = 0; i < this.secondaryChildren.size(); ++i) {
                OrmQueryProperties p = this.secondaryChildren.get(i);
                String path = p.getPath();
                path = path.substring(trimPath);
                query.fetch(path, p.getProperties(), p.getFetchConfig());
                query.setFilterMany(path, p.getFilterManyTrimPath(trimPath));
            }
        }
        if (this.orderBy != null) {
            query.setOrder(this.orderBy.copyWithTrim(this.path));
        }
    }

    public boolean hasSelectClause() {
        if ("*".equals(this.trimmedProperties)) {
            return true;
        }
        return this.included != null || this.filterMany != null;
    }

    public boolean isEmpty() {
        return this.rawProperties == null || this.rawProperties.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        this.append("", sb);
        return sb.toString();
    }

    public String append(String prefix, StringBuilder sb) {
        sb.append(prefix);
        if (this.path != null) {
            sb.append(this.path).append(" ");
        }
        if (!this.isEmpty()) {
            sb.append("(").append(this.rawProperties).append(") ");
        }
        return sb.toString();
    }

    public boolean isChild(OrmQueryProperties possibleChild) {
        return possibleChild.getPath().startsWith(this.path + ".");
    }

    public void add(OrmQueryProperties child) {
        if (this.secondaryChildren == null) {
            this.secondaryChildren = new ArrayList<OrmQueryProperties>();
        }
        this.secondaryChildren.add(child);
    }

    public String getProperties() {
        return this.rawProperties;
    }

    public boolean allProperties() {
        return this.included == null;
    }

    public boolean isIncludedBeanJoin(String propertyName) {
        return this.includedBeanJoin != null && this.includedBeanJoin.contains(propertyName);
    }

    public void includeBeanJoin(String propertyName) {
        if (this.includedBeanJoin == null) {
            this.includedBeanJoin = new HashSet<String>();
        }
        this.includedBeanJoin.add(propertyName);
    }

    public Set<String> getSelectProperties() {
        if (this.secondaryQueryJoins == null) {
            return this.included;
        }
        LinkedHashSet<String> temp = new LinkedHashSet<String>(2 * (this.secondaryQueryJoins.size() + this.included.size()));
        temp.addAll(this.included);
        temp.addAll(this.secondaryQueryJoins);
        return temp;
    }

    public void addSecondaryQueryJoin(String property) {
        if (this.secondaryQueryJoins == null) {
            this.secondaryQueryJoins = new HashSet<String>(4);
        }
        this.secondaryQueryJoins.add(property);
    }

    public Set<String> getIncluded() {
        return this.included;
    }

    public boolean isIncluded(String propName) {
        if (this.includedBeanJoin != null && this.includedBeanJoin.contains(propName)) {
            return false;
        }
        return this.included == null || this.included.contains(propName);
    }

    public void markForQueryJoin() {
        this.markForQueryJoin = true;
    }

    public boolean isQueryFetch() {
        return this.markForQueryJoin || this.getQueryFetchBatch() > -1;
    }

    public boolean isFetchJoin() {
        return !this.isQueryFetch() && !this.isLazyFetch();
    }

    public boolean isLazyFetch() {
        return this.getLazyFetchBatch() > -1;
    }

    public int getQueryFetchBatch() {
        return this.fetchConfig.getQueryBatchSize();
    }

    public boolean isQueryFetchAll() {
        return this.fetchConfig.isQueryAll();
    }

    public int getLazyFetchBatch() {
        return this.fetchConfig.getLazyBatchSize();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCache() {
        return this.cache;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSameByAutoTune(OrmQueryProperties p2) {
        if (this.included == null) {
            return p2 == null || p2.included == null;
        }
        if (p2 == null) {
            return false;
        }
        return this.included.equals(p2.included);
    }

    public boolean isSameByPlan(OrmQueryProperties p2) {
        if (!Same.sameByValue(this.secondaryQueryJoins, p2.secondaryQueryJoins)) {
            return false;
        }
        if (!Same.sameByValue(this.included, p2.included)) {
            return false;
        }
        if (!Same.sameByNull(this.filterMany, p2.filterMany)) {
            return false;
        }
        if (this.filterMany != null && !this.filterMany.isSameByPlan(p2.filterMany)) {
            return false;
        }
        return this.fetchConfig.equals(p2.fetchConfig);
    }

    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(this.path);
        builder.addOrdered(this.included);
        builder.add(this.secondaryQueryJoins);
        builder.add(this.filterMany != null);
        if (this.filterMany != null) {
            this.filterMany.queryPlanHash(builder);
        }
        builder.add(this.fetchConfig.hashCode());
    }
}

