/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import javax.persistence.PersistenceException;

public class SqlBeanLoad {
    private final DbReadContext ctx;
    private final EntityBean bean;
    private final EntityBeanIntercept ebi;
    private final Class<?> type;
    private final boolean lazyLoading;
    private final boolean refreshLoading;
    private final boolean rawSql;

    public SqlBeanLoad(DbReadContext ctx, Class<?> type, EntityBean bean, SpiQuery.Mode queryMode) {
        this.ctx = ctx;
        this.rawSql = ctx.isRawSql();
        this.type = type;
        this.lazyLoading = queryMode.equals((Object)SpiQuery.Mode.LAZYLOAD_BEAN);
        this.refreshLoading = queryMode.equals((Object)SpiQuery.Mode.REFRESH_BEAN);
        this.bean = bean;
        this.ebi = bean == null ? null : bean._ebean_getIntercept();
    }

    public boolean isLazyLoad() {
        return this.lazyLoading;
    }

    public void loadIgnore(int increment) {
        this.ctx.getDataReader().incrementPos(increment);
    }

    public Object load(BeanProperty prop) {
        if (!this.rawSql && !prop.isLoadProperty(this.ctx.isDraftQuery())) {
            return null;
        }
        if (this.bean == null || this.lazyLoading && this.ebi.isLoadedProperty(prop.getPropertyIndex()) || this.type != null && !prop.isAssignableFrom(this.type)) {
            prop.loadIgnore(this.ctx);
            return null;
        }
        try {
            Object dbVal = prop.read(this.ctx);
            if (!this.refreshLoading) {
                prop.setValue(this.bean, dbVal);
            } else {
                prop.setValueIntercept(this.bean, dbVal);
            }
            return dbVal;
        }
        catch (Exception e) {
            String msg = "Error loading on " + prop.getFullBeanName();
            throw new PersistenceException(msg, (Throwable)e);
        }
    }
}

