/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dmlbind;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.MatchedImportedProperty;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PersistenceException;

public final class BindableIdEmbedded
implements BindableId {
    private final BeanPropertyAssocOne<?> embId;
    private final BeanProperty[] props;
    private final MatchedImportedProperty[] matches;

    public BindableIdEmbedded(BeanPropertyAssocOne<?> embId, BeanDescriptor<?> desc) {
        this.embId = embId;
        this.props = embId.getProperties();
        this.matches = MatchedImportedProperty.build(this.props, desc);
    }

    @Override
    public boolean isDraftOnly() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isConcatenated() {
        return true;
    }

    @Override
    public String getIdentityColumn() {
        return null;
    }

    public String toString() {
        return this.embId + " props:" + Arrays.toString(this.props);
    }

    @Override
    public void addToUpdate(PersistRequestBean<?> request, List<Bindable> list) {
    }

    @Override
    public void dmlBind(BindableRequest request, EntityBean bean) throws SQLException {
        EntityBean idValue = (EntityBean)this.embId.getValue(bean);
        for (int i = 0; i < this.props.length; ++i) {
            Object value = this.props[i].getValue(idValue);
            request.bind(value, this.props[i]);
        }
        request.setIdValue(idValue);
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        for (int i = 0; i < this.props.length; ++i) {
            request.appendColumn(this.props[i].getDbColumn());
        }
    }

    @Override
    public boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        if (this.matches == null) {
            String m = "Matches for the concatenated key columns where not found? I expect that the concatenated key was null, and this bean does not have ManyToOne assoc beans matching the primary key columns?";
            throw new PersistenceException(m);
        }
        EntityBean bean = persist.getEntityBean();
        EntityBean newId = (EntityBean)this.embId.createEmbeddedId();
        for (int i = 0; i < this.matches.length; ++i) {
            this.matches[i].populate(bean, newId);
        }
        this.embId.setValueIntercept(bean, newId);
        return true;
    }
}

