/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.Transaction;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.SpiUpdatePlan;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.UpdateMeta;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.OptimisticLockException;

public class UpdateHandler
extends DmlHandler {
    private final UpdateMeta meta;
    private boolean emptySetClause;

    public UpdateHandler(PersistRequestBean<?> persist, UpdateMeta meta) {
        super(persist, meta.isEmptyStringAsNull());
        this.meta = meta;
    }

    @Override
    public void bind() throws SQLException {
        SpiUpdatePlan updatePlan = this.meta.getUpdatePlan(this.persistRequest);
        if (updatePlan.isEmptySetClause()) {
            this.emptySetClause = true;
            return;
        }
        this.sql = updatePlan.getSql();
        Transaction t = this.persistRequest.getTransaction();
        PreparedStatement pstmt = this.persistRequest.isBatched() ? this.getPstmt((SpiTransaction)t, this.sql, this.persistRequest, false) : this.getPstmt((SpiTransaction)t, this.sql, false);
        this.dataBind = this.bind(pstmt);
        this.meta.bind(this.persistRequest, this, updatePlan);
        this.setUpdateGenValues();
        this.logSql(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        if (!this.emptySetClause) {
            super.addBatch();
        }
    }

    @Override
    public int execute() throws SQLException, OptimisticLockException {
        if (!this.emptySetClause) {
            int rowCount = this.dataBind.executeUpdate();
            this.checkRowCount(rowCount);
            return rowCount;
        }
        return 0;
    }

    @Override
    public void registerDerivedRelationship(DerivedRelationshipData derivedRelationship) {
        this.persistRequest.getTransaction().registerDerivedRelationship(derivedRelationship);
    }
}

