/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.SpiCallableSql;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequestCallableSql;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.PstmtFactory;
import com.avaje.ebeaninternal.server.util.BindParamsParser;
import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExeCallableSql {
    private static final Logger logger = LoggerFactory.getLogger(ExeCallableSql.class);
    private final Binder binder;
    private final PstmtFactory pstmtFactory;

    public ExeCallableSql(Binder binder) {
        this.binder = binder;
        this.pstmtFactory = new PstmtFactory();
    }

    public int execute(PersistRequestCallableSql request) {
        boolean batchThisRequest = request.isBatchThisRequest();
        CallableStatement cstmt = null;
        try {
            cstmt = this.bindStmt(request, batchThisRequest);
            if (batchThisRequest) {
                cstmt.addBatch();
                int n = -1;
                return n;
            }
            int rowCount = request.executeUpdate();
            request.postExecute();
            int n = rowCount;
            return n;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (!batchThisRequest && cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }

    private CallableStatement bindStmt(PersistRequestCallableSql request, boolean batchThisRequest) throws SQLException {
        CallableStatement cstmt;
        SpiCallableSql callableSql = request.getCallableSql();
        SpiTransaction t = request.getTransaction();
        String sql = callableSql.getSql();
        BindParams bindParams = callableSql.getBindParams();
        sql = BindParamsParser.parse(bindParams, sql);
        boolean logSql = request.isLogSql();
        if (batchThisRequest) {
            cstmt = this.pstmtFactory.getCstmt(t, logSql, sql, request);
        } else {
            if (logSql) {
                t.logSql(sql);
            }
            cstmt = this.pstmtFactory.getCstmt(t, sql);
        }
        if (callableSql.getTimeout() > 0) {
            cstmt.setQueryTimeout(callableSql.getTimeout());
        }
        String bindLog = null;
        if (!bindParams.isEmpty()) {
            bindLog = this.binder.bind(bindParams, cstmt, t.getInternalConnection());
        }
        request.setBindLog(bindLog);
        request.setBound(bindParams, cstmt);
        return cstmt;
    }
}

