/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.core.PersistRequestCallableSql;
import com.avaje.ebeaninternal.server.core.PersistRequestOrmUpdate;
import com.avaje.ebeaninternal.server.core.PersistRequestUpdateSql;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.persist.BeanPersister;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.ExeCallableSql;
import com.avaje.ebeaninternal.server.persist.ExeOrmUpdate;
import com.avaje.ebeaninternal.server.persist.ExeUpdateSql;
import com.avaje.ebeaninternal.server.persist.PersistExecute;

public final class DefaultPersistExecute
implements PersistExecute {
    private final ExeCallableSql exeCallableSql;
    private final ExeUpdateSql exeUpdateSql;
    private final ExeOrmUpdate exeOrmUpdate;
    private final int defaultBatchSize;

    public DefaultPersistExecute(Binder binder, int defaultBatchSize) {
        this.exeOrmUpdate = new ExeOrmUpdate(binder);
        this.exeUpdateSql = new ExeUpdateSql(binder);
        this.exeCallableSql = new ExeCallableSql(binder);
        this.defaultBatchSize = defaultBatchSize;
    }

    @Override
    public BatchControl createBatchControl(SpiTransaction t) {
        return new BatchControl(t, this.defaultBatchSize, true);
    }

    @Override
    public <T> void executeInsertBean(PersistRequestBean<T> request) {
        BeanManager<T> mgr = request.getBeanManager();
        BeanPersister persister = mgr.getBeanPersister();
        BeanPersistController controller = request.getBeanController();
        if (controller == null || controller.preInsert(request)) {
            persister.insert(request);
        }
    }

    @Override
    public <T> void executeUpdateBean(PersistRequestBean<T> request) {
        BeanManager<T> mgr = request.getBeanManager();
        BeanPersister persister = mgr.getBeanPersister();
        BeanPersistController controller = request.getBeanController();
        if (controller == null || controller.preUpdate(request)) {
            request.postControllerPrepareUpdate();
            persister.update(request);
        }
    }

    @Override
    public <T> int executeDeleteBean(PersistRequestBean<T> request) {
        BeanManager<T> mgr = request.getBeanManager();
        BeanPersister persister = mgr.getBeanPersister();
        BeanPersistController controller = request.getBeanController();
        if (controller == null || controller.preDelete(request)) {
            return persister.delete(request);
        }
        return 0;
    }

    @Override
    public int executeOrmUpdate(PersistRequestOrmUpdate request) {
        return this.exeOrmUpdate.execute(request);
    }

    @Override
    public int executeSqlUpdate(PersistRequestUpdateSql request) {
        return this.exeUpdateSql.execute(request);
    }

    @Override
    public int executeSqlCallable(PersistRequestCallableSql request) {
        return this.exeCallableSql.execute(request);
    }
}

