/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.grammer;

import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.LikeType;
import com.avaje.ebean.OrderBy;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.grammer.EqlAdapterHelper;
import com.avaje.ebeaninternal.server.grammer.EqlOperator;
import com.avaje.ebeaninternal.server.grammer.OperatorMapping;
import com.avaje.ebeaninternal.server.grammer.ParseFetchConfig;
import com.avaje.ebeaninternal.server.grammer.antlr.EQLBaseListener;
import com.avaje.ebeaninternal.server.grammer.antlr.EQLParser;
import com.avaje.ebeaninternal.server.util.ArrayStack;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class EqlAdapter<T>
extends EQLBaseListener {
    private static final OperatorMapping operatorMapping = new OperatorMapping();
    private static final String DISTINCT = "distinct";
    private static final String NULLS = "nulls";
    private static final String ASC = "asc";
    private final SpiQuery<T> query;
    private final EqlAdapterHelper helper;
    private ArrayStack<ExpressionList<T>> textStack;
    private ArrayStack<ExpressionList<T>> whereStack;
    private boolean textMode;
    private List<Object> inValues;
    private String inPropertyName;

    public EqlAdapter(SpiQuery<T> query) {
        this.query = query;
        this.helper = new EqlAdapterHelper(this);
    }

    protected ExpressionList<T> peekExprList() {
        if (this.textMode) {
            return this._peekText();
        }
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
            this.whereStack.push(this.query.where());
        }
        return this.whereStack.peek();
    }

    private ExpressionList<T> _peekText() {
        if (this.textStack == null) {
            this.textStack = new ArrayStack();
            this.textStack.push(this.query.text());
        }
        return this.textStack.peek();
    }

    private void pushExprList(ExpressionList<T> list) {
        if (this.textMode) {
            this.textStack.push(list);
        } else {
            this.whereStack.push(list);
        }
    }

    private void popJunction() {
        if (this.textMode) {
            this.textStack.pop();
        } else {
            this.whereStack.pop();
        }
    }

    @Override
    public void enterSelect_clause(EQLParser.Select_clauseContext ctx) {
        this.checkChildren(ctx, 4);
        if (DISTINCT.equals(this.child(ctx, 1))) {
            this.query.setDistinct(true);
            this.query.select(this.child(ctx, 3));
        } else {
            this.query.select(this.child(ctx, 2));
        }
    }

    @Override
    public void enterFetch_path(EQLParser.Fetch_pathContext ctx) {
        int childCount = ctx.getChildCount();
        this.checkChildren(ctx, 2);
        String path = this.child(ctx, 1);
        int noPropertiesLength = 2;
        FetchConfig fetchConfig = ParseFetchConfig.parse(path);
        if (fetchConfig != null) {
            noPropertiesLength = 3;
            path = this.child(ctx, 2);
        }
        if (childCount == noPropertiesLength) {
            this.query.fetch(path, fetchConfig);
        } else {
            String fetchProperties = this.trimParenthesis(ctx.getChild(noPropertiesLength).getText());
            this.query.fetch(path, fetchProperties, fetchConfig);
        }
    }

    @Override
    public void enterOrderby_property(EQLParser.Orderby_propertyContext ctx) {
        int childCount = ctx.getChildCount();
        String path = this.child(ctx, 0);
        boolean asc = true;
        String nulls = null;
        String nullsFirstLast = null;
        if (childCount == 3) {
            asc = this.child(ctx, 1).startsWith(ASC);
            nullsFirstLast = ctx.getChild(2).getChild(1).getText();
            nulls = NULLS;
        } else if (childCount == 2) {
            String firstChild = this.child(ctx, 1);
            if (firstChild.startsWith(NULLS)) {
                nullsFirstLast = ctx.getChild(1).getChild(1).getText();
                nulls = NULLS;
            } else {
                asc = firstChild.startsWith(ASC);
            }
        }
        this.query.orderBy().add(new OrderBy.Property(path, asc, nulls, nullsFirstLast));
    }

    @Override
    public void enterLimit_clause(EQLParser.Limit_clauseContext ctx) {
        try {
            String limitValue = this.child(ctx, 1);
            this.query.setMaxRows(Integer.parseInt(limitValue));
            int childCount = ctx.getChildCount();
            if (childCount == 3) {
                ParseTree offsetTree = ctx.getChild(2);
                String offsetValue = offsetTree.getChild(1).getText();
                this.query.setFirstRow(Integer.parseInt(offsetValue));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error parsing limit or offset parameter - not an integer", e);
        }
    }

    private String trimParenthesis(String text) {
        text = text.substring(1);
        text = text.substring(0, text.length() - 1);
        return text;
    }

    private String getLeftHandSidePath(ParserRuleContext ctx) {
        TerminalNode pathToken = ctx.getToken(59, 0);
        return pathToken.getText();
    }

    @Override
    public void enterBetween_expression(EQLParser.Between_expressionContext ctx) {
        this.checkChildren(ctx, 5);
        String path = this.getLeftHandSidePath(ctx);
        EqlOperator op = this.getOperator(ctx);
        if (op != EqlOperator.BETWEEN) {
            throw new IllegalStateException("Expecting BETWEEN operator but got " + (Object)((Object)op));
        }
        this.helper.addBetween(path, this.child(ctx, 2), this.child(ctx, 4));
    }

    @Override
    public void enterPropertyBetween_expression(EQLParser.PropertyBetween_expressionContext ctx) {
        this.checkChildren(ctx, 5);
        String rawValue = this.child(ctx, 0);
        EqlOperator op = this.getOperator(ctx);
        if (op != EqlOperator.BETWEEN) {
            throw new IllegalStateException("Expecting BETWEEN operator but got " + (Object)((Object)op));
        }
        this.helper.addBetweenProperty(rawValue, this.child(ctx, 2), this.child(ctx, 4));
    }

    @Override
    public void enterIn_expression(EQLParser.In_expressionContext ctx) {
        this.inValues = new ArrayList<Object>();
        this.inPropertyName = this.getLeftHandSidePath(ctx);
    }

    @Override
    public void enterIn_value(EQLParser.In_valueContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String text = this.child(ctx, i);
            if (!this.isValue(text)) continue;
            this.inValues.add(this.helper.bind(text));
        }
    }

    private String child(ParserRuleContext ctx, int position) {
        ParseTree child = ctx.getChild(position);
        return child.getText();
    }

    private boolean isValue(String text) {
        return text.length() != 1 || !text.equals("(") && !text.equals(")") && !text.equals(",");
    }

    @Override
    public void exitIn_expression(EQLParser.In_expressionContext ctx) {
        this.helper.addIn(this.inPropertyName, this.inValues);
    }

    @Override
    public void enterIsNull_expression(EQLParser.IsNull_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNull(path);
    }

    @Override
    public void enterIsNotNull_expression(EQLParser.IsNotNull_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNotNull(path);
    }

    @Override
    public void enterIsEmpty_expression(EQLParser.IsEmpty_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isEmpty(path);
    }

    @Override
    public void enterIsNotEmpty_expression(EQLParser.IsNotEmpty_expressionContext ctx) {
        String path = this.getLeftHandSidePath(ctx);
        this.peekExprList().isNotEmpty(path);
    }

    @Override
    public void enterLike_expression(EQLParser.Like_expressionContext ctx) {
        this.addExpression(ctx);
    }

    @Override
    public void enterComparison_expression(EQLParser.Comparison_expressionContext ctx) {
        this.addExpression(ctx);
    }

    private void addExpression(ParserRuleContext ctx) {
        int childCount = ctx.getChildCount();
        if (childCount < 3) {
            throw new IllegalStateException("expecting 3 children for comparison? " + ctx);
        }
        String path = this.getLeftHandSidePath(ctx);
        String operator = this.child(ctx, 1);
        EqlOperator op = operatorMapping.get(operator);
        if (op == null) {
            throw new IllegalStateException("No operator found for " + operator);
        }
        this.helper.addExpression(path, op, this.child(ctx, 2));
    }

    @Override
    public void enterConditional_term(EQLParser.Conditional_termContext ctx) {
        int childCount = ctx.getChildCount();
        if (childCount > 1) {
            this.pushExprList(this.peekExprList().and());
        }
    }

    @Override
    public void exitConditional_term(EQLParser.Conditional_termContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    @Override
    public void enterConditional_expression(EQLParser.Conditional_expressionContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.pushExprList(this.peekExprList().or());
        }
    }

    @Override
    public void exitConditional_expression(EQLParser.Conditional_expressionContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    @Override
    public void enterConditional_factor(EQLParser.Conditional_factorContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.pushExprList(this.peekExprList().not());
        }
    }

    @Override
    public void exitConditional_factor(EQLParser.Conditional_factorContext ctx) {
        if (ctx.getChildCount() > 1) {
            this.popJunction();
        }
    }

    private EqlOperator getOperator(ParserRuleContext ctx) {
        String operator = this.child(ctx, 1);
        EqlOperator op = operatorMapping.get(operator);
        if (op == null) {
            throw new IllegalStateException("No operator found for " + operator);
        }
        return op;
    }

    private void checkChildren(ParserRuleContext ctx, int min) {
        if (ctx.getChildCount() < min) {
            throw new IllegalStateException("expecting " + min + " children for comparison? " + ctx);
        }
    }

    public Object namedParam(String parameterName) {
        return this.query.createNamedParameter(parameterName);
    }

    public Expression like(boolean caseInsensitive, LikeType likeType, String property, Object bindValue) {
        return this.query.getExpressionFactory().like(property, bindValue, caseInsensitive, likeType);
    }

    public Expression ieq(String property, Object bindValue) {
        return this.query.getExpressionFactory().ieqObject(property, bindValue);
    }
}

