/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.plugin.ExpressionPath;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractValueExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.Op;
import java.io.IOException;

public class SimpleExpression
extends AbstractValueExpression {
    private final Op type;

    public SimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName, value);
        this.type = type;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        if (this.type == Op.EQ && idName.equals(this.propName)) {
            return this.value();
        }
        return null;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (this.type == Op.BETWEEN) {
            throw new IllegalStateException("BETWEEN Not expected in SimpleExpression?");
        }
        ExpressionPath prop = context.getExpressionPath(this.propName);
        if (prop != null && prop.isAssocId()) {
            String idName = prop.getAssocIdExpression(this.propName, "");
            Object[] ids = prop.getAssocIdValues((EntityBean)this.value());
            if (ids == null || ids.length != 1) {
                throw new IllegalArgumentException("Expecting 1 Id value for " + idName + " but got " + ids);
            }
            context.writeSimple(this.type, idName, ids[0]);
        } else {
            context.writeSimple(this.type, this.propName, this.value());
        }
    }

    public final String getPropName() {
        return this.propName;
    }

    public boolean isOpEquals() {
        return Op.EQ.equals((Object)this.type);
    }

    public Object getValue() {
        return this.value();
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.getAssocIdValues((EntityBean)this.value());
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        request.addBindValue(ids[i]);
                    }
                }
                return;
            }
            if (prop.isDbEncrypted()) {
                String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
                request.addBindEncryptKey(encryptKey);
            }
        }
        request.addBindValue(this.value());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.append(prop.getAssocIdExpression(this.propName, this.type.bind()));
                return;
            }
            if (prop.isDbEncrypted()) {
                String dsql = prop.getBeanProperty().getDecryptSql();
                request.append(dsql).append(this.type.bind());
                return;
            }
        }
        request.append(this.propName).append(this.type.bind());
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(SimpleExpression.class).add(this.propName).add(this.type.name());
        builder.bind(1);
    }

    @Override
    public int queryBindHash() {
        return this.value().hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof SimpleExpression)) {
            return false;
        }
        SimpleExpression that = (SimpleExpression)other;
        return this.propName.equals(that.propName) && this.type == that.type;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        SimpleExpression that = (SimpleExpression)other;
        return this.value().equals(that.value());
    }
}

