/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NonPrepareExpression;
import com.avaje.ebeaninternal.server.expression.Same;
import java.io.IOException;

class RawExpression
extends NonPrepareExpression {
    private final String sql;
    private final Object[] values;

    RawExpression(String sql, Object[] values) {
        this.sql = sql;
        this.values = values;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeRaw(this.sql, this.values);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                request.addBindValue(this.values[i]);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(this.sql);
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(RawExpression.class).add(this.sql);
    }

    @Override
    public int queryBindHash() {
        return this.sql.hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof RawExpression)) {
            return false;
        }
        RawExpression that = (RawExpression)other;
        return this.sql.equals(that.sql);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        if (!(other instanceof RawExpression)) {
            return false;
        }
        RawExpression that = (RawExpression)other;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (Same.sameByValue(this.values[i], that.values[i])) continue;
            return false;
        }
        return true;
    }
}

