/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.io.IOException;

class IsEmptyExpression
extends AbstractExpression {
    private final boolean empty;
    private final String propertyPath;
    private String nestedPath;

    IsEmptyExpression(String propertyName, boolean empty) {
        super(propertyName);
        this.empty = empty;
        this.propertyPath = SplitName.split(propertyName)[0];
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        if (this.empty) {
            this.nestedPath = this.propertyNestedPath(this.propName, desc);
            return null;
        }
        return super.nestedPath(desc);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (this.nestedPath == null) {
            context.writeExists(!this.empty, this.propName);
        } else {
            context.startNot();
            context.startNested(this.nestedPath);
            context.writeExists(this.empty, this.propName);
            context.endNested();
            context.endNot();
        }
    }

    public final String getPropName() {
        return this.propName;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.propertyContainsMany(this.propertyPath, desc, manyWhereJoin);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop == null) {
            throw new IllegalStateException("Property [" + this.propName + "] not found");
        }
        IsEmptyExpression.isEmptySql(request, prop, this.empty, this.propertyPath);
    }

    static void isEmptySql(SpiExpressionRequest request, ElPropertyValue prop, boolean empty, String propertyPath) {
        if (empty) {
            request.append("not ");
        }
        request.append("exists (select 1 from ").append(prop.getAssocIsEmpty(request, propertyPath)).append(")");
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(IsEmptyExpression.class).add(this.propName);
    }

    @Override
    public int queryBindHash() {
        return 1;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof IsEmptyExpression)) {
            return false;
        }
        IsEmptyExpression that = (IsEmptyExpression)other;
        return this.propName.equals(that.propName) && this.empty == that.empty;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return other instanceof IsEmptyExpression;
    }
}

