/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionRequest;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NonPrepareExpression;
import java.io.IOException;

class IdExpression
extends NonPrepareExpression
implements SpiExpression {
    private final Object value;

    IdExpression(Object value) {
        this.value = value;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeId(this.value);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        Object[] bindIdValues = r.getBeanDescriptor().getBindIdValues(this.value);
        for (int i = 0; i < bindIdValues.length; ++i) {
            request.addBindValue(bindIdValues[i]);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        String idSql = r.getBeanDescriptor().getIdBinderIdSql();
        request.append(idSql).append(" ");
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(IdExpression.class);
        builder.bind(1);
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        return other instanceof IdExpression;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        IdExpression that = (IdExpression)other;
        return this.value.equals(that.value);
    }
}

