/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NamedParamHelp;
import com.avaje.ebeaninternal.server.expression.NonPrepareExpression;
import com.avaje.ebeaninternal.server.expression.Op;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.io.IOException;

class BetweenPropertyExpression
extends NonPrepareExpression {
    private static final String BETWEEN = " between ";
    private final String lowProperty;
    private final String highProperty;
    private final Object value;

    BetweenPropertyExpression(String lowProperty, String highProperty, Object value) {
        this.lowProperty = lowProperty;
        this.highProperty = highProperty;
        this.value = value;
    }

    protected String name(String propName) {
        return propName;
    }

    private Object val() {
        return NamedParamHelp.value(this.value);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.startBoolMust();
        context.writeSimple(Op.LT_EQ, this.lowProperty, this.val());
        context.writeSimple(Op.GT_EQ, this.highProperty, this.val());
        context.endBool();
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(this.lowProperty));
        if (elProp != null && elProp.containsMany()) {
            return SplitName.begin(this.lowProperty);
        }
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(this.lowProperty));
        if (elProp != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
        if ((elProp = desc.getElPropertyDeploy(this.name(this.highProperty))) != null && elProp.containsMany()) {
            manyWhereJoin.add(elProp);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        validation.validate(this.lowProperty);
        validation.validate(this.highProperty);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        request.addBindValue(this.val());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(" ? ").append(BETWEEN).append(this.name(this.lowProperty)).append(" and ").append(this.name(this.highProperty));
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(BetweenPropertyExpression.class).add(this.lowProperty).add(this.highProperty);
        builder.bind(1);
    }

    @Override
    public int queryBindHash() {
        return this.val().hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof BetweenPropertyExpression)) {
            return false;
        }
        BetweenPropertyExpression that = (BetweenPropertyExpression)other;
        return this.lowProperty.equals(that.lowProperty) && this.highProperty.equals(that.highProperty);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        BetweenPropertyExpression that = (BetweenPropertyExpression)other;
        return this.val().equals(that.val());
    }
}

