/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

public class ArrayContainsExpression
extends AbstractExpression {
    private final boolean contains;
    private final Object[] values;

    protected ArrayContainsExpression(String propName, boolean contains, Object ... values) {
        super(propName);
        this.contains = contains;
        this.values = values;
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty");
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (this.values.length == 1) {
            context.writeEqualTo(this.propName, this.values[0]);
        } else {
            if (this.contains) {
                context.startBoolMust();
            } else {
                context.startBoolMustNot();
            }
            for (int i = 0; i < this.values.length; ++i) {
                context.writeEqualTo(this.propName, this.values[i]);
            }
            context.endBool();
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(ArrayContainsExpression.class).add(this.propName).add(this.contains);
        builder.bind(this.values.length);
    }

    @Override
    public int queryBindHash() {
        int hc = this.values[0].hashCode();
        for (int i = 1; i < this.values.length; ++i) {
            hc = hc * 31 + this.values[i].hashCode();
        }
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof ArrayContainsExpression)) {
            return false;
        }
        ArrayContainsExpression that = (ArrayContainsExpression)other;
        return this.propName.equals(that.propName) && this.contains == that.contains && this.values.length == that.values.length;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        ArrayContainsExpression that = (ArrayContainsExpression)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.getDbPlatformHandler().arrayContains(request, this.propName, this.contains, this.values);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (Object value : this.values) {
            request.addBindValue(value);
        }
    }
}

