/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NonPrepareExpression;
import com.avaje.ebeaninternal.server.expression.Same;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

class AllEqualsExpression
extends NonPrepareExpression {
    private final Map<String, Object> propMap;

    AllEqualsExpression(Map<String, Object> propMap) {
        this.propMap = propMap;
    }

    protected String name(String propName) {
        return propName;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeAllEquals(this.propMap);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        if (this.propMap != null) {
            for (String propertyName : this.propMap.keySet()) {
                ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(propertyName));
                if (elProp == null || !elProp.containsMany()) continue;
                manyWhereJoin.add(elProp);
            }
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (String propName : this.propMap.keySet()) {
            validation.validate(propName);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        for (Object value : this.propMap.values()) {
            if (value == null) continue;
            request.addBindValue(value);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        request.append("(");
        int count = 0;
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            if (count > 0) {
                request.append("and ");
            }
            request.append(this.name(propName));
            if (value == null) {
                request.append(" is null ");
            } else {
                request.append(" = ? ");
            }
            ++count;
        }
        request.append(")");
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(AllEqualsExpression.class);
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            builder.add(propName).add(value == null ? 0 : 1);
            builder.bindIfNotNull(value);
        }
    }

    @Override
    public int queryBindHash() {
        int hc = 31;
        for (Object value : this.propMap.values()) {
            hc = hc * 31 + (value == null ? 0 : value.hashCode());
        }
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof AllEqualsExpression)) {
            return false;
        }
        AllEqualsExpression that = (AllEqualsExpression)other;
        return this.isSameByValue(that, false);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        if (!(other instanceof AllEqualsExpression)) {
            return false;
        }
        AllEqualsExpression that = (AllEqualsExpression)other;
        return this.isSameByValue(that, true);
    }

    private boolean isSameByValue(AllEqualsExpression that, boolean byValue) {
        if (this.propMap.size() != that.propMap.size()) {
            return false;
        }
        Iterator<Map.Entry<String, Object>> thisIt = this.propMap.entrySet().iterator();
        Iterator<Map.Entry<String, Object>> thatIt = that.propMap.entrySet().iterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            Map.Entry<String, Object> thisNext = thisIt.next();
            Map.Entry<String, Object> thatNext = thatIt.next();
            if (!thisNext.getKey().equals(thatNext.getKey())) {
                return false;
            }
            if (Same.sameBy(byValue, thisNext.getValue(), thatNext.getValue())) continue;
            return false;
        }
        return true;
    }
}

