/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebeaninternal.server.deploy.BeanCascadeInfo;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationBase;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import java.util.HashMap;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;

public abstract class AnnotationParser
extends AnnotationBase {
    protected final DeployBeanInfo<?> info;
    protected final DeployBeanDescriptor<?> descriptor;
    protected final Class<?> beanType;
    protected final boolean validationAnnotations;

    public AnnotationParser(DeployBeanInfo<?> info, boolean validationAnnotations) {
        super(info.getUtil());
        this.validationAnnotations = validationAnnotations;
        this.info = info;
        this.beanType = info.getDescriptor().getBeanType();
        this.descriptor = info.getDescriptor();
    }

    @Override
    public abstract void parse();

    protected void setCascadeTypes(CascadeType[] cascadeTypes, BeanCascadeInfo cascadeInfo) {
        if (cascadeTypes != null && cascadeTypes.length > 0) {
            cascadeInfo.setTypes(cascadeTypes);
        }
    }

    protected void readEmbeddedAttributeOverrides(DeployBeanPropertyAssocOne<?> prop) {
        AttributeOverrides attrOverrides = this.get(prop, AttributeOverrides.class);
        if (attrOverrides != null) {
            HashMap<String, String> propMap = new HashMap<String, String>();
            AttributeOverride[] aoArray = attrOverrides.value();
            for (int i = 0; i < aoArray.length; ++i) {
                String propName = aoArray[i].name();
                String columnName = aoArray[i].column().name();
                propMap.put(propName, columnName);
            }
            prop.getDeployEmbedded().putAll(propMap);
        }
    }

    protected void readColumn(Column columnAnn, DeployBeanProperty prop) {
        if (!this.isEmpty(columnAnn.name())) {
            String dbColumn = this.databasePlatform.convertQuotedIdentifiers(columnAnn.name());
            prop.setDbColumn(dbColumn);
        }
        prop.setDbInsertable(columnAnn.insertable());
        prop.setDbUpdateable(columnAnn.updatable());
        prop.setNullable(columnAnn.nullable());
        prop.setUnique(columnAnn.unique());
        if (columnAnn.precision() > 0) {
            prop.setDbLength(columnAnn.precision());
        } else if (columnAnn.length() != 255) {
            prop.setDbLength(columnAnn.length());
        }
        prop.setDbScale(columnAnn.scale());
        prop.setDbColumnDefn(columnAnn.columnDefinition());
        String baseTable = this.descriptor.getBaseTable();
        String tableName = columnAnn.table();
        if (!"".equals(tableName) && !tableName.equalsIgnoreCase(baseTable)) {
            prop.setSecondaryTable(tableName);
        }
    }
}

