/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.parse;

import com.avaje.ebean.annotation.Cache;
import com.avaje.ebean.annotation.DbComment;
import com.avaje.ebean.annotation.DocStore;
import com.avaje.ebean.annotation.Draftable;
import com.avaje.ebean.annotation.DraftableElement;
import com.avaje.ebean.annotation.History;
import com.avaje.ebean.annotation.Index;
import com.avaje.ebean.annotation.ReadAudit;
import com.avaje.ebean.annotation.UpdateMode;
import com.avaje.ebean.annotation.View;
import com.avaje.ebean.config.TableName;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.IndexDefinition;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.parse.AnnotationParser;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationClass
extends AnnotationParser {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationClass.class);
    private final String asOfViewSuffix;
    private final String versionsBetweenSuffix;
    private final boolean disableL2Cache;

    public AnnotationClass(DeployBeanInfo<?> info, boolean validationAnnotations, String asOfViewSuffix, String versionsBetweenSuffix, boolean disableL2Cache) {
        super(info, validationAnnotations);
        this.asOfViewSuffix = asOfViewSuffix;
        this.versionsBetweenSuffix = versionsBetweenSuffix;
        this.disableL2Cache = disableL2Cache;
    }

    public AnnotationClass(DeployBeanInfo<?> info) {
        super(info, false);
        this.asOfViewSuffix = null;
        this.versionsBetweenSuffix = null;
        this.disableL2Cache = false;
    }

    public void parseAttributeOverride() {
        Class cls = this.descriptor.getBeanType();
        AttributeOverride override = cls.getAnnotation(AttributeOverride.class);
        if (override != null) {
            String propertyName = override.name();
            Column column = override.column();
            DeployBeanProperty beanProperty = this.descriptor.getBeanProperty(propertyName);
            if (beanProperty == null) {
                logger.error("AttributeOverride property [" + propertyName + "] not found on " + this.descriptor.getFullName());
            } else {
                this.readColumn(column, beanProperty);
            }
        }
    }

    @Override
    public void parse() {
        this.read(this.descriptor.getBeanType());
        this.setTableName();
    }

    private void setTableName() {
        if (this.descriptor.isBaseTableType()) {
            TableName tableName = this.namingConvention.getTableName(this.descriptor.getBeanType());
            this.descriptor.setBaseTable(tableName, this.asOfViewSuffix, this.versionsBetweenSuffix);
        }
    }

    private void read(Class<?> cls) {
        NamedQuery namedQuery;
        NamedQueries namedQueries;
        Cache cache;
        UpdateMode updateMode;
        DocStore docStore;
        DbComment comment;
        History history;
        ReadAudit readAudit;
        DraftableElement draftableElement;
        Draftable draftable;
        Table table;
        View view;
        UniqueConstraint uc;
        Index index;
        Embeddable embeddable;
        Entity entity = cls.getAnnotation(Entity.class);
        if (entity != null) {
            if (entity.name().equals("")) {
                this.descriptor.setName(cls.getSimpleName());
            } else {
                this.descriptor.setName(entity.name());
            }
        }
        if ((embeddable = cls.getAnnotation(Embeddable.class)) != null) {
            this.descriptor.setEntityType(BeanDescriptor.EntityType.EMBEDDED);
            this.descriptor.setName("Embeddable:" + cls.getSimpleName());
        }
        if ((index = cls.getAnnotation(Index.class)) != null) {
            this.descriptor.addIndex(new IndexDefinition(index.columnNames(), index.name(), index.unique()));
        }
        if ((uc = cls.getAnnotation(UniqueConstraint.class)) != null) {
            this.descriptor.addIndex(new IndexDefinition(uc.columnNames()));
        }
        if ((view = cls.getAnnotation(View.class)) != null) {
            this.descriptor.setView(view.name(), view.dependentTables());
        }
        if ((table = cls.getAnnotation(Table.class)) != null) {
            UniqueConstraint[] uniqueConstraints;
            for (UniqueConstraint c : uniqueConstraints = table.uniqueConstraints()) {
                this.descriptor.addIndex(new IndexDefinition(c.columnNames()));
            }
        }
        if ((draftable = cls.getAnnotation(Draftable.class)) != null) {
            this.descriptor.setDraftable();
        }
        if ((draftableElement = cls.getAnnotation(DraftableElement.class)) != null) {
            this.descriptor.setDraftableElement();
        }
        if ((readAudit = cls.getAnnotation(ReadAudit.class)) != null) {
            this.descriptor.setReadAuditing();
        }
        if ((history = cls.getAnnotation(History.class)) != null) {
            this.descriptor.setHistorySupport();
        }
        if ((comment = cls.getAnnotation(DbComment.class)) != null) {
            this.descriptor.setDbComment(comment.value());
        }
        if ((docStore = cls.getAnnotation(DocStore.class)) != null) {
            this.descriptor.readDocStore(docStore);
        }
        if ((updateMode = cls.getAnnotation(UpdateMode.class)) != null) {
            this.descriptor.setUpdateChangesOnly(updateMode.updateChangesOnly());
        }
        if ((cache = cls.getAnnotation(Cache.class)) != null && !this.disableL2Cache) {
            this.descriptor.setCache(cache);
        }
        if ((namedQueries = cls.getAnnotation(NamedQueries.class)) != null) {
            for (NamedQuery namedQuery2 : namedQueries.value()) {
                this.descriptor.addNamedQuery(namedQuery2.name(), namedQuery2.query());
            }
        }
        if ((namedQuery = cls.getAnnotation(NamedQuery.class)) != null) {
            this.descriptor.addNamedQuery(namedQuery.name(), namedQuery.query());
        }
    }
}

