/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.meta;

import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanTable;
import javax.persistence.JoinColumn;

public class DeployTableJoinColumn {
    String localDbColumn;
    String foreignDbColumn;
    final boolean insertable;
    final boolean updateable;

    public DeployTableJoinColumn(String localDbColumn, String foreignDbColumn) {
        this(localDbColumn, foreignDbColumn, true, true);
    }

    public DeployTableJoinColumn(String localDbColumn, String foreignDbColumn, boolean insertable, boolean updateable) {
        this.localDbColumn = this.nullEmptyString(localDbColumn);
        this.foreignDbColumn = this.nullEmptyString(foreignDbColumn);
        this.insertable = insertable;
        this.updateable = updateable;
    }

    public DeployTableJoinColumn(boolean order, JoinColumn jc, BeanTable beanTable) {
        this(jc.referencedColumnName(), jc.name(), jc.insertable(), jc.updatable());
        this.setReferencedColumn(beanTable);
        if (!order) {
            this.reverse();
        }
    }

    private void setReferencedColumn(BeanTable beanTable) {
        BeanProperty[] idProperties;
        if (this.localDbColumn == null && (idProperties = beanTable.getIdProperties()).length == 1) {
            this.localDbColumn = idProperties[0].getDbColumn();
        }
    }

    public DeployTableJoinColumn reverse() {
        String temp = this.localDbColumn;
        this.localDbColumn = this.foreignDbColumn;
        this.foreignDbColumn = temp;
        return this;
    }

    private String nullEmptyString(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    public DeployTableJoinColumn copy(boolean reverse) {
        if (reverse) {
            return new DeployTableJoinColumn(this.foreignDbColumn, this.localDbColumn, this.insertable, this.updateable);
        }
        return new DeployTableJoinColumn(this.localDbColumn, this.foreignDbColumn, this.insertable, this.updateable);
    }

    public String toString() {
        return this.localDbColumn + " = " + this.foreignDbColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public String getForeignDbColumn() {
        return this.foreignDbColumn;
    }

    public String getLocalDbColumn() {
        return this.localDbColumn;
    }

    public void setLocalDbColumn(String localDbColumn) {
        this.localDbColumn = localDbColumn;
    }
}

