/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanQueryAdapterManager {
    private static final Logger logger = LoggerFactory.getLogger(BeanQueryAdapterManager.class);
    private final List<BeanQueryAdapter> list;

    public BeanQueryAdapterManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanQueryAdapters();
    }

    public int getRegisterCount() {
        return this.list.size();
    }

    public void addQueryAdapter(DeployBeanDescriptor<?> deployDesc) {
        for (int i = 0; i < this.list.size(); ++i) {
            BeanQueryAdapter c = this.list.get(i);
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            logger.debug("BeanQueryAdapter on[" + deployDesc.getFullName() + "] " + c.getClass().getName());
            deployDesc.addQueryAdapter(c);
        }
    }
}

