/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFinderManager {
    final Logger logger = LoggerFactory.getLogger(BeanFinderManager.class);
    private final List<BeanFindController> list;

    public BeanFinderManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanFindControllers();
    }

    public int getRegisterCount() {
        return this.list.size();
    }

    public void addFindControllers(DeployBeanDescriptor<?> deployDesc) {
        for (int i = 0; i < this.list.size(); ++i) {
            BeanFindController c = this.list.get(i);
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            this.logger.debug("BeanFindController on[" + deployDesc.getFullName() + "] " + c.getClass().getName());
            deployDesc.setBeanFinder(c);
        }
    }
}

