/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.Model;
import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.config.EncryptKey;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbHistorySupport;
import com.avaje.ebean.config.dbplatform.DbIdentity;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import com.avaje.ebean.event.changelog.ChangeLogFilter;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeLogPrepare;
import com.avaje.ebean.event.changelog.ChangeLogRegister;
import com.avaje.ebean.plugin.BeanType;
import com.avaje.ebeaninternal.api.ConcurrencyMode;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorMap;
import com.avaje.ebeaninternal.server.deploy.BeanFinderManager;
import com.avaje.ebeaninternal.server.deploy.BeanLifecycleAdapterFactory;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanManagerFactory;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanQueryAdapterManager;
import com.avaje.ebeaninternal.server.deploy.BeanTable;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.PersistControllerManager;
import com.avaje.ebeaninternal.server.deploy.PersistListenerManager;
import com.avaje.ebeaninternal.server.deploy.PostLoadManager;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.deploy.id.IdBinderEmbedded;
import com.avaje.ebeaninternal.server.deploy.id.IdBinderFactory;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanTable;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoin;
import com.avaje.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import com.avaje.ebeaninternal.server.deploy.parse.DeployCreateProperties;
import com.avaje.ebeaninternal.server.deploy.parse.DeployInherit;
import com.avaje.ebeaninternal.server.deploy.parse.DeployUtil;
import com.avaje.ebeaninternal.server.deploy.parse.ReadAnnotations;
import com.avaje.ebeaninternal.server.deploy.parse.TransientProperties;
import com.avaje.ebeaninternal.server.properties.BeanPropertiesReader;
import com.avaje.ebeaninternal.server.properties.BeanPropertyInfo;
import com.avaje.ebeaninternal.server.properties.BeanPropertyInfoFactory;
import com.avaje.ebeaninternal.server.properties.EnhanceBeanPropertyInfoFactory;
import com.avaje.ebeaninternal.xmlmapping.XmlMappingReader;
import com.avaje.ebeaninternal.xmlmapping.model.XmAliasMapping;
import com.avaje.ebeaninternal.xmlmapping.model.XmColumnMapping;
import com.avaje.ebeaninternal.xmlmapping.model.XmEbean;
import com.avaje.ebeaninternal.xmlmapping.model.XmEntity;
import com.avaje.ebeaninternal.xmlmapping.model.XmNamedQuery;
import com.avaje.ebeaninternal.xmlmapping.model.XmRawSql;
import com.avaje.ebeanservice.docstore.api.DocStoreBeanAdapter;
import com.avaje.ebeanservice.docstore.api.DocStoreFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptorManager
implements BeanDescriptorMap {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptorManager.class);
    private static final BeanDescComparator beanDescComparator = new BeanDescComparator();
    private final ReadAnnotations readAnnotations;
    private final TransientProperties transientProperties;
    private final DeployInherit deplyInherit;
    private final BeanPropertyInfoFactory reflectFactory;
    private final DeployUtil deployUtil;
    private final PersistControllerManager persistControllerManager;
    private final PostLoadManager postLoadManager;
    private final BeanFinderManager beanFinderManager;
    private final PersistListenerManager persistListenerManager;
    private final BeanQueryAdapterManager beanQueryAdapterManager;
    private final NamingConvention namingConvention;
    private final DeployCreateProperties createProperties;
    private final BeanManagerFactory beanManagerFactory;
    private final ServerConfig serverConfig;
    private final ChangeLogListener changeLogListener;
    private final ChangeLogRegister changeLogRegister;
    private final ChangeLogPrepare changeLogPrepare;
    private final DocStoreFactory docStoreFactory;
    private int entityBeanCount;
    private final boolean updateChangesOnly;
    private final BootupClasses bootupClasses;
    private final String serverName;
    private Map<Class<?>, DeployBeanInfo<?>> deployInfoMap = new HashMap();
    private final Map<Class<?>, BeanTable> beanTableMap = new HashMap();
    private final Map<String, BeanDescriptor<?>> descMap = new HashMap();
    private final Map<String, BeanDescriptor<?>> descQueueMap = new HashMap();
    private final Map<String, BeanManager<?>> beanManagerMap = new HashMap();
    private final Map<String, List<BeanDescriptor<?>>> tableToDescMap = new HashMap();
    private final Map<String, List<BeanDescriptor<?>>> tableToViewDescMap = new HashMap();
    private List<BeanDescriptor<?>> immutableDescriptorList;
    private final DbIdentity dbIdentity;
    private final DataSource dataSource;
    private final DatabasePlatform databasePlatform;
    private final ServerCacheManager cacheManager;
    private final BackgroundExecutor backgroundExecutor;
    private final int dbSequenceBatchSize;
    private final EncryptKeyManager encryptKeyManager;
    private final IdBinderFactory idBinderFactory;
    private final BeanLifecycleAdapterFactory beanLifecycleAdapterFactory;
    private final boolean eagerFetchLobs;
    private final String asOfViewSuffix;
    private final Map<String, String> asOfTableMap = new HashMap<String, String>();
    private final Map<String, String> draftTableMap = new HashMap<String, String>();

    public BeanDescriptorManager(InternalConfiguration config) {
        this.serverConfig = config.getServerConfig();
        this.serverName = InternString.intern(this.serverConfig.getName());
        this.cacheManager = config.getCacheManager();
        this.docStoreFactory = config.getDocStoreFactory();
        this.dbSequenceBatchSize = this.serverConfig.getDatabaseSequenceBatchSize();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.dataSource = this.serverConfig.getDataSource();
        this.encryptKeyManager = this.serverConfig.getEncryptKeyManager();
        this.databasePlatform = this.serverConfig.getDatabasePlatform();
        this.idBinderFactory = new IdBinderFactory(this.databasePlatform.isIdInExpandedForm());
        this.eagerFetchLobs = this.serverConfig.isEagerFetchLobs();
        this.asOfViewSuffix = this.getAsOfViewSuffix(this.databasePlatform, this.serverConfig);
        String versionsBetweenSuffix = this.getVersionsBetweenSuffix(this.databasePlatform, this.serverConfig);
        this.readAnnotations = new ReadAnnotations(config.getGeneratedPropertyFactory(), this.asOfViewSuffix, versionsBetweenSuffix, this.serverConfig.isDisableL2Cache());
        this.bootupClasses = config.getBootupClasses();
        this.createProperties = config.getDeployCreateProperties();
        this.namingConvention = this.serverConfig.getNamingConvention();
        this.dbIdentity = config.getDatabasePlatform().getDbIdentity();
        this.deplyInherit = config.getDeployInherit();
        this.deployUtil = config.getDeployUtil();
        this.beanManagerFactory = new BeanManagerFactory(config.getDatabasePlatform());
        this.updateChangesOnly = this.serverConfig.isUpdateChangesOnly();
        this.beanLifecycleAdapterFactory = new BeanLifecycleAdapterFactory();
        this.persistControllerManager = new PersistControllerManager(this.bootupClasses);
        this.postLoadManager = new PostLoadManager(this.bootupClasses);
        this.persistListenerManager = new PersistListenerManager(this.bootupClasses);
        this.beanQueryAdapterManager = new BeanQueryAdapterManager(this.bootupClasses);
        this.beanFinderManager = new BeanFinderManager(this.bootupClasses);
        this.reflectFactory = this.createReflectionFactory();
        this.transientProperties = new TransientProperties();
        this.changeLogPrepare = config.changeLogPrepare(this.bootupClasses.getChangeLogPrepare());
        this.changeLogListener = config.changeLogListener(this.bootupClasses.getChangeLogListener());
        this.changeLogRegister = config.changeLogRegister(this.bootupClasses.getChangeLogRegister());
    }

    private String getAsOfViewSuffix(DatabasePlatform databasePlatform, ServerConfig serverConfig) {
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        return historySupport == null ? serverConfig.getAsOfViewSuffix() : historySupport.getAsOfViewSuffix(serverConfig.getAsOfViewSuffix());
    }

    private String getVersionsBetweenSuffix(DatabasePlatform databasePlatform, ServerConfig serverConfig) {
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        return historySupport == null ? serverConfig.getAsOfViewSuffix() : historySupport.getVersionsBetweenSuffix(serverConfig.getAsOfViewSuffix());
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public <T> DocStoreBeanAdapter<T> createDocStoreBeanAdapter(BeanDescriptor<T> descriptor, DeployBeanDescriptor<T> deploy) {
        return this.docStoreFactory.createAdapter(descriptor, deploy);
    }

    public BeanDescriptor<?> getBeanDescriptorByQueueId(String queueId) {
        return this.descQueueMap.get(queueId);
    }

    @Override
    public <T> BeanDescriptor<T> getBeanDescriptor(Class<T> entityType) {
        return this.descMap.get(entityType.getName());
    }

    public <T> BeanDescriptor<T> getBeanDescriptorByClassName(String entityClassName) {
        return this.descMap.get(entityClassName);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public ServerCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setEbeanServer(SpiEbeanServer internalEbean) {
        for (BeanDescriptor<?> desc : this.immutableDescriptorList) {
            desc.setEbeanServer(internalEbean);
        }
    }

    @Override
    public IdBinder createIdBinder(BeanProperty idProperty) {
        return this.idBinderFactory.createIdBinder(idProperty);
    }

    public Map<String, String> getDraftTableMap() {
        return this.draftTableMap;
    }

    public Map<String, String> deploy() {
        try {
            this.createListeners();
            this.readEntityDeploymentInitial();
            this.readXmlMapping();
            this.readEmbeddedDeployment();
            this.readEntityBeanTable();
            this.readEntityDeploymentAssociations();
            this.readInheritedIdGenerators();
            this.readEntityRelationships();
            ArrayList list = new ArrayList(this.descMap.values());
            Collections.sort(list, beanDescComparator);
            this.immutableDescriptorList = Collections.unmodifiableList(list);
            this.initialiseAll();
            this.readForeignKeys();
            this.readTableToDescriptor();
            this.logStatus();
            this.deployInfoMap.clear();
            this.deployInfoMap = null;
            return this.asOfTableMap;
        }
        catch (RuntimeException e) {
            logger.error("Error in deployment", (Throwable)e);
            throw e;
        }
    }

    private void readXmlMapping() {
        try {
            ClassLoader classLoader = this.serverConfig.getClassLoadConfig().getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("ebean.xml");
            ArrayList<XmEbean> mappings = new ArrayList<XmEbean>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                mappings.add(XmlMappingReader.read(is));
                is.close();
            }
            for (XmEbean mapping : mappings) {
                List<XmEntity> entityDeploy = mapping.getEntity();
                for (XmEntity deploy : entityDeploy) {
                    this.readEntityMapping(classLoader, deploy);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ebean.xml", e);
        }
    }

    private void readEntityMapping(ClassLoader classLoader, XmEntity entityDeploy) {
        Class<?> entityClass;
        String entityClassName = entityDeploy.getClazz();
        try {
            entityClass = Class.forName(entityClassName, false, classLoader);
        }
        catch (Exception e) {
            logger.error("Could not load entity bean class " + entityClassName + " for ebean.xml entry");
            return;
        }
        DeployBeanInfo<?> info = this.deployInfoMap.get(entityClass);
        if (info == null) {
            logger.error("No entity bean for ebean.xml entry " + entityClassName);
        } else {
            for (XmRawSql sql : entityDeploy.getRawSql()) {
                RawSqlBuilder builder = RawSqlBuilder.parse(sql.getQuery().getValue());
                for (XmColumnMapping columnMapping : sql.getColumnMapping()) {
                    builder.columnMapping(columnMapping.getColumn(), columnMapping.getProperty());
                }
                for (XmAliasMapping aliasMapping : sql.getAliasMapping()) {
                    builder.tableAliasMapping(aliasMapping.getAlias(), aliasMapping.getProperty());
                }
                info.addRawSql(sql.getName(), builder.create());
            }
            for (XmNamedQuery namedQuery : entityDeploy.getNamedQuery()) {
                info.addNamedQuery(namedQuery.getName(), namedQuery.getQuery().getValue());
            }
        }
    }

    @Override
    public EncryptKey getEncryptKey(String tableName, String columnName) {
        return this.encryptKeyManager.getEncryptKey(tableName, columnName);
    }

    public void cacheNotify(TransactionEventTable.TableIUD tableIUD) {
        List<BeanDescriptor<?>> viewBeans;
        String tableName = tableIUD.getTableName().toLowerCase();
        List<BeanDescriptor<?>> normalBeanTypes = this.tableToDescMap.get(tableName);
        if (normalBeanTypes != null) {
            for (int i = 0; i < normalBeanTypes.size(); ++i) {
                normalBeanTypes.get(i).cacheHandleBulkUpdate(tableIUD);
            }
        }
        if ((viewBeans = this.tableToViewDescMap.get(tableName)) != null) {
            for (int i = 0; i < viewBeans.size(); ++i) {
                viewBeans.get(i).cacheHandleBulkUpdate(tableIUD);
            }
        }
    }

    public List<BeanDescriptor<?>> getBeanDescriptors(String tableName) {
        return this.tableToDescMap.get(tableName.toLowerCase());
    }

    public List<? extends BeanType<?>> getBeanTypes(String tableName) {
        return this.tableToDescMap.get(tableName.toLowerCase());
    }

    public void processViewInvalidation(Set<String> viewInvalidation) {
        for (String depTable : viewInvalidation) {
            List<BeanDescriptor<?>> list = this.tableToViewDescMap.get(depTable.toLowerCase());
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).queryCacheClear();
            }
        }
    }

    private void readTableToDescriptor() {
        for (BeanDescriptor<?> desc : this.descMap.values()) {
            String[] dependentTables;
            String baseTable = desc.getBaseTable();
            if (baseTable != null) {
                List<BeanDescriptor<?>> list = this.tableToDescMap.get(baseTable = baseTable.toLowerCase());
                if (list == null) {
                    list = new ArrayList(1);
                    this.tableToDescMap.put(baseTable, list);
                }
                list.add(desc);
            }
            if (desc.getEntityType() != BeanDescriptor.EntityType.VIEW || !desc.isQueryCaching() || (dependentTables = desc.getDependentTables()) == null || dependentTables.length <= 0) continue;
            for (String depTable : dependentTables) {
                List<BeanDescriptor<?>> list = this.tableToViewDescMap.get(depTable = depTable.toLowerCase());
                if (list == null) {
                    list = new ArrayList(1);
                    this.tableToViewDescMap.put(depTable, list);
                }
                list.add(desc);
            }
        }
    }

    private void readForeignKeys() {
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseFkeys();
        }
    }

    private void initialiseAll() {
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseId(this.asOfTableMap, this.draftTableMap);
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initInheritInfo();
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseOther(this.asOfTableMap, this.asOfViewSuffix, this.draftTableMap);
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseDocMapping();
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            if (d.isEmbedded()) continue;
            BeanManager<?> m = this.beanManagerFactory.create(d);
            this.beanManagerMap.put(d.getFullName(), m);
            this.checkForValidEmbeddedId(d);
        }
    }

    private void checkForValidEmbeddedId(BeanDescriptor<?> d) {
        IdBinder idBinder = d.getIdBinder();
        if (idBinder != null && idBinder instanceof IdBinderEmbedded) {
            IdBinderEmbedded embId = (IdBinderEmbedded)idBinder;
            BeanDescriptor<?> idBeanDescriptor = embId.getIdBeanDescriptor();
            Class<?> idType = idBeanDescriptor.getBeanType();
            try {
                idType.getDeclaredMethod("hashCode", new Class[0]);
                idType.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException e) {
                this.checkMissingHashCodeOrEquals(e, idType, d.getBeanType());
            }
        }
    }

    private void checkMissingHashCodeOrEquals(Exception source, Class<?> idType, Class<?> beanType) {
        String msg = "SERIOUS ERROR: The hashCode() and equals() methods *MUST* be implemented ";
        msg = msg + "on Embedded bean " + idType + " as it is used as an Id for " + beanType;
        throw new PersistenceException(msg, (Throwable)source);
    }

    public boolean requiresViewEntityCacheInvalidation() {
        return !this.tableToViewDescMap.isEmpty();
    }

    public List<BeanDescriptor<?>> getBeanDescriptorList() {
        return this.immutableDescriptorList;
    }

    public BeanTable getBeanTable(Class<?> type) {
        return this.beanTableMap.get(type);
    }

    public <T> BeanManager<T> getBeanManager(Class<T> entityType) {
        return this.getBeanManager(entityType.getName());
    }

    public BeanManager<?> getBeanManager(String beanClassName) {
        return this.beanManagerMap.get(beanClassName);
    }

    private void createListeners() {
        int qa = this.beanQueryAdapterManager.getRegisterCount();
        int cc = this.persistControllerManager.getRegisterCount();
        int pl = this.postLoadManager.getRegisterCount();
        int lc = this.persistListenerManager.getRegisterCount();
        int fc = this.beanFinderManager.getRegisterCount();
        logger.debug("BeanPersistControllers[" + cc + "] BeanFinders[" + fc + "] BeanPersistListeners[" + lc + "] BeanQueryAdapters[" + qa + "] BeanPostLoaders[" + pl + "]");
    }

    private void logStatus() {
        logger.debug("Entities[{}]", (Object)this.entityBeanCount);
    }

    private <T> BeanDescriptor<T> createEmbedded(Class<T> beanClass) {
        DeployBeanInfo<T> info = this.getDeploy(beanClass);
        return new BeanDescriptor<T>(this, info.getDescriptor());
    }

    public <T> DeployBeanInfo<T> getDeploy(Class<T> cls) {
        return this.deployInfoMap.get(cls);
    }

    private void registerBeanDescriptor(BeanDescriptor<?> desc) {
        this.descMap.put(desc.getBeanType().getName(), desc);
        if (desc.isDocStoreMapped()) {
            this.descQueueMap.put(desc.getDocStoreQueueId(), desc);
        }
    }

    private void readEmbeddedDeployment() {
        List<Class<?>> embeddedClasses = this.bootupClasses.getEmbeddables();
        for (int i = 0; i < embeddedClasses.size(); ++i) {
            this.registerBeanDescriptor(this.createEmbedded(embeddedClasses.get(i)));
        }
    }

    private void readEntityDeploymentInitial() {
        DeployBeanInfo<?> info;
        for (Class<?> entityClass : this.bootupClasses.getEntities()) {
            info = this.createDeployBeanInfo(entityClass);
            this.deployInfoMap.put(entityClass, info);
        }
        for (Class<?> entityClass : this.bootupClasses.getEmbeddables()) {
            info = this.createDeployBeanInfo(entityClass);
            this.readDeployAssociations(info);
            this.deployInfoMap.put(entityClass, info);
        }
    }

    private void readEntityBeanTable() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            BeanTable beanTable = this.createBeanTable(info);
            this.beanTableMap.put(beanTable.getBeanType(), beanTable);
        }
    }

    private void readEntityDeploymentAssociations() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.readDeployAssociations(info);
        }
    }

    private void readInheritedIdGenerators() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            DeployBeanInfo<?> rootBeanInfo;
            PlatformIdGenerator rootIdGen;
            DeployBeanDescriptor<?> descriptor = info.getDescriptor();
            InheritInfo inheritInfo = descriptor.getInheritInfo();
            if (inheritInfo == null || inheritInfo.isRoot() || (rootIdGen = (rootBeanInfo = this.deployInfoMap.get(inheritInfo.getRoot().getType())).getDescriptor().getIdGenerator()) == null) continue;
            descriptor.setIdGenerator(rootIdGen);
        }
    }

    private BeanTable createBeanTable(DeployBeanInfo<?> info) {
        DeployBeanDescriptor<?> deployDescriptor = info.getDescriptor();
        DeployBeanTable beanTable = deployDescriptor.createDeployBeanTable();
        return new BeanTable(beanTable, this);
    }

    private void readEntityRelationships() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.checkMappedBy(info);
        }
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.secondaryPropsJoins(info);
        }
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.setInheritanceInfo(info);
        }
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.registerBeanDescriptor(new BeanDescriptor(this, info.getDescriptor()));
        }
    }

    private void setInheritanceInfo(DeployBeanInfo<?> info) {
        DeployBeanInfo<?> assoc;
        for (DeployBeanPropertyAssocOne<?> deployBeanPropertyAssocOne : info.getDescriptor().propertiesAssocOne()) {
            if (deployBeanPropertyAssocOne.isTransient() || (assoc = this.deployInfoMap.get(deployBeanPropertyAssocOne.getTargetType())) == null) continue;
            deployBeanPropertyAssocOne.getTableJoin().setInheritInfo(assoc.getDescriptor().getInheritInfo());
        }
        for (DeployBeanPropertyAssocMany deployBeanPropertyAssocMany : info.getDescriptor().propertiesAssocMany()) {
            if (deployBeanPropertyAssocMany.isTransient() || (assoc = this.deployInfoMap.get(deployBeanPropertyAssocMany.getTargetType())) == null) continue;
            deployBeanPropertyAssocMany.getTableJoin().setInheritInfo(assoc.getDescriptor().getInheritInfo());
        }
    }

    private void secondaryPropsJoins(DeployBeanInfo<?> info) {
        DeployBeanDescriptor<?> descriptor = info.getDescriptor();
        for (DeployBeanProperty prop : descriptor.propertiesBase()) {
            if (!prop.isSecondaryTable()) continue;
            String tableName = prop.getSecondaryTable();
            DeployBeanPropertyAssocOne<?> assocOne = descriptor.findJoinToTable(tableName);
            if (assocOne == null) {
                String msg = "Error with property " + prop.getFullBeanName() + ". Could not find a Relationship to table " + tableName + ". Perhaps you could use a @JoinColumn instead.";
                throw new RuntimeException(msg);
            }
            DeployTableJoin tableJoin = assocOne.getTableJoin();
            prop.setSecondaryTableJoin(tableJoin, assocOne.getName());
        }
    }

    private void checkMappedBy(DeployBeanInfo<?> info) {
        for (DeployBeanPropertyAssocOne<?> deployBeanPropertyAssocOne : info.getDescriptor().propertiesAssocOne()) {
            if (deployBeanPropertyAssocOne.isTransient() || deployBeanPropertyAssocOne.getMappedBy() == null) continue;
            this.checkMappedByOneToOne(deployBeanPropertyAssocOne);
        }
        for (DeployBeanPropertyAssocMany deployBeanPropertyAssocMany : info.getDescriptor().propertiesAssocMany()) {
            if (deployBeanPropertyAssocMany.isTransient()) continue;
            if (deployBeanPropertyAssocMany.isManyToMany()) {
                this.checkMappedByManyToMany(deployBeanPropertyAssocMany);
                continue;
            }
            this.checkMappedByOneToMany(info, deployBeanPropertyAssocMany);
        }
    }

    private DeployBeanDescriptor<?> getTargetDescriptor(DeployBeanPropertyAssoc<?> prop) {
        Class<?> targetType = prop.getTargetType();
        DeployBeanInfo<?> info = this.deployInfoMap.get(targetType);
        if (info == null) {
            String msg = "Can not find descriptor [" + targetType + "] for " + prop.getFullBeanName();
            throw new PersistenceException(msg);
        }
        return info.getDescriptor();
    }

    private boolean findMappedBy(DeployBeanPropertyAssocMany<?> prop) {
        String targetType;
        String shortTypeName;
        String name;
        int p;
        Class<?> owningType = prop.getOwningType();
        HashSet<String> matchSet = new HashSet<String>();
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        List<DeployBeanPropertyAssocOne<?>> ones = targetDesc.propertiesAssocOne();
        for (DeployBeanPropertyAssocOne<?> possibleMappedBy : ones) {
            Class possibleMappedByType = possibleMappedBy.getTargetType();
            if (!possibleMappedByType.equals(owningType)) continue;
            prop.setMappedBy(possibleMappedBy.getName());
            matchSet.add(possibleMappedBy.getName());
        }
        if (matchSet.isEmpty()) {
            return false;
        }
        if (matchSet.size() == 1) {
            return true;
        }
        if (matchSet.size() == 2 && (p = (name = prop.getName()).indexOf(shortTypeName = (targetType = prop.getTargetType().getName()).substring(targetType.lastIndexOf(".") + 1))) > 1) {
            String searchName = name.substring(0, p).toLowerCase();
            for (String possibleMappedBy : matchSet) {
                String possibleLower = possibleMappedBy.toLowerCase();
                if (!possibleLower.contains(searchName)) continue;
                prop.setMappedBy(possibleMappedBy);
                String m = "Implicitly found mappedBy for " + targetDesc + "." + prop;
                m = m + " by searching for [" + searchName + "] against " + matchSet;
                logger.debug(m);
                return true;
            }
        }
        String msg = "Error on " + prop.getFullBeanName() + " missing mappedBy.";
        msg = msg + " There are [" + matchSet.size() + "] possible properties in " + targetDesc;
        msg = msg + " that this association could be mapped to. Please specify one using ";
        msg = msg + "the mappedBy attribute on @OneToMany.";
        throw new PersistenceException(msg);
    }

    private void makeUnidirectional(DeployBeanInfo<?> info, DeployBeanPropertyAssocMany<?> oneToMany) {
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(oneToMany);
        Class<?> owningType = oneToMany.getOwningType();
        if (!oneToMany.getCascadeInfo().isSave()) {
            Class targetType = oneToMany.getTargetType();
            String msg = "Error on " + oneToMany.getFullBeanName() + ". @OneToMany MUST have ";
            msg = msg + "Cascade.PERSIST or Cascade.ALL because this is a unidirectional ";
            msg = msg + "relationship. That is, there is no property of type " + owningType + " on " + targetType;
            throw new PersistenceException(msg);
        }
        oneToMany.setUnidirectional();
        DeployBeanPropertyAssocOne unidirectional = new DeployBeanPropertyAssocOne(targetDesc, owningType);
        unidirectional.setUndirectionalShadow();
        unidirectional.setNullable(false);
        unidirectional.setDbRead(true);
        unidirectional.setDbInsertable(true);
        unidirectional.setDbUpdateable(false);
        targetDesc.setUnidirectional(unidirectional);
        BeanTable beanTable = this.getBeanTable(owningType);
        unidirectional.setBeanTable(beanTable);
        unidirectional.setName(beanTable.getBaseTable());
        info.setBeanJoinType(unidirectional, true);
        DeployTableJoin oneToManyJoin = oneToMany.getTableJoin();
        if (!oneToManyJoin.hasJoinColumns()) {
            throw new RuntimeException("No join columns");
        }
        DeployTableJoin unidirectionalJoin = unidirectional.getTableJoin();
        unidirectionalJoin.setColumns(oneToManyJoin.columns(), true);
    }

    private void checkMappedByOneToOne(DeployBeanPropertyAssocOne<?> prop) {
        String mappedBy = prop.getMappedBy();
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        DeployBeanProperty mappedProp = targetDesc.getBeanProperty(mappedBy);
        if (mappedProp == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + targetDesc + "." + mappedBy + "] ";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocOne)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "]is not a OneToOne?";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocOne mappedAssocOne = (DeployBeanPropertyAssocOne)mappedProp;
        if (!mappedAssocOne.isOneToOne()) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "]is not a OneToOne?";
            throw new PersistenceException(m);
        }
        DeployTableJoin tableJoin = prop.getTableJoin();
        if (!tableJoin.hasJoinColumns()) {
            DeployTableJoin otherTableJoin = mappedAssocOne.getTableJoin();
            otherTableJoin.copyWithoutType(tableJoin, true, tableJoin.getTable());
        }
    }

    private void checkMappedByOneToMany(DeployBeanInfo<?> info, DeployBeanPropertyAssocMany<?> prop) {
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        if (targetDesc.isDraftableElement()) {
            prop.setModifyListenMode(BeanCollection.ModifyListenMode.REMOVALS);
            prop.getCascadeInfo().setSaveDelete(true, true);
        }
        if (prop.getMappedBy() == null && !this.findMappedBy(prop)) {
            this.makeUnidirectional(info, prop);
            return;
        }
        String mappedBy = prop.getMappedBy();
        DeployBeanProperty mappedProp = targetDesc.getBeanProperty(mappedBy);
        if (mappedProp == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + mappedBy + "] ";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocOne)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + mappedBy + "]is not a ManyToOne?";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocOne mappedAssocOne = (DeployBeanPropertyAssocOne)mappedProp;
        DeployTableJoin tableJoin = prop.getTableJoin();
        if (!tableJoin.hasJoinColumns()) {
            DeployTableJoin otherTableJoin = mappedAssocOne.getTableJoin();
            otherTableJoin.copyTo(tableJoin, true, tableJoin.getTable());
        }
    }

    private void checkMappedByManyToMany(DeployBeanPropertyAssocMany<?> prop) {
        String mappedBy = prop.getMappedBy();
        if (mappedBy == null) {
            if (this.getTargetDescriptor(prop).isDraftable()) {
                prop.setIntersectionDraftTable();
            }
            return;
        }
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        DeployBeanProperty mappedProp = targetDesc.getBeanProperty(mappedBy);
        if (mappedProp == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + mappedBy + "] ";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocMany)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "] is not a ManyToMany?";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocMany mappedAssocMany = (DeployBeanPropertyAssocMany)mappedProp;
        if (!mappedAssocMany.isManyToMany()) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "] is not a ManyToMany?";
            throw new PersistenceException(m);
        }
        DeployTableJoin mappedIntJoin = mappedAssocMany.getIntersectionJoin();
        DeployTableJoin mappendInverseJoin = mappedAssocMany.getInverseJoin();
        String intTableName = mappedIntJoin.getTable();
        DeployTableJoin tableJoin = prop.getTableJoin();
        mappedIntJoin.copyTo(tableJoin, true, targetDesc.getBaseTable());
        DeployTableJoin intJoin = new DeployTableJoin();
        mappendInverseJoin.copyTo(intJoin, false, intTableName);
        prop.setIntersectionJoin(intJoin);
        DeployTableJoin inverseJoin = new DeployTableJoin();
        mappedIntJoin.copyTo(inverseJoin, false, intTableName);
        prop.setInverseJoin(inverseJoin);
        if (targetDesc.isDraftable()) {
            prop.setIntersectionDraftTable();
        }
    }

    private <T> void setBeanControllerFinderListener(DeployBeanDescriptor<T> descriptor) {
        ChangeLogFilter changeFilter;
        this.persistControllerManager.addPersistControllers(descriptor);
        this.postLoadManager.addPostLoad(descriptor);
        this.persistListenerManager.addPersistListeners(descriptor);
        this.beanQueryAdapterManager.addQueryAdapter(descriptor);
        this.beanFinderManager.addFindControllers(descriptor);
        if (this.changeLogRegister != null && (changeFilter = this.changeLogRegister.getChangeFilter(descriptor.getBeanType())) != null) {
            descriptor.setChangeLogFilter(changeFilter);
        }
    }

    private <T> DeployBeanInfo<T> createDeployBeanInfo(Class<T> beanClass) {
        DeployBeanDescriptor<T> desc = new DeployBeanDescriptor<T>(this, beanClass, this.serverConfig);
        desc.setUpdateChangesOnly(this.updateChangesOnly);
        this.beanLifecycleAdapterFactory.addLifecycleMethods(desc);
        this.setBeanControllerFinderListener(desc);
        this.deplyInherit.process(desc);
        desc.checkInheritanceMapping();
        this.createProperties.createProperties(desc);
        DeployBeanInfo<T> info = new DeployBeanInfo<T>(this.deployUtil, desc);
        this.readAnnotations.readInitial(info, this.eagerFetchLobs);
        return info;
    }

    private <T> void readDeployAssociations(DeployBeanInfo<T> info) {
        DeployBeanDescriptor<T> desc = info.getDescriptor();
        this.readAnnotations.readAssociations(info, this);
        if (BeanDescriptor.EntityType.SQL == desc.getEntityType()) {
            desc.setBaseTable(null, null, null);
        }
        this.transientProperties.process(desc);
        this.setScalarType(desc);
        if (!desc.isEmbedded()) {
            this.setIdGeneration(desc);
            this.setConcurrencyMode(desc);
        }
        this.createByteCode(desc);
    }

    private <T> void setIdGeneration(DeployBeanDescriptor<T> desc) {
        if (desc.getIdGenerator() != null) {
            return;
        }
        if (desc.propertiesId().isEmpty()) {
            if (desc.isBaseTableType() && desc.getBeanFinder() == null) {
                logger.warn(Message.msg("deploy.nouid", desc.getFullName()));
            }
            return;
        }
        if (IdType.SEQUENCE.equals((Object)desc.getIdType()) && !this.dbIdentity.isSupportsSequence()) {
            logger.info("Explicit sequence on " + desc.getFullName() + " but not supported by DB Platform - ignored");
            desc.setIdType(null);
        }
        if (IdType.IDENTITY.equals((Object)desc.getIdType()) && !this.dbIdentity.isSupportsIdentity()) {
            logger.info("Explicit Identity on " + desc.getFullName() + " but not supported by DB Platform - ignored");
            desc.setIdType(null);
        }
        if (desc.getIdType() == null) {
            if (desc.isPrimaryKeyCompoundOrNonNumeric()) {
                logger.debug("Expecting user defined identity on " + desc.getFullName() + " - not using db sequence or autoincrement");
                desc.setIdType(IdType.EXTERNAL);
                return;
            }
            desc.setIdType(this.dbIdentity.getIdType());
            desc.setIdTypePlatformDefault();
        }
        if (desc.getBaseTable() == null) {
            return;
        }
        if (IdType.IDENTITY.equals((Object)desc.getIdType())) {
            String selectLastInsertedId = this.dbIdentity.getSelectLastInsertedId(desc.getBaseTable());
            desc.setSelectLastInsertedId(selectLastInsertedId);
            return;
        }
        String seqName = desc.getIdGeneratorName();
        if (seqName != null) {
            logger.debug("explicit sequence " + seqName + " on " + desc.getFullName());
        } else {
            String primaryKeyColumn = desc.getSinglePrimaryKeyColumn();
            seqName = this.namingConvention.getSequenceName(desc.getBaseTable(), primaryKeyColumn);
        }
        desc.setIdGenerator(this.createSequenceIdGenerator(seqName));
    }

    private PlatformIdGenerator createSequenceIdGenerator(String seqName) {
        return this.databasePlatform.createSequenceIdGenerator(this.backgroundExecutor, this.dataSource, seqName, this.dbSequenceBatchSize);
    }

    private void createByteCode(DeployBeanDescriptor<?> deploy) {
        this.setEntityBeanClass(deploy);
        this.setBeanReflect(deploy);
    }

    private void setScalarType(DeployBeanDescriptor<?> deployDesc) {
        for (DeployBeanProperty prop : deployDesc.propertiesAll()) {
            if (prop instanceof DeployBeanPropertyAssoc) continue;
            this.deployUtil.setScalarType(prop);
        }
    }

    private BeanPropertyInfoFactory createReflectionFactory() {
        return new EnhanceBeanPropertyInfoFactory();
    }

    private void setBeanReflect(DeployBeanDescriptor<?> desc) {
        Class<?> beanType = desc.getBeanType();
        BeanPropertiesReader reflectProps = new BeanPropertiesReader(beanType);
        BeanPropertyInfo beanReflect = this.reflectFactory.create(beanType);
        desc.setProperties(reflectProps.getProperties());
        for (DeployBeanProperty prop : desc.propertiesAll()) {
            String propName = prop.getName();
            Integer pos = reflectProps.getPropertyIndex(propName);
            if (pos == null) {
                if (!this.isPersistentField(prop)) continue;
                throw new IllegalStateException("Property " + propName + " not found in " + reflectProps + " for type " + beanType);
            }
            int propertyIndex = pos;
            prop.setPropertyIndex(propertyIndex);
            prop.setGetter(beanReflect.getGetter(propertyIndex));
            prop.setSetter(beanReflect.getSetter(propertyIndex));
        }
    }

    private boolean isPersistentField(DeployBeanProperty prop) {
        Field field = prop.getField();
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(Transient.class);
    }

    private void setConcurrencyMode(DeployBeanDescriptor<?> desc) {
        if (desc.getConcurrencyMode() != null) {
            return;
        }
        if (this.checkForVersionProperties(desc)) {
            desc.setConcurrencyMode(ConcurrencyMode.VERSION);
        } else {
            desc.setConcurrencyMode(ConcurrencyMode.NONE);
        }
    }

    private boolean checkForVersionProperties(DeployBeanDescriptor<?> desc) {
        boolean hasVersionProperty = false;
        List<DeployBeanProperty> props = desc.propertiesBase();
        for (int i = 0; i < props.size(); ++i) {
            if (!props.get(i).isVersionColumn()) continue;
            hasVersionProperty = true;
        }
        return hasVersionProperty;
    }

    private boolean hasEntityBeanInterface(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(EntityBean.class)) continue;
            return true;
        }
        return false;
    }

    private void setEntityBeanClass(DeployBeanDescriptor<?> desc) {
        Class<?> beanClass = desc.getBeanType();
        if (!this.hasEntityBeanInterface(beanClass)) {
            throw new IllegalStateException("Bean " + beanClass + " is not enhanced?");
        }
        this.checkInheritedClasses(beanClass);
        if (!beanClass.getName().startsWith("com.avaje.ebean.meta")) {
            ++this.entityBeanCount;
        }
    }

    private void checkInheritedClasses(Class<?> beanClass) {
        Class<?> superclass = beanClass.getSuperclass();
        if (Object.class.equals(superclass)) {
            return;
        }
        if (Model.class.equals(superclass)) {
            return;
        }
        if (!EntityBean.class.isAssignableFrom(superclass)) {
            if (this.isMappedSuperWithNoProperties(superclass)) {
                return;
            }
            throw new IllegalStateException("Super type " + superclass + " is not enhanced?");
        }
        this.checkInheritedClasses(superclass);
    }

    private boolean isMappedSuperWithNoProperties(Class<?> beanClass) {
        Field[] fields;
        MappedSuperclass annotation = beanClass.getAnnotation(MappedSuperclass.class);
        if (annotation == null) {
            return false;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isAnnotationPresent(Transient.class)) continue;
            return false;
        }
        return true;
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    private static final class BeanDescComparator
    implements Comparator<BeanDescriptor<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BeanDescComparator() {
        }

        @Override
        public int compare(BeanDescriptor<?> o1, BeanDescriptor<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

