/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.Query;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import java.util.ArrayList;

public final class BeanDescriptorDraftHelp<T> {
    private final BeanDescriptor<T> desc;
    private final BeanProperty draftDirty;
    private final BeanProperty[] resetProperties;

    public BeanDescriptorDraftHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.draftDirty = desc.getDraftDirty();
        this.resetProperties = this.resetProperties();
    }

    private BeanProperty[] resetProperties() {
        BeanProperty[] props;
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (BeanProperty prop : props = this.desc.propertiesNonMany()) {
            if (!prop.isDraftReset()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanProperty[list.size()]);
    }

    public boolean draftReset(T draftBean) {
        EntityBean draftEntityBean = (EntityBean)draftBean;
        if (this.draftDirty != null) {
            this.draftDirty.setValueIntercept(draftEntityBean, false);
        }
        for (BeanProperty resetProperty : this.resetProperties) {
            resetProperty.setValueIntercept(draftEntityBean, null);
        }
        return draftEntityBean._ebean_getIntercept().isDirty();
    }

    public T publish(T draftBean, T liveBean) {
        if (liveBean == null) {
            liveBean = this.desc.createEntityBean();
        }
        EntityBean draft = (EntityBean)draftBean;
        EntityBean live = (EntityBean)liveBean;
        BeanProperty idProperty = this.desc.getIdProperty();
        if (idProperty != null) {
            idProperty.publish(draft, live);
        }
        BeanProperty[] props = this.desc.propertiesNonMany();
        for (int i = 0; i < props.length; ++i) {
            props[i].publish(draft, live);
        }
        BeanPropertyAssocMany<?>[] many = this.desc.propertiesMany();
        for (int i = 0; i < many.length; ++i) {
            if (!many[i].getTargetDescriptor().isDraftable()) continue;
            many[i].publishMany(draft, live);
        }
        return liveBean;
    }

    public void draftQueryOptimise(Query<T> query) {
        BeanPropertyAssocOne<?>[] one = this.desc.propertiesOne();
        for (int i = 0; i < one.length; ++i) {
            if (!one[i].getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(one[i].getName());
        }
        BeanPropertyAssocMany<?>[] many = this.desc.propertiesMany();
        for (int i = 0; i < many.length; ++i) {
            if (!many[i].getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(many[i].getName());
        }
    }
}

