/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core.bootup;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.core.ClassPathScanners;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.core.bootup.DistillPackages;
import com.avaje.ebeaninternal.server.core.bootup.ManifestReader;
import java.util.List;
import java.util.Set;
import org.avaje.classpath.scanner.ClassFilter;
import org.avaje.classpath.scanner.ClassPathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootupClassPathSearch {
    private static final Logger logger = LoggerFactory.getLogger(BootupClassPathSearch.class);
    private static final String EBEAN_MF = "META-INF/ebean.mf";
    private final List<String> packages;
    private final List<ClassPathScanner> scanners;

    public static BootupClasses search(ServerConfig serverConfig) {
        return new BootupClassPathSearch(serverConfig).getBootupClasses();
    }

    private BootupClassPathSearch(ServerConfig serverConfig) {
        Set<String> mfPackages = ManifestReader.readManifests(serverConfig.getClassLoadConfig().getClassLoader(), EBEAN_MF);
        this.packages = DistillPackages.distill(serverConfig.getPackages(), mfPackages);
        this.scanners = ClassPathScanners.find(serverConfig);
    }

    private BootupClasses getBootupClasses() {
        try {
            BootupClasses bc = new BootupClasses();
            long st = System.currentTimeMillis();
            for (ClassPathScanner finder : this.scanners) {
                if (this.packages != null && !this.packages.isEmpty()) {
                    for (String packageName : this.packages) {
                        finder.scanForClasses(packageName, (ClassFilter)bc);
                    }
                    continue;
                }
                finder.scanForClasses("", (ClassFilter)bc);
            }
            long searchTime = System.currentTimeMillis() - st;
            logger.info("Classpath search entities[{}] searchTime[{}] in packages[{}]", new Object[]{bc.getEntities().size(), searchTime, this.packages});
            return bc;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in classpath search (looking for entities etc)", ex);
        }
    }
}

