/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.avaje.ebean.Transaction;
import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiSqlQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.lib.util.Str;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.DefaultSqlRow;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.util.BindParamsParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelationalQueryRequest {
    private static final Logger logger = LoggerFactory.getLogger(RelationalQueryRequest.class);
    private final SpiSqlQuery query;
    private final RelationalQueryEngine queryEngine;
    private final SpiEbeanServer ebeanServer;
    private SpiTransaction trans;
    private boolean createdTransaction;
    private String sql;
    private ResultSet resultSet;
    private int rowCount;
    private String bindLog = "";
    private String[] propertyNames;
    private int estimateCapacity;
    private PreparedStatement pstmt;

    public RelationalQueryRequest(SpiEbeanServer server, RelationalQueryEngine engine, SqlQuery q, Transaction t) {
        this.ebeanServer = server;
        this.queryEngine = engine;
        this.query = (SpiSqlQuery)q;
        this.trans = (SpiTransaction)t;
    }

    public void initTransIfRequired() {
        if (this.trans == null) {
            this.trans = this.ebeanServer.getCurrentServerTransaction();
            if (this.trans == null || !this.trans.isActive()) {
                this.trans = this.ebeanServer.createServerTransaction(false, -1);
                this.createdTransaction = true;
            }
        }
    }

    public void endTransIfRequired() {
        if (this.createdTransaction) {
            this.trans.commit();
        }
    }

    public void findEach(QueryEachConsumer<SqlRow> consumer) {
        this.queryEngine.findEach(this, consumer);
    }

    public void findEachWhile(QueryEachWhileConsumer<SqlRow> consumer) {
        this.queryEngine.findEach(this, consumer);
    }

    public List<SqlRow> findList() {
        return this.queryEngine.findList(this);
    }

    public SpiSqlQuery getQuery() {
        return this.query;
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public SpiTransaction getTransaction() {
        return this.trans;
    }

    public boolean isLogSql() {
        return this.trans.isLogSql();
    }

    public boolean isLogSummary() {
        return this.trans.isLogSummary();
    }

    private void setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.propertyNames = this.getPropertyNames();
        float initCap = (float)this.propertyNames.length / 0.7f;
        this.estimateCapacity = (int)initCap + 1;
    }

    private String[] getPropertyNames() throws SQLException {
        ArrayList<String> propNames = new ArrayList<String>();
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnsPlusOne = metaData.getColumnCount() + 1;
        for (int i = 1; i < columnsPlusOne; ++i) {
            propNames.add(metaData.getColumnLabel(i));
        }
        return propNames.toArray(new String[propNames.size()]);
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public boolean next() throws SQLException {
        ++this.rowCount;
        return this.resultSet.next();
    }

    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.error(null, (Throwable)e);
        }
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (SQLException e) {
            logger.error(null, (Throwable)e);
        }
    }

    public SqlRow createNewRow(String dbTrueValue) throws SQLException {
        DefaultSqlRow sqlRow = new DefaultSqlRow(this.estimateCapacity, 0.75f, dbTrueValue);
        int index = 0;
        for (int i = 0; i < this.propertyNames.length; ++i) {
            Object value = this.resultSet.getObject(++index);
            sqlRow.set(this.propertyNames[i], value);
        }
        return sqlRow;
    }

    private void prepareSql() {
        String sql = this.query.getQuery();
        BindParams bindParams = this.query.getBindParams();
        if (!bindParams.isEmpty()) {
            sql = BindParamsParser.parse(bindParams, sql);
        }
        this.sql = this.limitOffset(sql);
    }

    private String limitOffset(String sql) {
        int firstRow = this.query.getFirstRow();
        int maxRows = this.query.getMaxRows();
        if (firstRow > 0 || maxRows > 0) {
            return this.ebeanServer.getDatabasePlatform().getBasicSqlLimiter().limit(sql, firstRow, maxRows);
        }
        return sql;
    }

    public void executeSql(Binder binder) throws SQLException {
        BindParams bindParams;
        this.prepareSql();
        Connection conn = this.trans.getInternalConnection();
        this.pstmt = conn.prepareStatement(this.sql);
        if (this.query.getTimeout() > 0) {
            this.pstmt.setQueryTimeout(this.query.getTimeout());
        }
        if (this.query.getBufferFetchSizeHint() > 0) {
            this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
        }
        if (!(bindParams = this.query.getBindParams()).isEmpty()) {
            this.bindLog = binder.bind(bindParams, this.pstmt, conn);
        }
        if (this.isLogSql()) {
            String logSql = this.sql;
            if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                logSql = Str.add(logSql, "; --bind(", this.bindLog, ")");
            }
            this.trans.logSql(logSql);
        }
        this.setResultSet(this.pstmt.executeQuery());
    }

    public String getSql() {
        return this.sql;
    }

    public int getRowCount() {
        return this.rowCount - 1;
    }
}

