/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.config.ExternalTransactionManager;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbHistorySupport;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeLogPrepare;
import com.avaje.ebean.event.changelog.ChangeLogRegister;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebean.plugin.Plugin;
import com.avaje.ebean.plugin.SpiServer;
import com.avaje.ebean.text.json.JsonContext;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.autotune.AutoTuneService;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneServiceFactory;
import com.avaje.ebeaninternal.server.changelog.DefaultChangeLogListener;
import com.avaje.ebeaninternal.server.changelog.DefaultChangeLogPrepare;
import com.avaje.ebeaninternal.server.changelog.DefaultChangeLogRegister;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.DbExpressionHandler;
import com.avaje.ebeaninternal.server.core.NotSupportedDbExpression;
import com.avaje.ebeaninternal.server.core.OracleDbExpression;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.core.PostgresJsonExpression;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.core.timezone.CloneDataTimeZone;
import com.avaje.ebeaninternal.server.core.timezone.DataTimeZone;
import com.avaje.ebeaninternal.server.core.timezone.NoDataTimeZone;
import com.avaje.ebeaninternal.server.core.timezone.SimpleDataTimeZone;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedPropertyFactory;
import com.avaje.ebeaninternal.server.deploy.parse.DeployCreateProperties;
import com.avaje.ebeaninternal.server.deploy.parse.DeployInherit;
import com.avaje.ebeaninternal.server.deploy.parse.DeployUtil;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionFactory;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.DefaultPersister;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import com.avaje.ebeaninternal.server.query.DefaultOrmQueryEngine;
import com.avaje.ebeaninternal.server.query.DefaultRelationalQueryEngine;
import com.avaje.ebeaninternal.server.readaudit.DefaultReadAuditLogger;
import com.avaje.ebeaninternal.server.readaudit.DefaultReadAuditPrepare;
import com.avaje.ebeaninternal.server.text.json.DJsonContext;
import com.avaje.ebeaninternal.server.transaction.AutoCommitTransactionManager;
import com.avaje.ebeaninternal.server.transaction.DefaultTransactionScopeManager;
import com.avaje.ebeaninternal.server.transaction.ExplicitTransactionManager;
import com.avaje.ebeaninternal.server.transaction.ExternalTransactionScopeManager;
import com.avaje.ebeaninternal.server.transaction.JtaTransactionManager;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.transaction.TransactionScopeManager;
import com.avaje.ebeaninternal.server.type.DefaultTypeManager;
import com.avaje.ebeaninternal.server.type.TypeManager;
import com.avaje.ebeanservice.docstore.api.DocStoreFactory;
import com.avaje.ebeanservice.docstore.api.DocStoreIntegration;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdateProcessor;
import com.avaje.ebeanservice.docstore.none.NoneDocStoreFactory;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.avaje.datasource.DataSourcePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(InternalConfiguration.class);
    private final ServerConfig serverConfig;
    private final BootupClasses bootupClasses;
    private final DeployInherit deployInherit;
    private final TypeManager typeManager;
    private final DataTimeZone dataTimeZone;
    private final Binder binder;
    private final DeployCreateProperties deployCreateProperties;
    private final DeployUtil deployUtil;
    private final BeanDescriptorManager beanDescriptorManager;
    private final CQueryEngine cQueryEngine;
    private final ClusterManager clusterManager;
    private final ServerCacheManager cacheManager;
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final JsonFactory jsonFactory;
    private final DocStoreFactory docStoreFactory;
    private final List<Plugin> plugins = new ArrayList<Plugin>();

    public InternalConfiguration(ClusterManager clusterManager, ServerCacheManager cacheManager, SpiBackgroundExecutor backgroundExecutor, ServerConfig serverConfig, BootupClasses bootupClasses) {
        this.docStoreFactory = this.initDocStoreFactory(serverConfig.service(DocStoreFactory.class));
        this.jsonFactory = serverConfig.getJsonFactory();
        this.clusterManager = clusterManager;
        this.backgroundExecutor = backgroundExecutor;
        this.cacheManager = cacheManager;
        this.serverConfig = serverConfig;
        this.bootupClasses = bootupClasses;
        DatabasePlatform databasePlatform = serverConfig.getDatabasePlatform();
        this.expressionFactory = this.initExpressionFactory(serverConfig, databasePlatform);
        this.typeManager = new DefaultTypeManager(serverConfig, bootupClasses);
        this.deployInherit = new DeployInherit(bootupClasses);
        this.deployCreateProperties = new DeployCreateProperties(this.typeManager);
        this.deployUtil = new DeployUtil(this.typeManager, serverConfig);
        this.beanDescriptorManager = new BeanDescriptorManager(this);
        Map<String, String> asOfTableMapping = this.beanDescriptorManager.deploy();
        Map<String, String> draftTableMap = this.beanDescriptorManager.getDraftTableMap();
        this.dataTimeZone = this.initDataTimeZone();
        this.binder = this.getBinder(this.typeManager, databasePlatform, this.dataTimeZone);
        this.cQueryEngine = new CQueryEngine(serverConfig, databasePlatform, this.binder, asOfTableMapping, draftTableMap);
    }

    private ExpressionFactory initExpressionFactory(ServerConfig serverConfig, DatabasePlatform databasePlatform) {
        boolean nativeIlike = serverConfig.isExpressionNativeIlike() && databasePlatform.isSupportsNativeIlike();
        return new DefaultExpressionFactory(serverConfig.isExpressionEqualsWithNullAsNoop(), nativeIlike);
    }

    private DocStoreFactory initDocStoreFactory(DocStoreFactory service) {
        return service == null ? new NoneDocStoreFactory() : service;
    }

    public DocStoreFactory getDocStoreFactory() {
        return this.docStoreFactory;
    }

    public <T> T plugin(T maybePlugin) {
        if (maybePlugin instanceof Plugin) {
            this.plugins.add((Plugin)maybePlugin);
        }
        return maybePlugin;
    }

    public List<Plugin> getPlugins() {
        for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
            if (this.plugins.contains(plugin)) continue;
            this.plugins.add(plugin);
        }
        return this.plugins;
    }

    public ChangeLogPrepare changeLogPrepare(ChangeLogPrepare prepare) {
        return this.plugin(prepare != null ? prepare : new DefaultChangeLogPrepare());
    }

    public ChangeLogRegister changeLogRegister(ChangeLogRegister register) {
        boolean includeInserts = this.serverConfig.isChangeLogIncludeInserts();
        return this.plugin(register != null ? register : new DefaultChangeLogRegister(includeInserts));
    }

    public ChangeLogListener changeLogListener(ChangeLogListener listener) {
        return this.plugin(listener != null ? listener : new DefaultChangeLogListener());
    }

    public ReadAuditLogger getReadAuditLogger() {
        ReadAuditLogger found = this.bootupClasses.getReadAuditLogger();
        return this.plugin(found != null ? found : new DefaultReadAuditLogger());
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        ReadAuditPrepare found = this.bootupClasses.getReadAuditPrepare();
        return this.plugin(found != null ? found : new DefaultReadAuditPrepare());
    }

    private Binder getBinder(TypeManager typeManager, DatabasePlatform databasePlatform, DataTimeZone dataTimeZone) {
        DbExpressionHandler jsonHandler = this.getDbExpressionHandler(databasePlatform);
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        if (historySupport == null) {
            return new Binder(typeManager, 0, false, jsonHandler, dataTimeZone);
        }
        return new Binder(typeManager, historySupport.getBindCount(), historySupport.isStandardsBased(), jsonHandler, dataTimeZone);
    }

    private DbExpressionHandler getDbExpressionHandler(DatabasePlatform databasePlatform) {
        String name = databasePlatform.getName();
        if ("postgres".equalsIgnoreCase(name)) {
            return new PostgresJsonExpression();
        }
        if ("oracle".equalsIgnoreCase(name)) {
            return new OracleDbExpression();
        }
        return new NotSupportedDbExpression();
    }

    public JsonContext createJsonContext(SpiEbeanServer server) {
        return new DJsonContext(server, this.jsonFactory, this.typeManager);
    }

    public AutoTuneService createAutoTuneService(SpiEbeanServer server) {
        return AutoTuneServiceFactory.create(server, this.serverConfig);
    }

    public RelationalQueryEngine createRelationalQueryEngine() {
        return new DefaultRelationalQueryEngine(this.binder, this.serverConfig.getDatabaseBooleanTrue());
    }

    public OrmQueryEngine createOrmQueryEngine() {
        return new DefaultOrmQueryEngine(this.cQueryEngine);
    }

    public Persister createPersister(SpiEbeanServer server) {
        return new DefaultPersister(server, this.binder, this.beanDescriptorManager);
    }

    public ServerCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public BootupClasses getBootupClasses() {
        return this.bootupClasses;
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.serverConfig.getDatabasePlatform();
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public Binder getBinder() {
        return this.binder;
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public DeployInherit getDeployInherit() {
        return this.deployInherit;
    }

    public DeployCreateProperties getDeployCreateProperties() {
        return this.deployCreateProperties;
    }

    public DeployUtil getDeployUtil() {
        return this.deployUtil;
    }

    public CQueryEngine getCQueryEngine() {
        return this.cQueryEngine;
    }

    public SpiBackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public GeneratedPropertyFactory getGeneratedPropertyFactory() {
        return new GeneratedPropertyFactory(this.serverConfig, this.bootupClasses.getIdGenerators());
    }

    public DocStoreIntegration createDocStoreIntegration(SpiServer server) {
        return this.plugin(this.docStoreFactory.create(server));
    }

    public TransactionManager createTransactionManager(DocStoreUpdateProcessor indexUpdateProcessor) {
        boolean localL2 = this.cacheManager.isLocalL2Caching();
        if (this.serverConfig.isExplicitTransactionBeginMode()) {
            return new ExplicitTransactionManager(localL2, this.serverConfig, this.clusterManager, this.backgroundExecutor, indexUpdateProcessor, this.beanDescriptorManager, this.getBootupClasses());
        }
        if (this.isAutoCommitMode()) {
            return new AutoCommitTransactionManager(localL2, this.serverConfig, this.clusterManager, this.backgroundExecutor, indexUpdateProcessor, this.beanDescriptorManager, this.getBootupClasses());
        }
        return new TransactionManager(localL2, this.serverConfig, this.clusterManager, this.backgroundExecutor, indexUpdateProcessor, this.beanDescriptorManager, this.getBootupClasses());
    }

    private boolean isAutoCommitMode() {
        if (this.serverConfig.isAutoCommitMode()) {
            return true;
        }
        DataSource dataSource = this.serverConfig.getDataSource();
        return dataSource instanceof DataSourcePool && ((DataSourcePool)dataSource).isAutoCommit();
    }

    public TransactionScopeManager createTransactionScopeManager(TransactionManager transactionManager) {
        ExternalTransactionManager externalTransactionManager = this.serverConfig.getExternalTransactionManager();
        if (externalTransactionManager == null && this.serverConfig.isUseJtaTransactionManager()) {
            externalTransactionManager = new JtaTransactionManager();
        }
        if (externalTransactionManager != null) {
            externalTransactionManager.setTransactionManager(transactionManager);
            logger.info("Using Transaction Manager [" + externalTransactionManager.getClass() + "]");
            return new ExternalTransactionScopeManager(transactionManager, externalTransactionManager);
        }
        return new DefaultTransactionScopeManager(transactionManager);
    }

    private DataTimeZone initDataTimeZone() {
        String tz = this.serverConfig.getDataTimeZone();
        if (tz == null) {
            return new NoDataTimeZone();
        }
        if (this.getDatabasePlatform().getName().toLowerCase().startsWith("oracle")) {
            return new CloneDataTimeZone(tz);
        }
        return new SimpleDataTimeZone(tz);
    }

    public DataTimeZone getDataTimeZone() {
        return this.dataTimeZone;
    }
}

