/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.AutoTune;
import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.BeanState;
import com.avaje.ebean.CallableSql;
import com.avaje.ebean.DocumentStore;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.Filter;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.TransactionCallback;
import com.avaje.ebean.TxCallable;
import com.avaje.ebean.TxIsolation;
import com.avaje.ebean.TxRunnable;
import com.avaje.ebean.TxScope;
import com.avaje.ebean.TxType;
import com.avaje.ebean.Update;
import com.avaje.ebean.UpdateQuery;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DdlGenerator;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebean.meta.MetaInfoManager;
import com.avaje.ebean.plugin.BeanType;
import com.avaje.ebean.plugin.Plugin;
import com.avaje.ebean.plugin.SpiServer;
import com.avaje.ebean.text.csv.CsvReader;
import com.avaje.ebean.text.json.JsonContext;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.ScopeTrans;
import com.avaje.ebeaninternal.api.ScopedTransaction;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.autotune.AutoTuneService;
import com.avaje.ebeaninternal.server.core.CObjectGraphNodeStatistics;
import com.avaje.ebeaninternal.server.core.CallStackFactory;
import com.avaje.ebeaninternal.server.core.DefaultBeanLoader;
import com.avaje.ebeaninternal.server.core.DefaultBeanState;
import com.avaje.ebeaninternal.server.core.DefaultCallStackFactory;
import com.avaje.ebeaninternal.server.core.DefaultCallableSql;
import com.avaje.ebeaninternal.server.core.DefaultMetaInfoManager;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.core.RelationalQueryEngine;
import com.avaje.ebeaninternal.server.core.RelationalQueryRequest;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.core.TransWrapper;
import com.avaje.ebeaninternal.server.core.timezone.DataTimeZone;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.el.ElFilter;
import com.avaje.ebeaninternal.server.grammer.EqlParser;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import com.avaje.ebeaninternal.server.query.CallableQueryIds;
import com.avaje.ebeaninternal.server.query.CallableQueryList;
import com.avaje.ebeaninternal.server.query.CallableQueryRowCount;
import com.avaje.ebeaninternal.server.query.LimitOffsetPagedList;
import com.avaje.ebeaninternal.server.query.QueryFutureIds;
import com.avaje.ebeaninternal.server.query.QueryFutureList;
import com.avaje.ebeaninternal.server.query.QueryFutureRowCount;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmQuery;
import com.avaje.ebeaninternal.server.querydefn.DefaultOrmUpdate;
import com.avaje.ebeaninternal.server.querydefn.DefaultRelationalQuery;
import com.avaje.ebeaninternal.server.querydefn.DefaultUpdateQuery;
import com.avaje.ebeaninternal.server.text.csv.TCsvReader;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.transaction.TransactionScopeManager;
import com.avaje.ebeaninternal.util.ParamTypeHelper;
import com.avaje.ebeanservice.docstore.api.DocStoreIntegration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.avaje.dbmigration.MigrationRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultServer
implements SpiServer,
SpiEbeanServer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServer.class);
    private static final int IGNORE_LEADING_ELEMENTS = 5;
    private static final String COM_AVAJE_EBEAN = "com.avaje.ebean";
    private static final String ORG_AVAJE_EBEAN = "org.avaje.ebean";
    private final ServerConfig serverConfig;
    private final String serverName;
    private final DatabasePlatform databasePlatform;
    private final TransactionManager transactionManager;
    private final TransactionScopeManager transactionScopeManager;
    private final DataTimeZone dataTimeZone;
    private final CallStackFactory callStackFactory = new DefaultCallStackFactory();
    private final int maxCallStack;
    private final boolean rollbackOnChecked;
    private final Persister persister;
    private final OrmQueryEngine queryEngine;
    private final RelationalQueryEngine relationalQueryEngine;
    private final ServerCacheManager serverCacheManager;
    private final BeanDescriptorManager beanDescriptorManager;
    private final AutoTuneService autoTuneService;
    private final ReadAuditPrepare readAuditPrepare;
    private final ReadAuditLogger readAuditLogger;
    private final CQueryEngine cqueryEngine;
    private final List<Plugin> serverPlugins;
    private final DdlGenerator ddlGenerator;
    private final ExpressionFactory expressionFactory;
    private final SpiBackgroundExecutor backgroundExecutor;
    private final DefaultBeanLoader beanLoader;
    private final EncryptKeyManager encryptKeyManager;
    private final JsonContext jsonContext;
    private final DocumentStore documentStore;
    private final MetaInfoManager metaInfoManager;
    private final PersistenceContextScope defaultPersistenceContextScope;
    private boolean shutdown;
    private final int lazyLoadBatchSize;
    private final int queryBatchSize;
    private final boolean updateAllPropertiesInBatch;
    private final boolean collectQueryOrigins;
    private final boolean collectQueryStatsByNode;
    protected final ConcurrentHashMap<ObjectGraphNode, CObjectGraphNodeStatistics> objectGraphStats;

    public DefaultServer(InternalConfiguration config, ServerCacheManager cache) {
        this.serverConfig = config.getServerConfig();
        this.objectGraphStats = new ConcurrentHashMap();
        this.metaInfoManager = new DefaultMetaInfoManager(this);
        this.serverCacheManager = cache;
        this.databasePlatform = config.getDatabasePlatform();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.serverName = this.serverConfig.getName();
        this.lazyLoadBatchSize = this.serverConfig.getLazyLoadBatchSize();
        this.queryBatchSize = this.serverConfig.getQueryBatchSize();
        this.cqueryEngine = config.getCQueryEngine();
        this.expressionFactory = config.getExpressionFactory();
        this.encryptKeyManager = this.serverConfig.getEncryptKeyManager();
        this.defaultPersistenceContextScope = this.serverConfig.getPersistenceContextScope();
        this.beanDescriptorManager = config.getBeanDescriptorManager();
        this.beanDescriptorManager.setEbeanServer(this);
        this.updateAllPropertiesInBatch = this.serverConfig.isUpdateAllPropertiesInBatch();
        this.collectQueryOrigins = this.serverConfig.isCollectQueryOrigins();
        this.collectQueryStatsByNode = this.serverConfig.isCollectQueryStatsByNode();
        this.maxCallStack = this.serverConfig.getMaxCallStack();
        this.rollbackOnChecked = this.serverConfig.isTransactionRollbackOnChecked();
        this.persister = config.createPersister(this);
        this.queryEngine = config.createOrmQueryEngine();
        this.relationalQueryEngine = config.createRelationalQueryEngine();
        this.autoTuneService = config.createAutoTuneService(this);
        this.readAuditPrepare = config.getReadAuditPrepare();
        this.readAuditLogger = config.getReadAuditLogger();
        this.beanLoader = new DefaultBeanLoader(this);
        this.jsonContext = config.createJsonContext(this);
        this.dataTimeZone = config.getDataTimeZone();
        DocStoreIntegration docStoreComponents = config.createDocStoreIntegration(this);
        this.transactionManager = config.createTransactionManager(docStoreComponents.updateProcessor());
        this.transactionScopeManager = config.createTransactionScopeManager(this.transactionManager);
        this.documentStore = docStoreComponents.documentStore();
        this.serverPlugins = config.getPlugins();
        this.ddlGenerator = new DdlGenerator(this, this.serverConfig);
        this.configureServerPlugins();
        ShutdownManager.registerEbeanServer(this);
    }

    private void configureServerPlugins() {
        this.autoTuneService.startup();
        for (Plugin plugin : this.serverPlugins) {
            plugin.configure(this);
        }
    }

    public void executePlugins(boolean online) {
        this.ddlGenerator.execute(online);
        for (Plugin plugin : this.serverPlugins) {
            plugin.online(online);
        }
    }

    @Override
    public boolean isCollectQueryOrigins() {
        return this.collectQueryOrigins;
    }

    @Override
    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Override
    public DataTimeZone getDataTimeZone() {
        return this.dataTimeZone;
    }

    @Override
    public MetaInfoManager getMetaInfoManager() {
        return this.metaInfoManager;
    }

    @Override
    public SpiServer getPluginApi() {
        return this;
    }

    @Override
    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    @Override
    public AutoTune getAutoTune() {
        return this.autoTuneService;
    }

    @Override
    public DataSource getDataSource() {
        return this.transactionManager.getDataSource();
    }

    @Override
    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    @Override
    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public void initialise() {
        if (this.encryptKeyManager != null) {
            this.encryptKeyManager.initialise();
        }
    }

    public void start() {
        DbMigrationConfig migrationConfig = this.serverConfig.getMigrationConfig();
        if (migrationConfig != null) {
            migrationConfig.generateOnStart(this);
            if (migrationConfig.isRunMigration()) {
                ClassLoader classLoader = this.serverConfig.getClassLoadConfig().getClassLoader();
                MigrationRunner runner = migrationConfig.createRunner(classLoader);
                runner.run(this.serverConfig.getDataSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownManaged() {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            this.shutdownInternal(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            ShutdownManager.unregisterEbeanServer(this);
            this.shutdownInternal(shutdownDataSource, deregisterDriver);
        }
    }

    private void shutdownInternal(boolean shutdownDataSource, boolean deregisterDriver) {
        logger.debug("Shutting down EbeanServer {}", (Object)this.serverName);
        if (this.shutdown) {
            return;
        }
        this.shutdownPlugins();
        this.autoTuneService.shutdown();
        this.backgroundExecutor.shutdown();
        this.transactionManager.shutdown(shutdownDataSource, deregisterDriver);
        this.shutdown = true;
        if (shutdownDataSource) {
            this.serverConfig.setDataSource(null);
        }
    }

    private void shutdownPlugins() {
        for (Plugin plugin : this.serverPlugins) {
            try {
                plugin.shutdown();
            }
            catch (Throwable e) {
                logger.error("Error when shutting down plugin", e);
            }
        }
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public BeanState getBeanState(Object bean) {
        if (bean instanceof EntityBean) {
            return new DefaultBeanState((EntityBean)bean);
        }
        return null;
    }

    @Override
    public <T> CQuery<T> compileQuery(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> qr = this.createQueryRequest(SpiQuery.Type.SUBQUERY, query, t);
        OrmQueryRequest orm = (OrmQueryRequest)qr;
        return this.cqueryEngine.buildQuery(orm);
    }

    @Override
    public ServerCacheManager getServerCacheManager() {
        return this.serverCacheManager;
    }

    @Override
    public void refreshMany(Object parentBean, String propertyName) {
        this.beanLoader.refreshMany(this.checkEntityBean(parentBean), propertyName);
    }

    @Override
    public void loadMany(LoadManyRequest loadRequest) {
        this.beanLoader.loadMany(loadRequest);
    }

    @Override
    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        this.beanLoader.loadMany(bc, onlyIds);
    }

    @Override
    public void refresh(Object bean) {
        this.beanLoader.refresh(this.checkEntityBean(bean));
    }

    @Override
    public void loadBean(LoadBeanRequest loadRequest) {
        this.beanLoader.loadBean(loadRequest);
    }

    @Override
    public void loadBean(EntityBeanIntercept ebi) {
        this.beanLoader.loadBean(ebi);
    }

    @Override
    public Map<String, ValuePair> diff(Object a, Object b) {
        if (a == null) {
            return null;
        }
        BeanDescriptor<?> desc = this.getBeanDescriptor(a.getClass());
        return DiffHelp.diff(a, b, desc);
    }

    @Override
    public void externalModification(TransactionEventTable tableEvent) {
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null) {
            t.getEvent().add(tableEvent);
        } else {
            this.transactionManager.externalModification(tableEvent);
        }
    }

    @Override
    public void externalModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        TransactionEventTable evt = new TransactionEventTable();
        evt.add(tableName, inserts, updates, deletes);
        this.externalModification(evt);
    }

    @Override
    public void clearQueryStatistics() {
        for (BeanDescriptor<?> desc : this.getBeanDescriptors()) {
            desc.clearQueryStatistics();
        }
    }

    @Override
    public <T> T createEntityBean(Class<T> type) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        return (T)desc.createEntityBean();
    }

    @Override
    public <T> T getReference(Class<T> type, Object id) {
        Object existing;
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        BeanDescriptor<T> desc = this.getBeanDescriptor(type);
        id = desc.convertId(id);
        PersistenceContext pc = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (t != null && (existing = desc.contextGet(pc = t.getPersistenceContext(), id)) != null) {
            return (T)existing;
        }
        InheritInfo inheritInfo = desc.getInheritInfo();
        if (inheritInfo == null) {
            return (T)desc.contextRef(pc, null, false, id);
        }
        BeanProperty idProp = desc.getIdProperty();
        if (idProp == null) {
            throw new PersistenceException("No ID properties for this type? " + desc);
        }
        return this.find(type).select(idProp.getName()).setId(id).findUnique();
    }

    @Override
    public void register(TransactionCallback transactionCallback) {
        Transaction transaction = this.currentTransaction();
        if (transaction == null) {
            throw new PersistenceException("Not currently active transaction when trying to register transactionCallback");
        }
        transaction.register(transactionCallback);
    }

    @Override
    public Transaction createTransaction() {
        return this.transactionManager.createTransaction(true, -1);
    }

    @Override
    public Transaction createTransaction(TxIsolation isolation) {
        return this.transactionManager.createTransaction(true, isolation.getLevel());
    }

    @Override
    public <T> T execute(TxCallable<T> c) {
        return this.execute(null, c);
    }

    @Override
    public <T> T execute(TxScope scope, TxCallable<T> c) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            T t = c.call();
            return t;
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    @Override
    public void execute(TxRunnable r) {
        this.execute(null, r);
    }

    @Override
    public void execute(TxScope scope, TxRunnable r) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        try {
            r.run();
        }
        catch (Error e) {
            throw scopeTrans.caughtError(e);
        }
        catch (RuntimeException e) {
            throw scopeTrans.caughtThrowable(e);
        }
        finally {
            scopeTrans.onFinally();
        }
    }

    private boolean createNewTransaction(SpiTransaction t, TxScope scope) {
        TxType type = scope.getType();
        switch (type) {
            case REQUIRED: {
                return t == null;
            }
            case REQUIRES_NEW: {
                return true;
            }
            case MANDATORY: {
                if (t == null) {
                    throw new PersistenceException("Transaction missing when MANDATORY");
                }
                return true;
            }
            case NEVER: {
                if (t != null) {
                    throw new PersistenceException("Transaction exists for Transactional NEVER");
                }
                return false;
            }
            case SUPPORTS: {
                return false;
            }
            case NOT_SUPPORTED: {
                throw new RuntimeException("NOT_SUPPORTED should already be handled?");
            }
        }
        throw new RuntimeException("Should never get here?");
    }

    @Override
    public ScopeTrans createScopeTrans(TxScope txScope) {
        boolean newTransaction;
        if (txScope == null) {
            txScope = new TxScope();
        } else {
            txScope.checkBatchMode();
        }
        SpiTransaction suspended = null;
        SpiTransaction t = this.transactionScopeManager.get();
        if (txScope.getType().equals((Object)TxType.NOT_SUPPORTED)) {
            newTransaction = false;
            suspended = t;
            t = null;
        } else {
            newTransaction = this.createNewTransaction(t, txScope);
            if (newTransaction) {
                suspended = t;
                int isoLevel = -1;
                TxIsolation isolation = txScope.getIsolation();
                if (isolation != null) {
                    isoLevel = isolation.getLevel();
                }
                t = this.transactionManager.createTransaction(true, isoLevel);
            }
        }
        this.transactionScopeManager.replace(t);
        return new ScopeTrans(this.rollbackOnChecked, newTransaction, t, txScope, suspended, this.transactionScopeManager);
    }

    @Override
    public SpiTransaction getCurrentServerTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TxScope.required());
    }

    @Override
    public Transaction beginTransaction(TxScope scope) {
        ScopeTrans scopeTrans = this.createScopeTrans(scope);
        return new ScopedTransaction(scopeTrans);
    }

    @Override
    public Transaction beginTransaction(TxIsolation isolation) {
        SpiTransaction t = this.transactionManager.createTransaction(true, isolation.getLevel());
        this.transactionScopeManager.set(t);
        return t;
    }

    @Override
    public Transaction currentTransaction() {
        return this.transactionScopeManager.get();
    }

    @Override
    public void commitTransaction() {
        this.transactionScopeManager.commit();
    }

    @Override
    public void rollbackTransaction() {
        this.transactionScopeManager.rollback();
    }

    @Override
    public void endTransaction() {
        this.transactionScopeManager.end();
    }

    @Override
    public Object nextId(Class<?> beanType) {
        BeanDescriptor<?> desc = this.getBeanDescriptor(beanType);
        return desc.nextId(null);
    }

    @Override
    public <T> void sort(List<T> list, String sortByClause) {
        if (list == null) {
            throw new NullPointerException("list is null");
        }
        if (sortByClause == null) {
            throw new NullPointerException("sortByClause is null");
        }
        if (list.isEmpty()) {
            return;
        }
        Class<?> beanType = list.get(0).getClass();
        BeanDescriptor<?> beanDescriptor = this.getBeanDescriptor(beanType);
        if (beanDescriptor == null) {
            throw new PersistenceException("BeanDescriptor not found, is [" + beanType + "] an entity bean?");
        }
        beanDescriptor.sort(list, sortByClause);
    }

    @Override
    public <T> Set<String> validateQuery(Query<T> query) {
        BeanDescriptor<T> beanDescriptor = this.getBeanDescriptor(query.getBeanType());
        if (beanDescriptor == null) {
            throw new PersistenceException("BeanDescriptor not found, is [" + query.getBeanType() + "] an entity bean?");
        }
        return ((SpiQuery)query).validate(beanDescriptor);
    }

    @Override
    public <T> Filter<T> filter(Class<T> beanType) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new ElFilter<T>(desc);
    }

    @Override
    public <T> CsvReader<T> createCsvReader(Class<T> beanType) {
        BeanDescriptor<T> descriptor = this.getBeanDescriptor(beanType);
        if (descriptor == null) {
            throw new NullPointerException("BeanDescriptor for " + beanType.getName() + " not found");
        }
        return new TCsvReader<T>(this, descriptor);
    }

    @Override
    public <T> UpdateQuery<T> update(Class<T> beanType) {
        return new DefaultUpdateQuery(this.createQuery((Class)beanType));
    }

    @Override
    public <T> Query<T> find(Class<T> beanType) {
        return this.createQuery((Class)beanType);
    }

    @Override
    public <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            throw new PersistenceException(beanType.getName() + " is NOT an Entity Bean registered with this server?");
        }
        String named = desc.getNamedQuery(namedQuery);
        if (named != null) {
            return this.createQuery(beanType, named);
        }
        RawSql rawSql = desc.getNamedRawSql(namedQuery);
        if (rawSql != null) {
            Query query = this.createQuery((Class)beanType);
            ((DefaultOrmQuery)query).setRawSql(rawSql);
            return query;
        }
        throw new PersistenceException("No named query called " + namedQuery + " for bean:" + beanType.getName());
    }

    @Override
    public <T> Query<T> createQuery(Class<T> beanType, String eql) {
        Query query = this.createQuery((Class)beanType);
        EqlParser.parse(eql, query);
        return query;
    }

    public <T> DefaultOrmQuery<T> createQuery(Class<T> beanType) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            throw new PersistenceException(beanType.getName() + " is NOT an Entity Bean registered with this server?");
        }
        return new DefaultOrmQuery<T>(desc, this, this.expressionFactory);
    }

    @Override
    public <T> Update<T> createUpdate(Class<T> beanType, String ormUpdate) {
        BeanDescriptor<T> desc = this.getBeanDescriptor(beanType);
        if (desc == null) {
            String m = beanType.getName() + " is NOT an Entity Bean registered with this server?";
            throw new PersistenceException(m);
        }
        return new DefaultOrmUpdate(beanType, this, desc.getBaseTable(), ormUpdate);
    }

    @Override
    public SqlQuery createSqlQuery(String sql) {
        return new DefaultRelationalQuery(this, sql);
    }

    @Override
    public SqlUpdate createSqlUpdate(String sql) {
        return new DefaultSqlUpdate(this, sql);
    }

    @Override
    public CallableSql createCallableSql(String sql) {
        return new DefaultCallableSql(this, sql);
    }

    @Override
    public <T> T find(Class<T> beanType, Object uid) {
        return this.find(beanType, uid, null);
    }

    @Override
    public <T> T find(Class<T> beanType, Object id, Transaction t) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        Query query = ((DefaultOrmQuery)this.createQuery((Class)beanType)).setId(id);
        return this.findId(query, t);
    }

    <T> SpiOrmQueryRequest<T> createQueryRequest(SpiQuery.Type type, Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(type);
        spiQuery.checkNamedParameters();
        return this.createQueryRequest(spiQuery, t);
    }

    private <T> SpiOrmQueryRequest<T> createQueryRequest(SpiQuery<T> query, Transaction t) {
        query.setDefaultRawSqlIfRequired();
        if (query.isAutoTunable() && !this.autoTuneService.tuneQuery(query)) {
            query.setDefaultSelectClause();
        }
        query.selectAllForLazyLoadProperty();
        if (query.getParentNode() == null) {
            query.setOrigin(this.createCallStack());
        }
        OrmQueryRequest<T> request = new OrmQueryRequest<T>(this, this.queryEngine, query, (SpiTransaction)t);
        request.prepareQuery();
        return request;
    }

    private <T> T findIdCheckPersistenceContextAndCache(Transaction transaction, SpiQuery<T> query, Object id) {
        PersistenceContext.WithOption o;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t == null) {
            t = this.getCurrentServerTransaction();
        }
        BeanDescriptor<T> desc = query.getBeanDescriptor();
        id = desc.convertId(id);
        PersistenceContext pc = null;
        if (t != null && this.useTransactionPersistenceContext(query) && (pc = t.getPersistenceContext()) != null && (o = desc.contextGetWithOption(pc, id)) != null) {
            if (o.isDeleted()) {
                return null;
            }
            return (T)o.getBean();
        }
        if (!query.isUseBeanCache() || t != null && t.isSkipCache()) {
            return null;
        }
        return desc.cacheBeanGet(id, query.isReadOnly(), pc);
    }

    private <T> boolean useTransactionPersistenceContext(SpiQuery<T> query) {
        return PersistenceContextScope.TRANSACTION.equals((Object)this.getPersistenceContextScope(query));
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope(SpiQuery<?> query) {
        PersistenceContextScope scope = query.getPersistenceContextScope();
        return scope != null ? scope : this.defaultPersistenceContextScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findId(Query<T> query, Transaction t) {
        T bean;
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setType(SpiQuery.Type.BEAN);
        if (SpiQuery.Mode.NORMAL.equals((Object)spiQuery.getMode()) && !spiQuery.isLoadBeanCache() && (bean = this.findIdCheckPersistenceContextAndCache(t, spiQuery, spiQuery.getId())) != null) {
            return bean;
        }
        SpiOrmQueryRequest<T> request = this.createQueryRequest(spiQuery, t);
        if (request.isUseDocStore()) {
            return this.docStore().find(request);
        }
        try {
            request.initTransIfRequired();
            Object object = request.findId();
            return (T)object;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> T findUnique(Query<T> query, Transaction transaction) {
        T bean;
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.checkIdEqualTo();
        Object id = spiQuery.getId();
        if (id != null) {
            return this.findId(query, transaction);
        }
        SpiTransaction t = (SpiTransaction)transaction;
        if (t == null) {
            t = this.getCurrentServerTransaction();
        }
        if (!(t != null && t.isSkipCache() || (id = spiQuery.getBeanDescriptor().cacheNaturalKeyIdLookup(spiQuery)) == null || (bean = this.findIdCheckPersistenceContextAndCache(t, spiQuery, id)) == null)) {
            return bean;
        }
        List<T> list = this.findList(query, (Transaction)t);
        return this.extractUnique(list);
    }

    private <T> T extractUnique(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException("Unique expecting 0 or 1 results but got [" + list.size() + "]");
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> findSet(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.SET, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Set)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Set<?> set = request.findSet();
            return set;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<?, T> findMap(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.MAP, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (Map)((Object)result);
        }
        try {
            request.initTransIfRequired();
            Map<?, ?> map = request.findMap();
            return map;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> int findCount(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findRowCountWithCopy(copy, t);
    }

    @Override
    public <T> int findRowCount(Query<T> query, Transaction t) {
        return this.findCount(query, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int findRowCountWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ROWCOUNT, query, t);
        try {
            request.initTransIfRequired();
            int n = request.findRowCount();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> List<Object> findIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        return this.findIdsWithCopy(copy, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Object> findIdsWithCopy(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ID_LIST, query, t);
        try {
            request.initTransIfRequired();
            List<Object> list = request.findIds();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int delete(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.DELETE, query, t);
        try {
            request.initTransIfRequired();
            request.markNotQueryOnly();
            int n = request.delete();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int update(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.UPDATE, query, t);
        try {
            request.initTransIfRequired();
            request.markNotQueryOnly();
            int n = request.update();
            return n;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public <T> FutureRowCount<T> findFutureCount(Query<T> q, Transaction t) {
        SpiQuery copy = ((SpiQuery)q).copy();
        copy.setFutureFetch(true);
        Transaction newTxn = this.createTransaction();
        CallableQueryRowCount call = new CallableQueryRowCount(this, copy, newTxn);
        QueryFutureRowCount queryFuture = new QueryFutureRowCount(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> FutureRowCount<T> findFutureRowCount(Query<T> q, Transaction t) {
        return this.findFutureCount(q, t);
    }

    @Override
    public <T> FutureIds<T> findFutureIds(Query<T> query, Transaction t) {
        SpiQuery copy = ((SpiQuery)query).copy();
        copy.setFutureFetch(true);
        List<Object> idList = Collections.synchronizedList(new ArrayList());
        copy.setIdList(idList);
        Transaction newTxn = this.createTransaction();
        CallableQueryIds call = new CallableQueryIds(this, copy, newTxn);
        QueryFutureIds queryFuture = new QueryFutureIds(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> FutureList<T> findFutureList(Query<T> query, Transaction t) {
        SpiQuery spiQuery = (SpiQuery)query;
        spiQuery.setFutureFetch(true);
        spiQuery.setPersistenceContext(new DefaultPersistenceContext());
        if (!spiQuery.isDisableReadAudit()) {
            BeanDescriptor desc = this.beanDescriptorManager.getBeanDescriptor(spiQuery.getBeanType());
            desc.readAuditFutureList(spiQuery);
        }
        Transaction newTxn = this.createTransaction();
        CallableQueryList call = new CallableQueryList(this, spiQuery, newTxn);
        QueryFutureList queryFuture = new QueryFutureList(call);
        this.backgroundExecutor.execute(queryFuture.getFutureTask());
        return queryFuture;
    }

    @Override
    public <T> PagedList<T> findPagedList(Query<T> query, Transaction transaction) {
        SpiQuery spiQuery = (SpiQuery)query;
        int maxRows = spiQuery.getMaxRows();
        if (maxRows == 0) {
            throw new PersistenceException("maxRows must be specified for findPagedList() query");
        }
        if (spiQuery.isUseDocStore()) {
            return this.docStore().findPagedList(this.createQueryRequest(SpiQuery.Type.LIST, query, transaction));
        }
        return new LimitOffsetPagedList(this, spiQuery);
    }

    @Override
    public <T> void findEach(Query<T> query, QueryEachConsumer<T> consumer, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, t);
        if (request.isUseDocStore()) {
            this.docStore().findEach(request, consumer);
            return;
        }
        request.initTransIfRequired();
        request.findEach(consumer);
    }

    @Override
    public <T> void findEachWhile(Query<T> query, QueryEachWhileConsumer<T> consumer, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.ITERATE, query, t);
        if (request.isUseDocStore()) {
            this.docStore().findEachWhile(request, consumer);
            return;
        }
        request.initTransIfRequired();
        request.findEachWhile(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Version<T>> findVersions(Query<T> query, Transaction transaction) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, transaction);
        try {
            request.initTransIfRequired();
            List<Version<T>> list = request.findVersions();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> findList(Query<T> query, Transaction t) {
        SpiOrmQueryRequest<T> request = this.createQueryRequest(SpiQuery.Type.LIST, query, t);
        BeanCollection<T> result = request.getFromQueryCache();
        if (result != null) {
            return (List)((Object)result);
        }
        if (request.isUseDocStore()) {
            return this.docStore().findList(request);
        }
        try {
            request.initTransIfRequired();
            List<T> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public SqlRow findUnique(SqlQuery query, Transaction t) {
        List<SqlRow> list = this.findList(query, t);
        return this.extractUnique(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findEach(SqlQuery query, QueryEachConsumer<SqlRow> consumer, Transaction transaction) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, transaction);
        try {
            request.initTransIfRequired();
            request.findEach(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findEachWhile(SqlQuery query, QueryEachWhileConsumer<SqlRow> consumer, Transaction transaction) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, transaction);
        try {
            request.initTransIfRequired();
            request.findEachWhile(consumer);
        }
        finally {
            request.endTransIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlRow> findList(SqlQuery query, Transaction t) {
        RelationalQueryRequest request = new RelationalQueryRequest(this, this.relationalQueryEngine, query, t);
        try {
            request.initTransIfRequired();
            List<SqlRow> list = request.findList();
            return list;
        }
        finally {
            request.endTransIfRequired();
        }
    }

    @Override
    public void save(Object bean) {
        this.save(bean, null);
    }

    @Override
    public void save(Object bean, Transaction t) {
        this.persister.save(this.checkEntityBean(bean), t);
    }

    @Override
    public void markAsDirty(Object bean) {
        if (!(bean instanceof EntityBean)) {
            throw new IllegalArgumentException("This bean is not an EntityBean?");
        }
        ((EntityBean)bean)._ebean_getIntercept().setDirty(true);
    }

    @Override
    public void update(Object bean) {
        this.update(bean, null);
    }

    @Override
    public void update(Object bean, Transaction t) {
        this.persister.update(this.checkEntityBean(bean), t);
    }

    @Override
    public void update(Object bean, Transaction t, boolean deleteMissingChildren) {
        this.persister.update(this.checkEntityBean(bean), t, deleteMissingChildren);
    }

    @Override
    public void updateAll(Collection<?> beans) throws OptimisticLockException {
        this.updateAll(beans, null);
    }

    @Override
    public void updateAll(Collection<?> beans, Transaction t) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            for (Object bean : beans) {
                this.update(this.checkEntityBean(bean), (Transaction)trans);
            }
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public void insert(Object bean) {
        this.insert(bean, null);
    }

    @Override
    public void insert(Object bean, Transaction t) {
        this.persister.insert(this.checkEntityBean(bean), t);
    }

    @Override
    public void insertAll(Collection<?> beans) {
        this.insertAll(beans, null);
    }

    @Override
    public void insertAll(Collection<?> beans, Transaction t) {
        if (beans == null || beans.isEmpty()) {
            return;
        }
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            for (Object bean : beans) {
                this.persister.insert(this.checkEntityBean(bean), trans);
            }
            wrap.commitIfCreated();
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public <T> List<T> publish(Query<T> query, Transaction transaction) {
        TransWrapper wrap = this.initTransIfRequired(transaction);
        try {
            SpiTransaction trans = wrap.transaction;
            List<T> liveBeans = this.persister.publish(query, trans);
            wrap.commitIfCreated();
            return liveBeans;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public <T> T publish(Class<T> beanType, Object id) {
        return this.publish(beanType, id, null);
    }

    @Override
    public <T> List<T> publish(Query<T> query) {
        return this.publish(query, null);
    }

    @Override
    public <T> T publish(Class<T> beanType, Object id, Transaction transaction) {
        Query<T> query = this.find(beanType).setId(id);
        List<T> liveBeans = this.publish(query, transaction);
        return liveBeans.size() == 1 ? (T)liveBeans.get(0) : null;
    }

    @Override
    public <T> List<T> draftRestore(Query<T> query, Transaction transaction) {
        TransWrapper wrap = this.initTransIfRequired(transaction);
        try {
            SpiTransaction trans = wrap.transaction;
            List<T> beans = this.persister.draftRestore(query, trans);
            wrap.commitIfCreated();
            return beans;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public <T> T draftRestore(Class<T> beanType, Object id, Transaction transaction) {
        Query<T> query = this.find(beanType).setId(id);
        List<T> beans = this.draftRestore(query, transaction);
        return beans.size() == 1 ? (T)beans.get(0) : null;
    }

    @Override
    public <T> T draftRestore(Class<T> beanType, Object id) {
        return this.draftRestore(beanType, id, null);
    }

    @Override
    public <T> List<T> draftRestore(Query<T> query) {
        return this.draftRestore(query, null);
    }

    private EntityBean checkEntityBean(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(Message.msg("bean.isnull"));
        }
        if (!(bean instanceof EntityBean)) {
            throw new IllegalArgumentException("Was expecting an EntityBean but got a " + bean.getClass());
        }
        return (EntityBean)bean;
    }

    @Override
    public int saveAll(Collection<?> beans, Transaction transaction) throws OptimisticLockException {
        return this.saveAllInternal(beans.iterator(), transaction);
    }

    @Override
    public int saveAll(Collection<?> beans) throws OptimisticLockException {
        return this.saveAllInternal(beans.iterator(), null);
    }

    public int saveAllInternal(Iterator<?> it, Transaction t) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            wrap.batchEscalateOnCollection();
            SpiTransaction trans = wrap.transaction;
            int saveCount = 0;
            while (it.hasNext()) {
                EntityBean bean = this.checkEntityBean(it.next());
                this.persister.save(bean, trans);
                ++saveCount;
            }
            wrap.commitIfCreated();
            wrap.flushBatchOnCollection();
            return saveCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int delete(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null);
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction t) {
        return this.delete(beanType, id, t, false);
    }

    @Override
    public int deletePermanent(Class<?> beanType, Object id) {
        return this.delete(beanType, id, null, true);
    }

    @Override
    public int deletePermanent(Class<?> beanType, Object id, Transaction t) {
        return this.delete(beanType, id, t, true);
    }

    private int delete(Class<?> beanType, Object id, Transaction t, boolean permanent) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int rowCount = this.persister.delete(beanType, id, trans, permanent);
            wrap.commitIfCreated();
            return rowCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int deleteAll(Class<?> beanType, Collection<?> ids) {
        return this.deleteAll(beanType, ids, null);
    }

    @Override
    public int deleteAll(Class<?> beanType, Collection<?> ids, Transaction t) {
        return this.deleteAll(beanType, ids, t, false);
    }

    @Override
    public int deleteAllPermanent(Class<?> beanType, Collection<?> ids) {
        return this.deleteAll(beanType, ids, null, true);
    }

    @Override
    public int deleteAllPermanent(Class<?> beanType, Collection<?> ids, Transaction t) {
        return this.deleteAll(beanType, ids, t, true);
    }

    private int deleteAll(Class<?> beanType, Collection<?> ids, Transaction t, boolean permanent) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            SpiTransaction trans = wrap.transaction;
            int count = this.persister.deleteMany(beanType, ids, trans, permanent);
            wrap.commitIfCreated();
            return count;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public boolean delete(Object bean) {
        return this.delete(bean, null);
    }

    @Override
    public boolean delete(Object bean, Transaction t) throws OptimisticLockException {
        return this.persister.delete(this.checkEntityBean(bean), t, false);
    }

    @Override
    public boolean deletePermanent(Object bean) throws OptimisticLockException {
        return this.deletePermanent(bean, null);
    }

    @Override
    public boolean deletePermanent(Object bean, Transaction t) throws OptimisticLockException {
        return this.persister.delete(this.checkEntityBean(bean), t, true);
    }

    @Override
    public int deleteAllPermanent(Collection<?> beans) {
        return this.deleteAllInternal(beans.iterator(), null, true);
    }

    @Override
    public int deleteAllPermanent(Collection<?> beans, Transaction t) {
        return this.deleteAllInternal(beans.iterator(), t, true);
    }

    @Override
    public int deleteAll(Collection<?> beans) {
        return this.deleteAllInternal(beans.iterator(), null, false);
    }

    @Override
    public int deleteAll(Collection<?> beans, Transaction t) {
        return this.deleteAllInternal(beans.iterator(), t, false);
    }

    private int deleteAllInternal(Iterator<?> it, Transaction t, boolean permanent) {
        TransWrapper wrap = this.initTransIfRequired(t);
        try {
            wrap.batchEscalateOnCollection();
            SpiTransaction trans = wrap.transaction;
            int deleteCount = 0;
            while (it.hasNext()) {
                EntityBean bean = this.checkEntityBean(it.next());
                this.persister.delete(bean, trans, permanent);
                ++deleteCount;
            }
            wrap.commitIfCreated();
            wrap.flushBatchOnCollection();
            return deleteCount;
        }
        catch (RuntimeException e) {
            wrap.rollbackIfCreated();
            throw e;
        }
    }

    @Override
    public int execute(CallableSql callSql, Transaction t) {
        return this.persister.executeCallable(callSql, t);
    }

    @Override
    public int execute(CallableSql callSql) {
        return this.execute(callSql, null);
    }

    @Override
    public int execute(SqlUpdate updSql, Transaction t) {
        return this.persister.executeSqlUpdate(updSql, t);
    }

    @Override
    public int execute(SqlUpdate updSql) {
        return this.execute(updSql, null);
    }

    @Override
    public int execute(Update<?> update, Transaction t) {
        return this.persister.executeOrmUpdate(update, t);
    }

    @Override
    public int execute(Update<?> update) {
        return this.execute(update, null);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors() {
        return this.beanDescriptorManager.getBeanDescriptorList();
    }

    public void register(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).register(c);
        }
    }

    public void deregister(BeanPersistController c) {
        List<BeanDescriptor<?>> list = this.beanDescriptorManager.getBeanDescriptorList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).deregister(c);
        }
    }

    @Override
    public boolean isSupportedType(Type genericType) {
        ParamTypeHelper.TypeInfo typeInfo = ParamTypeHelper.getTypeInfo(genericType);
        return typeInfo != null && this.getBeanDescriptor(typeInfo.getBeanType()) != null;
    }

    @Override
    public Object setBeanId(Object bean, Object id) {
        EntityBean eb = this.checkEntityBean(bean);
        BeanDescriptor<?> desc = this.getBeanDescriptor(bean.getClass());
        if (desc == null) {
            throw new PersistenceException(bean.getClass().getName() + " is NOT an Entity Bean registered with this server?");
        }
        return desc.convertSetId(id, eb);
    }

    @Override
    public Object getBeanId(Object bean) {
        EntityBean eb = this.checkEntityBean(bean);
        BeanDescriptor<?> desc = this.getBeanDescriptor(bean.getClass());
        if (desc == null) {
            throw new PersistenceException(bean.getClass().getName() + " is NOT an Entity Bean registered with this server?");
        }
        return desc.getId(eb);
    }

    @Override
    public <T> BeanDescriptor<T> getBeanDescriptor(Class<T> beanClass) {
        return this.beanDescriptorManager.getBeanDescriptor(beanClass);
    }

    @Override
    public List<BeanDescriptor<?>> getBeanDescriptors(String tableName) {
        return this.beanDescriptorManager.getBeanDescriptors(tableName);
    }

    @Override
    public List<? extends BeanType<?>> getBeanTypes() {
        return this.getBeanDescriptors();
    }

    @Override
    public List<? extends BeanType<?>> getBeanTypes(String tableName) {
        return this.beanDescriptorManager.getBeanTypes(tableName);
    }

    @Override
    public BeanType<?> getBeanTypeForQueueId(String queueId) {
        return this.getBeanDescriptorByQueueId(queueId);
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptorByQueueId(String queueId) {
        return this.beanDescriptorManager.getBeanDescriptorByQueueId(queueId);
    }

    @Override
    public <T> BeanType<T> getBeanType(Class<T> beanType) {
        return this.getBeanDescriptor(beanType);
    }

    @Override
    public BeanDescriptor<?> getBeanDescriptorById(String beanClassName) {
        return this.beanDescriptorManager.getBeanDescriptorByClassName(beanClassName);
    }

    @Override
    public void remoteTransactionEvent(RemoteTransactionEvent event) {
        this.transactionManager.remoteTransactionEvent(event);
    }

    TransWrapper initTransIfRequired(Transaction t) {
        if (t != null) {
            return new TransWrapper((SpiTransaction)t, false);
        }
        boolean wasCreated = false;
        SpiTransaction trans = this.transactionScopeManager.get();
        if (trans == null) {
            trans = this.transactionManager.createTransaction(false, -1);
            wasCreated = true;
        }
        return new TransWrapper(trans, wasCreated);
    }

    @Override
    public SpiTransaction createServerTransaction(boolean isExplicit, int isolationLevel) {
        return this.transactionManager.createTransaction(isExplicit, isolationLevel);
    }

    @Override
    public SpiTransaction createQueryTransaction() {
        return this.transactionManager.createQueryTransaction();
    }

    @Override
    public CallStack createCallStack() {
        int startIndex;
        Object[] stackTrace = Thread.currentThread().getStackTrace();
        for (startIndex = 5; startIndex < stackTrace.length && stackTrace[startIndex].getClassName().startsWith(COM_AVAJE_EBEAN); ++startIndex) {
        }
        while (startIndex < stackTrace.length && stackTrace[startIndex].getClassName().startsWith(ORG_AVAJE_EBEAN)) {
            ++startIndex;
        }
        int stackLength = stackTrace.length - startIndex;
        if (stackLength > this.maxCallStack) {
            stackLength = this.maxCallStack;
        }
        StackTraceElement[] finalTrace = new StackTraceElement[stackLength];
        System.arraycopy(stackTrace, startIndex, finalTrace, 0, stackLength);
        if (stackLength < 1) {
            throw new RuntimeException("StackTraceElement size 0?  stack: " + Arrays.toString(stackTrace));
        }
        return this.callStackFactory.createCallStack(finalTrace);
    }

    @Override
    public DocumentStore docStore() {
        return this.documentStore;
    }

    @Override
    public JsonContext json() {
        return this.jsonContext;
    }

    @Override
    public void collectQueryStats(ObjectGraphNode node, long loadedBeanCount, long timeMicros) {
        if (this.collectQueryStatsByNode) {
            CObjectGraphNodeStatistics nodeStatistics = this.objectGraphStats.get(node);
            if (nodeStatistics == null) {
                nodeStatistics = new CObjectGraphNodeStatistics(node);
                this.objectGraphStats.put(node, nodeStatistics);
            }
            nodeStatistics.add(loadedBeanCount, timeMicros);
        }
    }
}

