/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.LoadManyRequest;
import com.avaje.ebeaninternal.api.LoadRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanLoader {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBeanLoader.class);
    private final DefaultServer server;
    private final boolean onIterateUseExtraTxn;

    protected DefaultBeanLoader(DefaultServer server) {
        this.server = server;
        this.onIterateUseExtraTxn = server.getDatabasePlatform().useExtraTransactionOnIterateSecondaryQueries();
    }

    private int getBatchSize(int batchSize) {
        if (batchSize == 1) {
            return 1;
        }
        if (batchSize <= 5) {
            return 5;
        }
        if (batchSize <= 10) {
            return 10;
        }
        if (batchSize <= 20) {
            return 20;
        }
        if (batchSize <= 50) {
            return 50;
        }
        if (batchSize <= 100) {
            return 100;
        }
        return batchSize;
    }

    public void refreshMany(EntityBean parentBean, String propertyName) {
        this.refreshMany(parentBean, propertyName, null);
    }

    public void loadMany(LoadManyRequest loadRequest) {
        List<BeanCollection<?>> batch = loadRequest.getBatch();
        int batchSize = this.getBatchSize(batch.size());
        SpiQuery<?> query = loadRequest.createQuery(this.server, batchSize);
        this.executeQuery(loadRequest, query);
        loadRequest.postLoad();
        loadRequest.logSecondaryQuery(query);
    }

    public void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        EntityBean parentBean = bc.getOwnerBean();
        String propertyName = bc.getPropertyName();
        this.loadManyInternal(parentBean, propertyName, null, false, onlyIds);
    }

    public void refreshMany(EntityBean parentBean, String propertyName, Transaction t) {
        this.loadManyInternal(parentBean, propertyName, t, true, false);
    }

    private void loadManyInternal(EntityBean parentBean, String propertyName, Transaction t, boolean refresh, boolean onlyIds) {
        boolean useManyIdCache;
        EntityBeanIntercept ebi = parentBean._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        BeanDescriptor<?> parentDesc = this.server.getBeanDescriptor(parentBean.getClass());
        BeanPropertyAssocMany many = (BeanPropertyAssocMany)parentDesc.getBeanProperty(propertyName);
        BeanCollection beanCollection = null;
        ExpressionList<?> filterMany = null;
        Object currentValue = many.getValue(parentBean);
        if (currentValue instanceof BeanCollection) {
            beanCollection = (BeanCollection)currentValue;
            filterMany = beanCollection.getFilterMany();
        }
        Object parentId = parentDesc.getId(parentBean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            parentDesc.contextPut(pc, parentId, parentBean);
        }
        boolean bl = useManyIdCache = beanCollection != null && parentDesc.isManyPropCaching();
        if (useManyIdCache) {
            Boolean readOnly = null;
            if (ebi.isReadOnly()) {
                readOnly = Boolean.TRUE;
            }
            if (parentDesc.cacheManyPropLoad(many, beanCollection, parentId, readOnly)) {
                return;
            }
        }
        Query query = this.server.createQuery((Class)parentDesc.getBeanType());
        if (refresh) {
            BeanCollection emptyCollection = many.createEmpty(parentBean);
            many.setValue(parentBean, emptyCollection);
            query.setLoadDescription("+refresh", null);
        } else {
            query.setLoadDescription("+lazy", null);
        }
        String idProperty = parentDesc.getIdBinder().getIdProperty();
        query.select(idProperty);
        if (onlyIds) {
            query.fetch(many.getName(), many.getTargetIdProperty());
        } else {
            query.fetch(many.getName());
        }
        if (filterMany != null) {
            query.setFilterMany(many.getName(), filterMany);
        }
        query.where().idEq(parentId);
        query.setUseCache(false);
        query.setMode(SpiQuery.Mode.LAZYLOAD_MANY);
        query.setLazyLoadManyPath(many.getName());
        query.setPersistenceContext(pc);
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        this.server.findUnique(query, t);
        if (beanCollection != null) {
            if (beanCollection.checkEmptyLazyLoad()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("BeanCollection after load was empty. Owner:" + beanCollection.getOwnerBean());
                }
            } else if (useManyIdCache) {
                parentDesc.cacheManyPropPut(many, beanCollection, parentId);
            }
        }
    }

    public void loadBean(LoadBeanRequest loadRequest) {
        List<EntityBeanIntercept> batch = loadRequest.getBatch();
        if (batch.isEmpty()) {
            throw new RuntimeException("Nothing in batch?");
        }
        int batchSize = this.getBatchSize(batch.size());
        List<Object> idList = loadRequest.getIdList(batchSize);
        if (idList.isEmpty()) {
            return;
        }
        Query query = this.server.createQuery((Class)loadRequest.getBeanType());
        loadRequest.configureQuery((SpiQuery<?>)query, idList);
        List<?> list = this.executeQuery(loadRequest, (SpiQuery<?>)query);
        loadRequest.postLoad(list);
        loadRequest.logSecondaryQuery((SpiQuery<?>)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> executeQuery(LoadRequest loadRequest, SpiQuery<?> query) {
        if (this.onIterateUseExtraTxn && loadRequest.isParentFindIterate()) {
            SpiTransaction extraTxn = this.server.createQueryTransaction();
            try {
                List<?> list = this.server.findList(query, (Transaction)extraTxn);
                return list;
            }
            finally {
                extraTxn.end();
            }
        }
        return this.server.findList(query, loadRequest.getTransaction());
    }

    public void refresh(EntityBean bean) {
        this.refreshBeanInternal(bean, SpiQuery.Mode.REFRESH_BEAN, -1);
    }

    public void loadBean(EntityBeanIntercept ebi) {
        this.refreshBeanInternal(ebi.getOwner(), SpiQuery.Mode.LAZYLOAD_BEAN, -1);
    }

    private void refreshBeanInternal(EntityBean bean, SpiQuery.Mode mode, int embeddedOwnerIndex) {
        Object dbBean;
        BeanDescriptor<?> desc;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        PersistenceContext pc = ebi.getPersistenceContext();
        if (SpiQuery.Mode.REFRESH_BEAN == mode) {
            pc = null;
        }
        if (BeanDescriptor.EntityType.EMBEDDED == (desc = this.server.getBeanDescriptor(bean.getClass())).getEntityType()) {
            EntityBean embeddedOwner = (EntityBean)ebi.getEmbeddedOwner();
            int ownerIndex = ebi.getEmbeddedOwnerIndex();
            this.refreshBeanInternal(embeddedOwner, mode, ownerIndex);
        }
        Object id = desc.getId(bean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            desc.contextPut(pc, id, bean);
            ebi.setPersistenceContext(pc);
        }
        boolean draft = desc.isDraftInstance(bean);
        if (embeddedOwnerIndex == -1) {
            if (desc.lazyLoadMany(ebi)) {
                return;
            }
            if (!draft && SpiQuery.Mode.LAZYLOAD_BEAN.equals((Object)mode) && desc.isBeanCaching() && desc.cacheBeanLoad(bean, ebi, id, pc)) {
                return;
            }
        }
        Query query = this.server.createQuery((Class)desc.getBeanType());
        query.setLazyLoadProperty(ebi.getLazyLoadProperty());
        if (draft) {
            query.asDraft();
        }
        if (embeddedOwnerIndex > -1) {
            query.select("id," + ebi.getProperty(embeddedOwnerIndex));
        }
        query.setUsageProfiling(false);
        query.setPersistenceContext(pc);
        query.setMode(mode);
        query.setId(id);
        if (embeddedOwnerIndex > -1 || mode.equals((Object)SpiQuery.Mode.REFRESH_BEAN)) {
            query.setUseCache(false);
        }
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        if (SpiQuery.Mode.REFRESH_BEAN.equals((Object)mode)) {
            query.select("*");
        }
        if ((dbBean = query.findUnique()) == null) {
            String msg = "Bean not found during lazy load or refresh. id[" + id + "] type[" + desc.getBeanType() + "]";
            throw new EntityNotFoundException(msg);
        }
        desc.resetManyProperties(dbBean);
    }
}

