/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebeaninternal.server.cluster.ClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.ClusterBroadcastFactory;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    private static final Logger clusterLogger = LoggerFactory.getLogger((String)"org.avaje.ebean.Cluster");
    private static final Logger logger = LoggerFactory.getLogger(ClusterManager.class);
    private final ConcurrentHashMap<String, EbeanServer> serverMap = new ConcurrentHashMap();
    private final Object monitor = new Object();
    private final ClusterBroadcast broadcast;
    private boolean started;

    public ClusterManager(ContainerConfig config) {
        if (!config.isClusterActive()) {
            this.broadcast = null;
        } else {
            ClusterBroadcastFactory factory = this.createFactory();
            this.broadcast = factory.create(this, config.getProperties());
        }
    }

    private ClusterBroadcastFactory createFactory() {
        ServiceLoader<ClusterBroadcastFactory> load = ServiceLoader.load(ClusterBroadcastFactory.class);
        ClusterBroadcastFactory factory = null;
        Iterator<ClusterBroadcastFactory> iterator = load.iterator();
        if (iterator.hasNext()) {
            factory = iterator.next();
        }
        if (factory == null) {
            throw new IllegalStateException("No ClusterTransportFactory found in classpath.  Probably need to add the avaje-ebeanorm-cluster dependency");
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServer(EbeanServer server) {
        Object object = this.monitor;
        synchronized (object) {
            this.serverMap.put(server.getName(), server);
            if (!this.started) {
                this.startup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EbeanServer getServer(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.serverMap.get(name);
        }
    }

    private void startup() {
        this.started = true;
        if (this.broadcast != null) {
            this.broadcast.startup();
        }
    }

    public boolean isClustering() {
        return this.broadcast != null;
    }

    public void broadcast(RemoteTransactionEvent event) {
        if (this.broadcast != null) {
            if (clusterLogger.isDebugEnabled()) {
                clusterLogger.debug("sending: {}", (Object)event);
            }
            this.broadcast.broadcast(event);
        }
    }

    public void shutdown() {
        if (this.broadcast != null) {
            logger.info("ClusterManager shutdown ");
            this.broadcast.shutdown();
        }
    }
}

