/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCacheStatistics;
import com.avaje.ebeaninternal.server.util.LongAdder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerCache
implements ServerCache {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultServerCache.class);
    public static final CompareByLastAccess BY_LAST_ACCESS = new CompareByLastAccess();
    protected final Map<Object, CacheEntry> map;
    protected final LongAdder missCount = new LongAdder();
    protected final LongAdder hitCount = new LongAdder();
    protected final LongAdder insertCount = new LongAdder();
    protected final LongAdder updateCount = new LongAdder();
    protected final LongAdder removeCount = new LongAdder();
    protected final LongAdder clearCount = new LongAdder();
    protected final LongAdder evictByIdle = new LongAdder();
    protected final LongAdder evictByTTL = new LongAdder();
    protected final LongAdder evictByLRU = new LongAdder();
    protected final LongAdder evictCount = new LongAdder();
    protected final LongAdder evictMicros = new LongAdder();
    protected final Object monitor = new Object();
    protected final String name;
    protected int maxSize;
    protected final int trimFrequency;
    protected int maxIdleSecs;
    protected int maxSecsToLive;

    public DefaultServerCache(String name, ServerCacheOptions options) {
        this(name, new ConcurrentHashMap<Object, CacheEntry>(), options);
    }

    public DefaultServerCache(String name, Map<Object, CacheEntry> map, ServerCacheOptions options) {
        this(name, map, options.getMaxSize(), options.getMaxIdleSecs(), options.getMaxSecsToLive(), options.getTrimFrequency());
    }

    public DefaultServerCache(String name, Map<Object, CacheEntry> map, int maxSize, int maxIdleSecs, int maxSecsToLive, int trimFrequency) {
        this.name = name;
        this.map = map;
        this.maxSize = maxSize;
        this.maxIdleSecs = maxIdleSecs;
        this.maxSecsToLive = maxSecsToLive;
        this.trimFrequency = this.determineTrim(maxIdleSecs, maxSecsToLive, trimFrequency);
    }

    int determineTrim(int maxIdleSecs, int maxSecsToLive, int trimFrequency) {
        if (trimFrequency > 0) {
            return trimFrequency;
        }
        if (maxIdleSecs > 0) {
            return maxIdleSecs / 2 - 1;
        }
        if (maxSecsToLive > 0) {
            return maxSecsToLive / 2 - 1;
        }
        return 0;
    }

    public void periodicTrim(BackgroundExecutor executor) {
        EvictionRunnable trim = new EvictionRunnable();
        long trimFreqSecs = this.trimFrequency == 0 ? 60L : (long)this.trimFrequency;
        executor.executePeriodically(trim, trimFreqSecs, TimeUnit.SECONDS);
    }

    @Override
    public ServerCacheStatistics getStatistics(boolean reset) {
        ServerCacheStatistics cacheStats = new ServerCacheStatistics();
        cacheStats.setCacheName(this.name);
        cacheStats.setMaxSize(this.maxSize);
        long clear = reset ? this.clearCount.sumThenReset() : this.clearCount.sum();
        long remove = reset ? this.removeCount.sumThenReset() : this.removeCount.sum();
        long update = reset ? this.updateCount.sumThenReset() : this.updateCount.sum();
        long insert = reset ? this.insertCount.sumThenReset() : this.insertCount.sum();
        long miss = reset ? this.missCount.sumThenReset() : this.missCount.sum();
        long hit = reset ? this.hitCount.sumThenReset() : this.hitCount.sum();
        long evict = reset ? this.evictCount.sumThenReset() : this.evictCount.sum();
        long evictTime = reset ? this.evictMicros.sumThenReset() : this.evictMicros.sum();
        long evictIdle = reset ? this.evictByIdle.sumThenReset() : this.evictByIdle.sum();
        long evictTTL = reset ? this.evictByTTL.sumThenReset() : this.evictByTTL.sum();
        long evictLRU = reset ? this.evictByLRU.sumThenReset() : this.evictByLRU.sum();
        int size = this.size();
        cacheStats.setSize(size);
        cacheStats.setHitCount(hit);
        cacheStats.setMissCount(miss);
        cacheStats.setInsertCount(insert);
        cacheStats.setUpdateCount(update);
        cacheStats.setRemoveCount(remove);
        cacheStats.setClearCount(clear);
        cacheStats.setEvictionRunCount(evict);
        cacheStats.setEvictionRunMicros(evictTime);
        cacheStats.setEvictByIdle(evictIdle);
        cacheStats.setEvictByTTL(evictTTL);
        cacheStats.setEvictByLRU(evictLRU);
        return cacheStats;
    }

    @Override
    public int getHitRatio() {
        long mc = this.missCount.sum();
        long hc = this.hitCount.sum();
        long totalCount = hc + mc;
        if (totalCount == 0L) {
            return 0;
        }
        return (int)(hc * 100L / totalCount);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.clearCount.increment();
        this.map.clear();
    }

    @Override
    public Object get(Object key) {
        CacheEntry entry = this.map.get(key);
        if (entry == null) {
            this.missCount.increment();
            return null;
        }
        this.hitCount.increment();
        return entry.getValue();
    }

    @Override
    public Object put(Object key, Object value) {
        CacheEntry entry = this.map.put(key, new CacheEntry(key, value));
        if (entry == null) {
            this.insertCount.increment();
            return null;
        }
        this.updateCount.increment();
        return entry.getValue();
    }

    @Override
    public Object remove(Object key) {
        CacheEntry entry = this.map.remove(key);
        if (entry == null) {
            return null;
        }
        this.removeCount.increment();
        return entry.getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    protected int getTrimSize() {
        return this.maxSize * 90 / 100;
    }

    public void runEviction() {
        long trimForMaxSize = this.maxSize == 0 ? 0L : (long)(this.size() - this.maxSize);
        if (this.maxIdleSecs == 0 && this.maxSecsToLive == 0 && trimForMaxSize < 0L) {
            return;
        }
        long startNanos = System.nanoTime();
        long trimmedByIdle = 0L;
        long trimmedByTTL = 0L;
        long trimmedByLRU = 0L;
        ArrayList<CacheEntry> activeList = new ArrayList<CacheEntry>();
        long idleExpire = System.currentTimeMillis() - (long)(this.maxIdleSecs * 1000);
        long ttlExpire = System.currentTimeMillis() - (long)(this.maxSecsToLive * 1000);
        Iterator<CacheEntry> it = this.map.values().iterator();
        while (it.hasNext()) {
            CacheEntry cacheEntry = it.next();
            if (this.maxIdleSecs > 0 && idleExpire > cacheEntry.getLastAccessTime()) {
                it.remove();
                ++trimmedByIdle;
                continue;
            }
            if (this.maxSecsToLive > 0 && ttlExpire > cacheEntry.getCreateTime()) {
                it.remove();
                ++trimmedByTTL;
                continue;
            }
            if (trimForMaxSize <= 0L) continue;
            activeList.add(cacheEntry);
        }
        if (trimForMaxSize > 0L && (trimmedByLRU = (long)(activeList.size() - this.maxSize)) > 0L) {
            int trimSize;
            Collections.sort(activeList, BY_LAST_ACCESS);
            for (int i = trimSize = this.getTrimSize(); i < activeList.size(); ++i) {
                this.map.remove(((CacheEntry)activeList.get(i)).getKey());
            }
        }
        long exeNanos = System.nanoTime() - startNanos;
        long exeMicros = TimeUnit.MICROSECONDS.convert(exeNanos, TimeUnit.NANOSECONDS);
        this.evictMicros.add(exeMicros);
        this.evictCount.increment();
        this.evictByIdle.add(trimmedByIdle);
        this.evictByTTL.add(trimmedByTTL);
        this.evictByLRU.add(trimmedByLRU);
        if (logger.isTraceEnabled()) {
            logger.trace("Executed trim of cache {} in [{}]millis idle[{}] timeToLive[{}] accessTime[{}]", new Object[]{this.name, exeMicros, trimmedByIdle, trimmedByTTL, trimmedByLRU});
        }
    }

    public static class CacheEntry {
        private final Object key;
        private final Object value;
        private final long createTime;
        private long lastAccessTime;

        public CacheEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
            this.lastAccessTime = this.createTime = System.currentTimeMillis();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.value;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }
    }

    public static class CompareByLastAccess
    implements Comparator<CacheEntry>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(CacheEntry entry1, CacheEntry entry2) {
            long y;
            long x = entry1.getLastAccessTime();
            return x < (y = entry2.getLastAccessTime()) ? -1 : (x == y ? 0 : 1);
        }
    }

    public class EvictionRunnable
    implements Runnable {
        @Override
        public void run() {
            DefaultServerCache.this.runEviction();
        }
    }
}

