/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebeaninternal.server.cache.CachedBeanData;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import java.util.LinkedHashMap;

public class CachedBeanDataFromBean {
    public static CachedBeanData extract(BeanDescriptor<?> desc, EntityBean bean) {
        int propertyIndex;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        BeanProperty idProperty = desc.getIdProperty();
        if (idProperty != null && ebi.isLoadedProperty(propertyIndex = idProperty.getPropertyIndex())) {
            data.put(idProperty.getName(), idProperty.getCacheDataValue(bean));
        }
        BeanProperty[] props = desc.propertiesNonMany();
        for (int i = 0; i < props.length; ++i) {
            BeanProperty prop = props[i];
            if (!ebi.isLoadedProperty(prop.getPropertyIndex())) continue;
            data.put(prop.getName(), prop.getCacheDataValue(bean));
        }
        long version = desc.getVersion(bean);
        EntityBean sharableBean = CachedBeanDataFromBean.createSharableBean(desc, bean, ebi);
        return new CachedBeanData(sharableBean, desc.getDiscValue(), data, version);
    }

    private static EntityBean createSharableBean(BeanDescriptor<?> desc, EntityBean bean, EntityBeanIntercept beanEbi) {
        if (!desc.isCacheSharableBeans() || !beanEbi.isFullyLoadedBean()) {
            return null;
        }
        if (beanEbi.isReadOnly()) {
            return bean;
        }
        EntityBean sharableBean = desc.createEntityBean();
        BeanProperty idProp = desc.getIdProperty();
        if (idProp != null) {
            Object v = idProp.getValue(bean);
            idProp.setValue(sharableBean, v);
        }
        BeanProperty[] propertiesNonTransient = desc.propertiesNonTransient();
        for (int i = 0; i < propertiesNonTransient.length; ++i) {
            Object v = propertiesNonTransient[i].getValue(bean);
            propertiesNonTransient[i].setValue(sharableBean, v);
        }
        EntityBeanIntercept intercept = sharableBean._ebean_intercept();
        intercept.setReadOnly(true);
        intercept.setLoaded();
        return sharableBean;
    }
}

